package gov.va.med.edp.command
{
	import com.adobe.cairngorm.commands.ICommand;
	import com.adobe.cairngorm.control.CairngormEvent;
	
	import gov.va.med.edp.business.GetVitalsDelegate;
	import gov.va.med.edp.control.GetVitalsEvent;
	import gov.va.med.edp.factory.TrackingFactory;
	import gov.va.med.edp.model.TrackingModelLocator;
	import gov.va.med.edp.vo.VitalsVO;
	import mx.collections.ArrayCollection;
	
	import mx.rpc.IResponder;
	import mx.rpc.events.FaultEvent;
	import mx.rpc.events.ResultEvent;
	import mx.controls.Alert;
	import gov.va.med.edp.control.worksheet.WorkSheetWidgetEvent;
	import gov.va.med.edp.cpe.view.vitals.VitalsXml;
	
	/**
	 * This command class communicates with the VistA RPC to retrieve patient vital measurements with timestamps.
	 * 
	 */
	public class GetVitalsCommand extends AbstractNotificationCommand
	{
		private var model:TrackingModelLocator = TrackingModelLocator.getInstance();
		protected var loadEvent: GetVitalsEvent;		
		/**
		 *   Constructor.
		 */
		public function GetVitalsCommand() 
		{
			super();
		}
		/**
		 *   event execution
		 */
		public override function execute(event:CairngormEvent): void
		{
			super.execute(event);
			
			loadEvent = GetVitalsEvent(event);
			
			var delegate:GetVitalsDelegate = new GetVitalsDelegate(this);
			
			var dfn:String = model.logEdit.entry.dfn; 
			//Alert.show("GetVitalsCommand dfn = " + dfn);
			delegate.getVitals(dfn);
	
		}

		/**
		 * Methods to parse result.
		 */
		public override function result(data:Object): void
		{
			var xml:XML = ResultEvent(data).result as XML;
			var vitalNode:XML = xml.Vitals[0];
			model.vitalsModel.patientDfn = vitalNode.@dfn;
			//model.vitalsModel.trackVitals = VitalsXml.buildTrackVitals(vitalsXml.TrackVitals);
			//model.vitalsModel.vitals = VitalsXml.buildVitals(xml.Vitals);
			//Alert.show("GetVitalsCommand result = " + xml);
			var vitals: ArrayCollection = new ArrayCollection();
			
			vitals = VitalsXml.buildVitals(xml.Vitals);
			
			for each (var item:VitalsVO in vitals) {
				model.vitalsModel.vitals.addItem(item);	
			}
			
			model.vitalsSaved = false;
			
			notifyCaller(data);
			
			if (model.vitalsModel.vitals.length == 0) {
				
				var noResultsEvent:WorkSheetWidgetEvent = new WorkSheetWidgetEvent(WorkSheetWidgetEvent.NO_RESULTS,loadEvent.type);
				noResultsEvent.dispatch();

			}
			
		}

	} // class
} // package