package gov.va.med.edp.command
{
	import com.adobe.cairngorm.commands.ICommand;
	import com.adobe.cairngorm.control.CairngormEvent;
	
	import gov.va.med.edp.business.GetDetailsDelegate;
	import gov.va.med.edp.control.DetailsEvent;
	import gov.va.med.edp.factory.TrackingFactory;
	import gov.va.med.edp.model.TrackingModelLocator;
	import gov.va.med.edp.vo.reports.PtDemographicsVO;
	
	import mx.controls.Alert;
	import mx.rpc.IResponder;
	import mx.rpc.events.FaultEvent;
	import mx.rpc.events.ResultEvent;
	import flash.events.Event;
	
	/**
	 * This command class communicates with the VistA RPC to get patient detail data.
	 * 
	 */
	public class GetDetailsCommand extends AbstractNotificationCommand 
	{
		protected var model:TrackingModelLocator = TrackingModelLocator.getInstance();
		
		private namespace self;
		private var viewHandlers  : IResponder = null;
		protected var loadEvent: DetailsEvent;
		
		/**
		 *   Constructor.
		 */
		public function GetDetailsCommand() 
		{
			super();
		}
		/**
		 *   event execution
		 */
		public override function execute(event:CairngormEvent): void
		{				
			
			super.execute(event);
			
			loadEvent = DetailsEvent(event);
			var delegate:GetDetailsDelegate = new GetDetailsDelegate(this);
			var xml:XML;
			
			//Alert.show("GetDetailsCommand model.logEdit.entry.id = " + model.logEdit.entry.id + " loadEvent : " + loadEvent.type);
			
			if (loadEvent.xml != null) {
				xml = loadEvent.xml;
				var id:Number = xml.@id;
				delegate.getDetails(id,loadEvent);		
			}
			else {
				delegate.getDetails(model.logEdit.entry.id,loadEvent);
			}
		}		
		
		protected override function getFaultMessage(faultEvent:FaultEvent):String {
			return "Error Loading Details: " + super.getFaultMessage(faultEvent);

		}		
		
	} // class
} // package