/* DeleteStubEntryCommand.as */
	
package gov.va.med.edp.command
{
	import com.adobe.cairngorm.commands.ICommand;
	import com.adobe.cairngorm.control.CairngormEvent;
	
	import gov.va.med.edp.business.DeleteStubEntryDelegate;
	import gov.va.med.edp.control.TrackingEvent;
	import gov.va.med.edp.model.TrackingModelLocator;
	import gov.va.med.edp.widget.InfoDialog;
	
	import mx.rpc.IResponder;
	import mx.rpc.events.FaultEvent;
	import mx.rpc.events.ResultEvent;

	/**
	 * This command class communicates with the VistA RPC to delete empty entries from the log.
	 * 
	 */
	public class DeleteStubEntryCommand extends AbstractResponderCommand implements ICommand, IResponder
	{
		private var model:TrackingModelLocator = TrackingModelLocator.getInstance();
				
		/**
		 *   Constructor.
		 */
		public function DeleteStubEntryCommand() 
		{
		}
		/**
		 *   event execution
		 */
		public function execute(event:CairngormEvent):void
		{
			var delegate: DeleteStubEntryDelegate = new DeleteStubEntryDelegate(this);
			if (model.logEdit.entry.isStub) {
				model.logEdit.dirty = false;
				delegate.deleteStubEntry(model.logArea, model.logEdit.entry.id);
			}
		}
		/**
		 * Handle the successful return of the service call.
		 * 
		 * @param data The payload from the service call.
		 */
		public override function result(data:Object):void
		{
			var xml:XML = ResultEvent(data).result as XML;

			if (xml.upd.@status == "fail") {
				InfoDialog.show("Cancel failed: " + xml.upd.@msg);
				model.logEdit.dirty = true;
				model.synchToLastEntry();
			} else {
				model.logEdit.resetEntry();
				model.logEdit.message = "No visit currently selected.";
				model.logEditMessageFontSize = 10;
				model.isNew = false;
				//model.logEntryViewState = TrackingModelLocator.VIEW_EDIT_MESSAGE;
				model.logEntryList.selectedIndex = -1;
				model.logEntryList.selectedID = 0;
				
				var e: TrackingEvent = new TrackingEvent(TrackingEvent.EVENT_REFRESH_LOG_SELECTOR);
				e.dispatch();
			}
		}
		protected override function getFaultMessage(faultEvent:FaultEvent):String {
			return "Cancelling log entry failed: " + super.getFaultMessage(faultEvent);
		}
		
		public override function fault(info:Object):void
		{
			model.logEdit.dirty = true;
			model.synchToLastEntry();
			super.fault(info);
		}
	}
}