/* ChangeFontSizeCommand.as */
   	
package gov.va.med.edp.command
{
	import com.adobe.cairngorm.commands.ICommand;
	import com.adobe.cairngorm.control.CairngormEvent;
	
	import gov.va.med.edp.control.NumberEvent;
	import gov.va.med.edp.model.TrackingModelLocator;

	/**
	 * This command class communicates with the VistA RPC to change the font size in the display board.
	 * 
	 */
	public class ChangeFontSizeCommand implements ICommand
	{
		private var model:TrackingModelLocator = TrackingModelLocator.getInstance();
		
		/**
		 *   Constructor.
		 */
		public function ChangeFontSizeCommand() 
		{
		}
		/**
		 *   event execution
		 */
		public function execute(event:CairngormEvent):void
		{
			var e: NumberEvent = NumberEvent(event);
			model.boardSpec.displayBoardProperties.squishFontSize = e.value;
		} // execute
	} // class
} // package