/*  Command
	event & command must be added to TrackingController.as    */
	
package gov.va.med.edp.command
{
	import com.adobe.cairngorm.commands.ICommand;
	import com.adobe.cairngorm.control.CairngormEvent;
	
	import gov.va.med.edp.business.AddPatientToLogDelegate;
	import gov.va.med.edp.control.PatientSelectEvent;
	import gov.va.med.edp.factory.TrackingFactory;
	import gov.va.med.edp.model.TrackingModelLocator;
	import gov.va.med.edp.util.Vista;
	import gov.va.med.edp.widget.InfoDialog;
	import gov.va.med.edp.control.cpe.CPEEvent;
	
	import mx.collections.ArrayCollection;
	import mx.collections.Sort;
	import mx.collections.SortField;
	import mx.rpc.IResponder;
	import mx.rpc.events.FaultEvent;
	import mx.rpc.events.ResultEvent;

	/**
	 * This command class communicates with the VistA RPC to add patients to the log.
	 * 
	 */
	public class AddPatientToLogCommand extends AbstractResponderCommand implements ICommand, IResponder
	{
		
		private var model:TrackingModelLocator = TrackingModelLocator.getInstance();

		
		/**
		 *   Constructor.
		 */
		public function AddPatientToLogCommand() 
		{
		}
		/**
		 * The execute of the user selected event; calls the Update Delegate
		 * @param event The generic Cairngorm event
		 */
		public function execute(event:CairngormEvent):void
		{
			//model.logEdit.isNew = true;
			var delegate:AddPatientToLogDelegate = new AddPatientToLogDelegate(this);
			var addEvent:PatientSelectEvent = PatientSelectEvent(event);
			var localTime: String = Vista.DatetoFM(model.buildSiteDate());

			delegate.addPatientToLog(addEvent.newPatient, model.logArea, localTime, model.logEdit.choiceTS);
		}
		/**
		 * Handle the successful return of the service call.
		 * 
		 * @param data The payload from the service call.
		 */
		public override function result(data:Object):void
		{
			var xml:XML = ResultEvent(data).result as XML;

			if (xml.add.@status == "fail") {
				InfoDialog.show("Patient could not be added to the log: " + xml.add.@msg);
				return;
			}			
			
			// make sure the choices are set up before setting the logEntry
			model.logEdit.setChoices(xml.choices[0]);
			// now that the choices are in place, we can set the log entry
			model.logEdit.setEntry(TrackingFactory.buildLogEntryFromXML(xml.logEntry[0]));
			model.logEdit.entry.isStub = true;
			model.isNew = true;
            model.logEdit.dirty = true;
            model.setEditState();
			
			// refresh the list of log entries
			model.logEntryList.entries =
				new ArrayCollection(TrackingFactory.buildLogSelectorListFromXML(xml.logEntries.log));
			model.logEntryList.token = xml.logEntries.@token;
				
			// sort based on previous settings
			if (model.logEntryList.sortField.length > 0) {
				var sort:Sort = new Sort();
				sort.fields = [new SortField(model.logEntryList.sortField, true, model.logEntryList.sortDescending)];
				model.logEntryList.entries.sort = sort;
				model.logEntryList.entries.refresh();
			}
			// now that it is sorted, set the selected index to the just added patient
			// (must set initial -1 to fire bindings)
			model.logEntryList.selectedIndex = -1;
			model.logEntryList.selectedIndex = 
				Vista.locateIndex(model.logEntryList.entries, model.logEdit.entry.id, "id");
			model.logEntryList.selectedID = model.logEdit.entry.id;
			
			model.logEdit.patientSelected = true;
			
			var toggleEvent: CPEEvent = new CPEEvent(CPEEvent.EVENT_REDIRECT_TO_PATIENT);
			toggleEvent.dispatch();
			
			model.displayVisitWorksheet = true;
			
			model.activateTriageMode = true;
			
			model.logEdit.message = "Save changes to add patient to the board or select cancel to abort adding this patient.";
			model.logEditMessageFontSize = 12;
		}
		
		protected override function getFaultMessage(faultEvent:FaultEvent):String {
			return "Add patient to log failed: " + super.getFaultMessage(faultEvent);
		}
	}
}