package gov.va.med.edp.command
{
	import com.adobe.cairngorm.commands.ICommand;
	import com.adobe.cairngorm.control.CairngormEvent;
	
	import flash.events.Event;
	
	import gov.va.med.edp.control.AbstractNotificationEvent;
	
	import mx.rpc.IResponder;
	import mx.rpc.events.FaultEvent;
	
	/**
	 * Allows for sequencing of commands in order to force a workflow, with subsequent notification upon completion.
	 */
	public class AbstractSequenceNotificationCommand extends AbstractSequenceCommand implements IResponder
	{		
		private namespace self;
		private var viewHandlers  : IResponder = null;	
		/**
		 *   Constructor.
		 */
		public function AbstractSequenceNotificationCommand() 
		{
		}
		/**
		 *   event execution
		 */
		public override function execute(event:CairngormEvent): void
		{		
			super.execute(event);
			cacheCaller(event);
		}		
		
		protected override function getFaultMessage(faultEvent:FaultEvent):String {
			return "Error Loading : " + super.getFaultMessage(faultEvent);

		}
		
		/**
		 *  This method is called by a service when an error has been received.
		 *  While <code>info</code> is typed as Object it is often
		 *  (but not always) an mx.rpc.events.FaultEvent.
		 */
		public override function fault(info:Object):void
		{
			notifyCaller(info);
			super.fault(info);
		}
		
		protected function cacheCaller(event:Event):void {
			viewHandlers = getResponderFor(event);
		}
		
		private function getResponderFor(event:Event):IResponder {
			var results : IResponder = null;
			if (event != null) {
				if (event is AbstractNotificationEvent){
					results = (event as AbstractNotificationEvent).callbacks;					
				}
			}
			return results;
		}
		
		self function result(info:Object):void {
			if (viewHandlers && (viewHandlers.result != null)) {
				viewHandlers.result(info);
			}
		}
		
		self function fault( info:Object ) : void {
			if (viewHandlers && (viewHandlers.fault != null)) {
				viewHandlers.fault(info);
			}
		}
		
		public function notifyCaller(results:* = null):void {
			if (results is FaultEvent) {
				self::fault(results);
			}
			else{
				self::result(results);
			}
		}
		
	} // class
} // package