package gov.va.med.edp.business.worksheet
{
	import gov.va.med.edp.business.ResponderChainingDelegate;
	
	import mx.collections.ArrayCollection;
	import mx.controls.Alert;
	import mx.rpc.IResponder;
	import mx.utils.ObjectUtil;
	
	/**
	 * The delegate class communicates with the VistA RPC to save worksheet config data per role.
	 * @author Joe Lemaire
	 * 
	 */
	public class SaveWorkSheetDelegate extends ResponderChainingDelegate
	{
		/**
		 *  
		 * @param responder
		 * @param serviceName
		 * 
		 */
		public function SaveWorkSheetDelegate(responder:IResponder)
		{
			super(responder, "saveWorksheetConfig");
		}
		
		/**
		 *  
		 * @param area
		 * @param role
		 * 
		 */
		public function saveWorksheet(area:int, worksheet: XML = null, disabled:Boolean = false, deletion:Boolean = false): void
		{
//			worksheet = <worksheet name="TEST WORKSHEET" id="1" role="1">
//  <section id="1" displayName="DISPLAYNAME1" initialOpen="true" name="SECTION 1" sequence="1">
//    <component dataProvider="data provider #1" editable="true" id="1" name="COMPONENT 1.1" sequence="1" includeInSummary="true" type="gov.va.med.edp.view.worksheet.WorkSheetTextInput"/>
//    <component dataProvider="data provider #1" editable="true" id="2" name="COMPONENT 1.2" sequence="2" type="gov.va.med.edp.view.worksheet.WorkSheetTextInput"/>
//    <component dataProvider="data provider #1" editable="true" id="3" name="COMPONENT 1.3" sequence="3" type="gov.va.med.edp.view.worksheet.WorkSheetTextInput"/>
//  </section>
//  <section id="2" displayName="DISPLAYNAME2" initialOpen="false" name="SECTION 2" sequence="2">
//    <component dataProvider="data provider #1" editable="true" id="5" name="COMPONENT 2.2" sequence="1" type="gov.va.med.edp.view.worksheet.WorkSheetTextInput"/>
//    <component dataProvider="data provider #1" editable="true" id="4" name="COMPONENT 2.1" sequence="2" type="gov.va.med.edp.view.worksheet.WorkSheetTextInput"/>
//  </section>
//</worksheet>
//			Alert.show(worksheet.toXMLString());
			var params:Object = new Object();
			params.id = String(worksheet.@id);
			params.type = "V";
			params.role = String(worksheet.@role);
			params.name = String(worksheet.@name);
			params.remove = deletion;
			params.disabled = disabled;
			params.area = area;
			
			var counter:int = 0;
			var seq:int;
			for (var i:int = 0; i< worksheet.children().length(); i++) {
				var section:String = "";
				var x:XML = worksheet.section[i];
				seq = parseInt(x.@sequence);  // + 1;
				section += x.@id+"^"+seq+"^"+x.@initialOpen;
				params["worksheet_"+counter++] = section+"^^^";
				for (var j:int = 0; j < x.children().length(); j++) {
					var component:String = "";
					var y:XML = x.component[j];
					seq = parseInt(y.@sequence);  // + 1;					
					component += section + "^"+y.@id+"^"+seq+"^"+y.@editable+"^"+y.@includeInSummary;
					params["worksheet_"+counter++] = component;
				}
			}
			 
//			Alert.show(ObjectUtil.toString( params ));
			
			send(params);
		}
	}
}