package gov.va.med.edp.business.worksheet
{
	import gov.va.med.edp.business.ResponderChainingDelegate;
	
	import mx.rpc.IResponder;
	import mx.controls.Alert;
	
	/**
	 * Loads the designated worksheet.
	 * @author Joe Lemaire
	 * 
	 */
	public class GetWorkSheetDelegate extends ResponderChainingDelegate
	{
		/**
		 *  Loads the designated worksheet.
		 * @param responder
		 * @param serviceName
		 * 
		 */
		public function GetWorkSheetDelegate(responder:IResponder)
		{
			super(responder, "getWorksheet");
		}
		
		/**
		 * Loads the designated worksheet.
		 * @param worksheetID - The id of the worksheet to retrieve.
		 * @param data - Retrieve values associated with log entry or not.
		 * 
		 */
		public function getWorksheet(worksheetID: String,
									 data:String = "0"): void
		{			
			var params:Object = new Object();
			params.id = worksheetID;
			params.data = data;
			//Alert.show("GetWorkSheetDelegate->getWorksheet(worksheetID = " + params.id + " , data = " + params.data + ")");
			send(params);
		}
	}
}