package gov.va.med.edp.business.responder
{
	import mx.rpc.Fault;
	import mx.rpc.IResponder;
	import mx.rpc.events.FaultEvent;
	import mx.rpc.events.ResultEvent;

    /**
     * Responder that checks the result for <error> tags produced by the server.  If found, calls fault on
     * decorated responder, if not, passes through result unmodified.
     */
    public class ServerErrorCheckResponder extends ResponderDecorator implements IResponder
	{	
		/**
		 * Defines the main Server error responder
		 * 
		 * @param responder handles any delegate results
		 */
		public function ServerErrorCheckResponder(responder: IResponder) {
			super(responder);
		}
		/**
		 *  This method is called by a service when the return value
		 *  has been received. 
		 *  While <code>data</code> is typed as Object, it is often
		 *  (but not always) an mx.rpc.events.ResultEvent.
		 */
		
		public override function result(data:Object):void {
			var xml:XML = ResultEvent(data).result as XML;
			if (xml.error != undefined) {
				var fault:Fault = new Fault(xml.error.code, xml.error.message, xml.error.detail);
				fault.rootCause = xml.error;
				var faultEvent:FaultEvent = FaultEvent.createEvent(fault);
				this.fault(faultEvent);
			} else {
				responder.result(data);
			}
		}
	}
}