package gov.va.med.edp.business.responder
{
	import mx.rpc.IResponder;

	/**
	 * The parent delegate class communicates with the VistA RPC.
	 * 
	 *
	 */	
	public class ResponderDecorator implements IResponder
	{
		protected var responder:IResponder;
		/**
		 *  This interface provides the contract for any service
		 *  that needs to respond to remote or asynchronous calls.
		 */
		
		public function ResponderDecorator(responder:IResponder) {
			this.responder = responder;
		}
		
		/**
		 *  This method is called by a service when the return value
		 *  has been received. 
		 *  While <code>data</code> is typed as Object, it is often
		 *  (but not always) an mx.rpc.events.ResultEvent.
		 */
		public function result(data:Object):void
		{
			this.responder.result(data);
		}
		/**
		 *  This method is called by a service when an error has been received.
		 *  While <code>info</code> is typed as Object it is often
		 *  (but not always) an mx.rpc.events.FaultEvent.
		 */
		public function fault(info:Object):void
		{
			this.responder.fault(info);
		}
		
	}
}