package gov.va.med.edp.business.reports.adhoc
{
	import gov.va.med.edp.business.ResponderChainingDelegate;
	
	import mx.rpc.IResponder;
	import mx.collections.ArrayCollection;
	import mx.utils.ObjectUtil;
	import mx.controls.Alert;
	
	/**
	 * This call save or delete an adhoc report.
	 * 
	 * @author useruseruser12
	 * 
	 */
	public class SaveAdhocReportDelegate extends ResponderChainingDelegate
	{
		/**
		 * Constructor.
		 * 
		 * @param responder - Interface to respond to.
		 * @param serviceName - Service call.
		 * 
		 */
		public function SaveAdhocReportDelegate(responder:IResponder)
		{
			super(responder, "saveReportDef");
		}
		
		
		/**
		 * Makes the call to get save the report.
		 * 
		 * @param area - Area to make call to.
		 * @param id - The id of the report, if null all reports are returned.
		 * @param remove - True to delete this report.
		 * @param name - The name of the report, if new required.
		 * @param elements - Elements ArrayCollection,
		 * @param inactive - If this is an inactive report.
		 * @param editable - If this is an editable report. 
		 * @param role - Role associated with this report.
		 * 
		 */
		public function saveAdhocReport(area: int, 
										id: String = null, 
										remove:Boolean = false,
										name:String = null,
										elements:ArrayCollection = null,
										inactive:Boolean = false, 
										editable:Boolean = false,
										role:String = null): void
		{
			var params:Object = new Object();
			params.area = area;
			params.id = id;
			params.name = name;
			params.inactive = inactive;
			params.role = role;
			params.remove = remove;

			var counter:int = 0;
			var seq:int;
			for each (var s:String in elements) {
				params["element_"+counter++] = s;
			}
			
			//Alert.show(ObjectUtil.toString( params ));
			
			send(params);
		}
		
		/**
		 * Makes the call to get delete the report. 
		 * 
		 * @param area - Area to make call to.
		 * @param id - The id of the report, if null all reports are returned.
		 * 
		 */
		public function deleteAdhocReport(area: int, 
										  id: String = null): void
		{
			saveAdhocReport(area,id,true);			
		}
		
		/**
		 * Makes the call to get export the report. 
		 * 
		 * @param area - Area to make call to.
		 * @param id - The id of the report, if null all reports are returned.
		 * 
		 */
		public function exportAdhocReport(area: int, 
										  id: String = null): void
		{
			saveAdhocReport(area,id,true);			
		}
		
	}
}