package gov.va.med.edp.business.reports.adhoc
{
	import gov.va.med.edp.business.ResponderChainingDelegate;
	
	import mx.rpc.IResponder;
	
	/**
	 * This call loads the existing adhoc reports.
	 * 
	 * @author useruseruser12
	 * 
	 */
	public class LoadAdhocReportListDelegate extends ResponderChainingDelegate
	{
		/**
		 * Constructor.
		 * 
		 * @param responder - Interface to respond to.
		 * @param serviceName - Service call.
		 * 
		 */
		public function LoadAdhocReportListDelegate(responder:IResponder)
		{
			super(responder, "getReportList");
		}
		

		/**
		 * Makes the call to get the list. 
		 * @param area - Area to make call to.
		 * @param id - The id of the report, if null all reports are returned.
		 * @param elements - If true, return elements.
		 * 
		 */
		public function loadAdhocReportList(area: int, id: String = null, elements:String = null): void
		{
			var params:Object = new Object();
			params.area = area;
			params.id = id;
			params.elements = elements;
			send(params);
		}
	}
}