package gov.va.med.edp.business.reports
{
	import gov.va.med.edp.business.ResponderChainingDelegate;
	import gov.va.med.edp.control.reports.ReportEvent;
	import gov.va.med.edp.util.Vista;
	import gov.va.med.edp.vo.reports.adhoc.AdhocReportSearchParametersVO;
	
	import mx.controls.Alert;
	import mx.rpc.IResponder;
	import mx.utils.ObjectUtil;
	
	/**
	 * The delegate class communicates with the VistA RPC to execute specific reports.
	 * @author Joe Lemaire
	 * 
	 */
	public class CustomReportDelegate extends ResponderChainingDelegate
	{
		/**
		 *  
		 * @param responder
		 * @param serviceName
		 * 
		 */
		public function CustomReportDelegate(responder:IResponder)
		{
			super(responder, "executeReport");
		}
		
		/**
		 *  
		 * @param area
		 * @param role
		 * 
		 */
		public function customReport(area: int, role: String = null): void
		{
			var params:Object = new Object();
			params.area = area;
			params.roleID = role;			
			send(params);
		}
		
		public function loadCustomReport(area: int, reportEvent:ReportEvent): void
		{
			var params:Object = new Object();
			params.area = area;
			params.start = Vista.DatetoFM(reportEvent.reportParams.startDate);
			params.stop = Vista.DatetoFM(reportEvent.reportParams.stopDate);
			params.id = reportEvent.reportParams.id;
			params.resident = reportEvent.reportParams.residentName;
			params.patient = reportEvent.reportParams.patientId;
			
			send(params);
		}
		
		public function csvCustomReport(adhocSearchParams:AdhocReportSearchParametersVO): void
		{
			var params:Object = new Object();
			params.area = adhocSearchParams.area;
			params.id = adhocSearchParams.id;
			params.resident = adhocSearchParams.resident;
			params.patient = adhocSearchParams.patient;
			params.start = Vista.DatetoFM(adhocSearchParams.startDate);
			params.stop = Vista.DatetoFM(adhocSearchParams.endDate);
			params.csv = true;
			
			var counter:int = 0;
			var seq:int;
			for each (var s:String in adhocSearchParams.elements) {
				params["element_"+counter++] = s;
			}
			
			send(params);
		}
		
		public function executeAdhocReport(adhocSearchParams:AdhocReportSearchParametersVO): void
		{
			var params:Object = new Object();
			params.area = adhocSearchParams.area;
			params.id = adhocSearchParams.id;
			params.resident = adhocSearchParams.resident;
			params.patient = adhocSearchParams.patient;
			params.start = Vista.DatetoFM(adhocSearchParams.startDate);
			params.stop = Vista.DatetoFM(adhocSearchParams.endDate);
			params.csv = "false";
			
			var counter:int = 0;
			var seq:int;
			for each (var s:String in adhocSearchParams.elements) {
				params["element_"+counter++] = s;
			}
			
			//Alert.show(ObjectUtil.toString( params ));
			send(params);
		}
		
	}
}