/* SaveSelectionConfigDelegate.as */

package gov.va.med.edp.business.config
{
	import gov.va.med.edp.business.ResponderChainingDelegate;
	import gov.va.med.edp.vo.CodeSelectionVO;
	
	import mx.collections.ArrayCollection;
	import mx.rpc.IResponder;
    
	/**
	 * The delegate class communicates with the VistA RPC to save config selection data.
	 * 
	 *
	 */	
	public class SaveSelectionConfigDelegate extends ResponderChainingDelegate
	{	
		/**
		 * Defines the main command to be sent to VistA RPC
		 * 
		 * @param responder handles any delegate results
		 */
		public function SaveSelectionConfigDelegate(responder:IResponder)
		{
			super(responder, "saveSelectionConfig");
		}
	   	 
		/**
		 * Creates the parameters to be sent to the RPC
		 * 
		 * The Selection config data
		 * @param area
		 * @param selectionToken
		 * @param statuses
		 * @param dispositions
		 * @param delays
		 * @param arrivals
		 * 
		 * @return 
		 */
		
		public function saveSelectionConfig(area: int, selectionToken: String, statuses: ArrayCollection,
			dispositions: ArrayCollection, delays: ArrayCollection, arrivals: ArrayCollection): void
		{
			var params:Object = new Object();
			params.area = area;
			params.selectionToken = selectionToken;
			
			var code: CodeSelectionVO;
			var i: int;
			
			if (statuses != null) {
				for (i = 0; i < statuses.length; i++) {
					code = statuses[i] as CodeSelectionVO;
					params["status-"+i] = code.toString() + "seq=" + (i+1);
				}
			}
			if (dispositions != null) {
				for (i = 0; i < dispositions.length; i++) {
					code = dispositions[i] as CodeSelectionVO;
					params["disposition-"+i] = code.toString() + "seq=" + (i+1);
				}
			}
			if (delays != null) {
				for (i = 0; i < delays.length; i++) {
					code = delays[i] as CodeSelectionVO;
					params["delay-"+i] = code.toString() + "seq=" + (i+1);
				}
			}			
			if (arrivals != null) {
				for (i = 0; i < arrivals.length; i++) {
					code = arrivals[i] as CodeSelectionVO;
					params["arrival-"+i] = code.toString() + "seq=" + (i+1);
				}
			}
			
			send(params);
		}
	}
}