/* SaveConfigStaffDelegate.as */

package gov.va.med.edp.business.config
{
	import gov.va.med.edp.business.ResponderChainingDelegate;
	import gov.va.med.edp.vo.StaffMemberVO;
	
	import mx.collections.ArrayCollection;
	import mx.controls.Alert;
	import mx.rpc.IResponder;
	import mx.utils.ObjectUtil;
    
	/**
	 * The delegate class communicates with the VistA RPC to save staff config data.
	 * 
	 *
	 */	
	public class SaveConfigStaffDelegate extends ResponderChainingDelegate
	{	
		/**
		 * Defines the main command to be sent to VistA RPC
		 * 
		 * @param responder handles any delegate results
		 */
		public function SaveConfigStaffDelegate(responder:IResponder)
		{
			super(responder, "saveStaffConfig");
		}
		/**
		 * Creates the parameters to be sent to the RPC
		 * 
		 * The Staff config data
		 * @param area
		 * @param staffToken
		 * @param staffList
		 * 
		 * @return 
		 */
	   	 
		/**
		 * 
		 * 
		 * 
		 */
		public function saveConfigStaff(area: int, staffToken: String, staffList: ArrayCollection):void
		{
			var params:Object = new Object();
			params.area = area;
			params.staffToken = staffToken;
			
			var num: int = 0;
			for each (var staff: StaffMemberVO in staffList) {
				num++;
				params["staff-" + num] = staff.toString();
			}
			
//			Alert.show("saveStaffConfig params = \n"+ObjectUtil.toString(params));
			
			send(params);
		}
	}
}