/* SaveConfigParamsDelegate.as */

package gov.va.med.edp.business.config
{
	import gov.va.med.edp.business.ResponderChainingDelegate;
	import gov.va.med.edp.vo.LogEditParamsVO;
	
	import mx.rpc.IResponder;
    
	/**
	 * The delegate class communicates with the VistA RPC to save config parameter data.
	 * 
	 *
	 */	
	public class SaveConfigParamsDelegate extends ResponderChainingDelegate
	{	
		/**
		 * Defines the main command to be sent to VistA RPC
		 * 
		 * @param responder handles any delegate results
		 */
		public function SaveConfigParamsDelegate(responder:IResponder)
		{
			super(responder, "saveParamConfig");
		}
		/**
		 * Creates the parameters to be sent to the RPC
		 * 
		 *  The Config parameters  data
		 * @param area
		 * @param logParams
		 * @param paramToken
		 * 
		 * 
		 */
		
		public function saveConfigParams(area: int, logParams: LogEditParamsVO, paramToken: String):void
		{
			var params:Object = new Object();
			params.area = area;
			params.paramToken = paramToken;
			params.param = logParams.toString();
			send(params);
		}
	}
}