/* SaveConfigColorsDelegate.as */

package gov.va.med.edp.business.config
{
	import gov.va.med.edp.business.ResponderChainingDelegate;
	
	import mx.rpc.IResponder;
    
	/**
	 * The delegate class communicates with the VistA RPC to save color config data.
	 * 
	 *
	 */	
	public class SaveConfigColorsDelegate extends ResponderChainingDelegate
	{	
		/**
		 * Defines the main command to be sent to VistA RPC
		 * 
		 * @param responder handles any delegate results
		 */
		public function SaveConfigColorsDelegate(responder:IResponder)
		{
			super(responder, "saveColorConfig");
		}
		/**
		 * Creates the parameters to be sent to the RPC
		 * 
		 *  The color config data
		 * @param area
		 * @param colorXML
		 * @param colorToken
		 * 
		 * 
		 * @return 
		 */
	   	 
		
		public function saveConfigColors(area: int, colorXML: XML, colorToken: String): void
		{
			var params:Object = new Object();
			var i: int = 0;
			params.area = area;
			params.colorToken = colorToken;
			for each (var elem: XML in colorXML.children()) {
				if (elem.@type == "bed") continue;     // bed colors saved from room/bed screen
				if (elem.@type == "staff") continue;   // staff colors saved from staff screen
				i++;
				params["xml-"+i] = '<colors id="' + elem.@id + '" type="' + elem.@type + '" >';
				for each (var match: XML in elem.children()) {
					i++;
					params["xml-"+i] = match.toXMLString();
				}
				i++;
				params["xml-"+i] = '</colors>';
			}

			send(params);
		}
	}
}