/* SaveConfigBoardDelegate.as */

package gov.va.med.edp.business.config
{
	import gov.va.med.edp.business.ResponderChainingDelegate;
	
	import mx.rpc.IResponder;
    
	/**
	 * The delegate class communicates with the VistA RPC to save board config data.
	 * 
	 *
	 */	
	public class SaveConfigBoardDelegate extends ResponderChainingDelegate
	{	
		/**
		 * Defines the main command to be sent to VistA RPC
		 * 
		 * @param responder handles any delegate results
		 */
		public function SaveConfigBoardDelegate(responder:IResponder)
		{
			super(responder, "saveConfigBoard");
		}
		/**
		 * Creates the parameters to be sent to the RPC
		 * 
		 * The Save board config data
		 * @param area
		 * @param boardID
		 * @param boardName
		 * @param boardToken
		 * @param boardXML
		 * 
		 * @return 
		 */
		
		public function saveConfigBoard(area: int, boardID: int, boardName: String, boardToken: String, boardXML: XML): void
		{
			var params: Object = new Object();
			var i: int = 0;
			params.area = area;
			params.boardID = boardID;
			params.boardName = boardName;
			params.boardToken = boardToken;
			for each (var elem:XML in boardXML.children()) {
				i++;
				params["col-" + i] = elem.toXMLString();
			}
			send(params);
		}
	}
}