/* SaveBedConfigDelegate.as */

package gov.va.med.edp.business.config
{
	import gov.va.med.edp.business.ResponderChainingDelegate;
	import gov.va.med.edp.vo.RoomBedVO;
	
	import mx.collections.ArrayCollection;
	import mx.rpc.IResponder;
    
	/**
	 * The delegate class communicates with the VistA RPC to save bed config data.
	 * 
	 *
	 */	
	public class SaveBedConfigDelegate extends ResponderChainingDelegate
	{	
		/**
		 * Defines the main command to be sent to VistA RPC
		 * 
		 * @param responder handles any delegate results
		 */
		public function SaveBedConfigDelegate(responder:IResponder)
		{
			super(responder, "saveBedConfig");
		}
		/**
		 * Creates the parameters to be sent to the RPC
		 * 
		 *   The Save bed config data
		 * @param beds
		 * @param area
		 * @param bedToken
		 * 
		 * @return 
		 */
		
		public function saveBedConfig(beds: ArrayCollection, area: int, bedToken: String):void
		{
			var params:Object = new Object();
			var bed: RoomBedVO;
			
			params.area = area;
			params.bedToken = bedToken;
			for (var i: int = 0; i < beds.length; i++) {
				bed = beds[i] as RoomBedVO;
				params["bed-" + i] = bed.toString();
			}
			
			send(params);
		}
	}
}