/* LoadSelectionConfigDelegate.as */

package gov.va.med.edp.business.config
{
	import gov.va.med.edp.business.ResponderChainingDelegate;
	
	import mx.rpc.IResponder;
    
	/**
	 * The delegate class communicates with the VistA RPC to load selection config screen.
	 * 
	 *
	 */	
	public class LoadSelectionConfigDelegate extends ResponderChainingDelegate
	{	
		/**
		 * Defines the main command to be sent to VistA RPC
		 * 
		 * @param responder handles any delegate results
		 */
		public function LoadSelectionConfigDelegate(responder:IResponder)
		{
			super(responder, "loadSelectionConfig");
		}
		/**
		 * Creates the parameters to be sent to the RPC
		 * 
		 * @param area
		 *  The patient's Selection config data
		 * 
		 * @return 
		 */
		public function loadSelectionConfig(area: int):void
		{
			var params:Object = new Object();
			params.area = area;	 
			send(params);
		}
	}
}