/* LoadConfigurationDelegate.as */

package gov.va.med.edp.business.config
{
	import gov.va.med.edp.business.ResponderChainingDelegate;
	
	import mx.rpc.IResponder;
    
	/**
	 * The delegate class communicates with the VistA RPC to load board configuration.
	 * 
	 *
	 */	
	public class LoadConfigurationDelegate extends ResponderChainingDelegate
	{	
		/**
		 * Defines the main command to be sent to VistA RPC
		 * 
		 * @param responder handles any delegate results
		 */
		public function LoadConfigurationDelegate(responder:IResponder)
		{
			super(responder, "loadConfiguration");
		}
		/**
		 * Creates the parameters to be sent to the RPC
		 * 
		 * @param  area 
		 * The config data
		 * 
		 * @return 
		 */
		public function loadConfiguration(area: int):void
		{
			var params:Object = new Object();
			params.area = area;	 
			send(params);
		}
	}
}