/* LoadBoardConfigDelegate.as */

package gov.va.med.edp.business.config
{
	import gov.va.med.edp.business.ResponderChainingDelegate;
	
	import mx.rpc.IResponder;
	
	/**
	 * The delegate class communicates with the VistA RPC.
	 * 
	 *
	 */	
    
	public class LoadBoardConfigDelegate extends ResponderChainingDelegate
	{	
		/**
		 * Defines the main command to be sent to VistA RPC
		 * 
		 * @param responder handles any delegate results
		 */
		public function LoadBoardConfigDelegate(responder:IResponder)
		{
			super(responder, "loadBoardConfig");
		}
		/**
		 * Creates the parameters to be sent to the RPC
		 * 
		 * The patient's Board config data
		 * @param area
		 * @param boardID
		 * 
		 * @return 
		 */
		
		public function loadBoardConfig(area: int, boardID: int):void
		{
			var params:Object = new Object();
			params.area = area;
			params.boardID = boardID;
			send(params);
		}
	}
}