package gov.va.med.edp.business
{
	import gov.va.med.edp.vo.VitalsVO;
	
	import mx.rpc.IResponder;
	
	/**
	 * The delegate class communicates with the VistA RPC.
	 * 
	 *
	 */	
	public class UpdateVitalsDelegate extends ResponderChainingDelegate
	{	
		
		/**
		 * Defines the main command to be sent to VistA RPC
		 * 
		 * @param responder handles any delegate results
		 */
		public function UpdateVitalsDelegate(responder:IResponder)
		{
			super(responder, "saveVitals");
		}
		
		/**
		 * Creates the parameters to be sent to the RPC updating the vitals
		 * 
		 * @param vitals 
		 * @param dfn 
		 * @return 
		 */
		public function updateVitals(dfn:String, vitals:String): void
		{
			var params:Object = new Object();
			params.dfn = dfn;
			params.vital = vitals;
			send(params);
		}
	}
}