/* UpdateDemogDelegate.as */

package gov.va.med.edp.business
{
	import gov.va.med.edp.vo.reports.PtDemographicsVO;
	
	import mx.controls.Alert;
	import mx.rpc.IResponder;
	
	/**
	 * The delegate class communicates with the VistA RPC.
	 * 
	 *
	 */	
	public class UpdateDemogDelegate extends ResponderChainingDelegate
	{	
		
		/**
		 * Defines the main command to be sent to VistA RPC
		 * 
		 * @param responder handles any delegate results
		 */
		public function UpdateDemogDelegate(responder:IResponder)
		{
			super(responder, "savePhoneNumbers");
		}
		
		/**
		 * 
		 * The patient's demographic data
		 * @param demog 
		 * @param dfn
		 * 
		 * @return 
		 */
		public function updateDemog(dfn:String, demog: PtDemographicsVO): void
		{
			var params:Object = new Object();
			params.patient = dfn;
			params.phone = demog.phone;
			params.cell = demog.cell;
			params.nokPhone = demog.nokPhone;
			//Alert.show("sending nok = |"+demog.nokPhone+"|");
			send(params);
		}
	}
}