/* SwitchLogEntryDelegate.as */

package gov.va.med.edp.business
{
	import gov.va.med.edp.vo.LogEntryVO;
	
	import mx.controls.Alert;
	import mx.rpc.IResponder;
	import mx.utils.ObjectUtil;
	  
	/**
	 * The delegate class communicates with the VistA RPC to switch log entry.
	 * 
	 *
	 */	
	public class SwitchLogEntryDelegate extends ResponderChainingDelegate
	{	
		/** 
		 * This is the constructor for the delegate. 
		 * @param responder IResponder interface. 
		 *
		 */
		public function SwitchLogEntryDelegate(responder:IResponder)
		{
			super(responder, "switchLogEntry");
		}
	   	 
		/** 
		 * Function to remove the log entry. 
		 * @param logID is the ID.
		 * @param logEntry of type LogEntryVO that gets saved.
		 * @param choiceTS.
		 */
		public function switchLogEntry(logID: Number, logEntry: LogEntryVO, choiceTS: String): void
		{
			var params:Object = new Object();
			params.logID = logID;
			if (logEntry != null) params.logEntry = logEntry.toString();
			params.choiceTS = choiceTS;
//			Alert.show("SwitchLogEntryDelegate\n"+ObjectUtil.toString(params));
			send(params);
		}
	}
}