/* SaveLogEntryDelegate.as */

package gov.va.med.edp.business
{
	import gov.va.med.edp.vo.LogEntryVO;
	
	import mx.controls.Alert;
	import mx.rpc.IResponder;
	import mx.utils.ObjectUtil;
    
	/**
	 * The delegate class communicates with the VistA RPC to save log entry.
	 * 
	 *
	 */	
	public class SaveLogEntryDelegate extends ResponderChainingDelegate
	{	
		/** 
		 * This is the constructor for the delegate. 
		 * @param responder IResponder interface. 
		 *
		 */

		public function SaveLogEntryDelegate(responder:IResponder)
		{
			super(responder, "saveLogEntry" );
		}
		/** 
		 * Function to remove the log entry. 
		 * @param logEntry of type LogEntryVO that gets saved.
		 * 
		 */
		public function saveLogEntry(logEntry:LogEntryVO, id:Number):void
		{
			var params:Object = new Object();
			params.logEntry = logEntry.toString();
			params.logID = id;
//			Alert.show("SaveLogEntryDelegate\n"+ObjectUtil.toString(params));
			send(params);
		}
	}
}