/* RestoreLogEntryDelegate.as */

package gov.va.med.edp.business
{
	import gov.va.med.edp.vo.LogEntryVO;
	import gov.va.med.edp.vo.SessionVO;
	
	import mx.rpc.IResponder;
    
	/** 
	 * This is the delegate used to send a request to restore a log entry. This delegate
	 * reuses the saveLogEntry rpc call.
	 */ 
	public class RestoreLogEntryDelegate extends ResponderChainingDelegate
	{	

		/** 
		 * This is the constructor for the delegate. 
		 * @param responder IResponder interface. 
		 *
		 */
		public function RestoreLogEntryDelegate(responder:IResponder)
		{
			super(responder, "saveLogEntry" );
		}
		/** 
		 * Function to restore the log entry. 
		 * @param logEntry The LogEntryVo for which the restore is exercising. 
		 */
		public function restoreLogEntry(logEntry:LogEntryVO):void
		{
			var params:Object = new Object();
			params.logEntry = logEntry.toString();
			params.restorePatient = 1;
			params.logID = logEntry.id;
			send(params);
		}
	}
}