/* ResetDisplayBoardDelegate.as */

package gov.va.med.edp.business
{
	import mx.rpc.IResponder;
    
	/**
	 * The delegate class communicates with the VistA RPC to reset display board.
	 * 
	 *
	 */	
	public class ResetDisplayBoardDelegate extends ResponderChainingDelegate
	{	
		/** 
		 * This is the constructor for the delegate. 
		 * @param responder IResponder interface. 
		 *
		 */
		public function ResetDisplayBoardDelegate(responder:IResponder)
		{
			super(responder, "resetDisplayBoard" );
		}
	   	 
		/** 
		 * Function to remove the log entry. 
		 * @param boardName the board.
		 * @param area The area. 
		 * 
		 */
		public function resetDisplayBoard(area: int, boardName: String):void
		{
			var params:Object = new Object();
			params.area = area;
			params.board = boardName;
			send(params);
		}
	}
}