/* RemoveLogEntryDelegate.as */

package gov.va.med.edp.business
{
	import gov.va.med.edp.vo.LogEntryVO;
	import gov.va.med.edp.vo.SessionVO;
	
	import mx.rpc.IResponder;
    
	/** 
	 * This is the delegate used to send a request to remove a log entry.
	 */ 
	public class RemoveLogEntryDelegate extends ResponderChainingDelegate
	{	
		/** 
		 * This is the constructor for the delegate. 
		 * @param responder IResponder interface. 
		 *
		 */
		public function RemoveLogEntryDelegate(responder:IResponder)
		{
			super(responder, "removeLogEntry" );
		}
	   	 
		/** 
		 * Function to remove the log entry. 
		 * @param logEntry The LogEntryVo for which the restore is exercising.
		 * @param area The area. 
		 * @param session The SessionVO from which to get the current user. 
		 */
		public function removeLogEntry(logEntry: LogEntryVO, area: int, session:SessionVO): void
		{
			var params: Object = new Object();
			params.logEntry = logEntry.toString();
			params.area = area;
			params.closedByUser = session.userName;
			send(params);
		}
	}
}