/* RefreshDisplayBoardDelegate.as */

package gov.va.med.edp.business
{
	import gov.va.med.edp.util.Vista;
	
	import mx.rpc.IResponder;
	
	//import mx.controls.Alert;
    
	/**
	 * The delegate class communicates with the VistA RPC to refresh display board.
	 * 
	 *
	 */	
	public class RefreshDisplayBoardDelegate extends ResponderChainingDelegate
	{	
		/**
		 * Defines the main command to be sent to VistA RPC
		 * 
		 * @param responder handles any delegate results
		 */
		public function RefreshDisplayBoardDelegate(responder:IResponder)
		{
			super(responder, "refreshDisplayBoard");
		}
	   	
		/**
		 * Creates the refresh parameters to be sent to the RPC. 
		 * @param  Display board data refresh data.
		 */
		public function refreshDisplayBoard(area: int, boardName: String, configLastUpdated: String):void
		{
			
			//Alert.show("RefreshDisplayBoardDelegate.refreshDisplayBoard(area="+area+",boardName="+boardName+",configLastUpdated="+configLastUpdated+")");
			
			var params:Object = new Object();
			params.area = area;
			params.board = boardName;
			params.last = configLastUpdated;
			send(params);
		}
		
		/**
		 * Refreshes the Bigboard Display board
		 * 
		 * @param  Display board data refresh data
		 * 
		 */
		
		public function refreshBigBoard(configLastUpdated: String):void
		{
			
			//Alert.show("RefreshDisplayBoardDelegate.refreshBigBoard(configLastUpdated="+configLastUpdated+")");
			
			var params:Object = new Object();
			
			// The area and board are persisted on the server in the HttpSession when initially passed into the url
			
			params.last = configLastUpdated;
			
			send(params);
		}
	}
}