/* MatchClosedVisitsDelegate.as */

package gov.va.med.edp.business
{
	import mx.rpc.IResponder;
    
	/**
	 * The delegate class communicates with the VistA RPC to match closed patients.
	 * 
	 *
	 */	
	public class MatchClosedVisitsDelegate extends ResponderChainingDelegate
	{	
		/**
		 * Defines the main command to be sent to VistA RPC
		 * 
		 * @param responder handles any delegate results
		 */
		public function MatchClosedVisitsDelegate(responder:IResponder)
		{
			super(responder, "matchClosed" );
		}
		/**
		 * Creates the parameters to be sent to the RPC
		 * 
		 *   Closed visit data
		 * 
		 * @param area
		 * @param partial
		 * 
		 * @return 
		 */ 
		public function matchClosedVisits(area: int, partial:String):void
		{
			var params:Object = new Object();
			params.area = area;
			params.partial = partial;	 
			
			send(params);
		}
	}
}