/* RefreshLogSelectorDelegate.as */

package gov.va.med.edp.business
{
	import mx.rpc.IResponder;
    
	/**
	 * The delegate class communicates with the VistA RPC to log patient access.
	 * 
	 *
	 */	
	public class LogSensitivePatientAccessDelegate extends ResponderChainingDelegate
	{	
		/**
		 * Defines the main command to be sent to VistA RPC
		 * 
		 * @param responder handles any delegate results
		 */
	   public function LogSensitivePatientAccessDelegate(responder:IResponder)
	   {     
	      super(responder, "logSensitivePatientAccess" );
	   }
	   	 
	   /**
		* Creates the parameters to be sent to the RPC
		* 
		* 
		 * @param dfn 
		 * patent access data
		* 
		* @return 
		*/

	   public function logSensitivePatientAccess(dfn: String):void
	   {
	   	  var params:Object = new Object();
		  params.patient = dfn;
	     
	      send(params);
	   }
	}
}