package gov.va.med.edp.business
{
	import gov.va.med.edp.util.DateMath;
	import gov.va.med.edp.util.Vista;
	import gov.va.med.edp.vo.reports.LabTrendVO;
	
	import mx.controls.Alert;
	import mx.rpc.IResponder;
	
	/**
	 * The delegate class communicates with the VistA RPC to get lab data.
	 * 
	 *
	 */	
	public class LabTrendDelegate extends ResponderChainingDelegate
	{	
		
		/**
		 * Defines the main command to be sent to VistA RPC
		 * 
		 * @param responder handles any delegate results
		 */
		public function LabTrendDelegate(responder:IResponder)
		{
			super(responder, "getLabs");
		}
		
		/**
		 * Creates the parameters to be sent to the RPC
		 * 
		 * Get lab trends
		 * @param dfn
		 * @param start
		 * @param stop
		 * 
		 * @return 
		 */
		public function getLabTrendIds(dfn:String,start:String,stop:String): void
		{
			var params:Object = new Object();
			params.patient = dfn;
			params.stop = stop;
			params.start = start;
			params.list = 1; 
															
			//Alert.show("LabTrendDelegate patient = " + params.patient + 
			//	" , stop = " + params.stop + 
			//	" , start = " + params.start + 
			//	" , list = " + params.list);
			
			if ((dfn != null) && (dfn != '')) {
				//Alert.show("LabTrendDelegate send");
				send(params);
			}
			
			//send(params);
		}
		
		/**
		 * Creates the parameters to be sent to the RPC
		 * 
		 * @param demog The patient's demographic data
		 * 
		 * @return 
		 */
		public function getLabTrendTestIds(dfn:String,start:String,stop:String,testIds:String): void
		{
			var params:Object = new Object();
			params.patient = dfn;
			params.stop = stop;
			params.start = start;
			params.list = 0; 
			
			//params.testIDs = "1^2^3^4";	
			params.testID = testIds;	
			
			
			//Alert.show("LabTrendDelegate getLabTrendTestId = " + params.patient + 
			//	" , stop = " + params.stop + 
			//	" , start = " + params.start + 
			//	" , testID = " + params.testID + 
			//	" , list = " + params.list);
			
			send(params);
		}
	}
}