/* InitUserDelegate.as */

package gov.va.med.edp.business
{
	import com.adobe.cairngorm.business.ServiceLocator;
	
	import mx.rpc.IResponder;
    
	/**
	 * The delegate class communicates with the VistA RPC to init user.
	 * 
	 *
	 */	
	public class InitUserDelegate extends ResponderChainingDelegate
	{	
		/**
		 * Defines the main command to be sent to VistA RPC
		 * 
		 * @param responder handles any delegate results
		 */
		public function InitUserDelegate(responder:IResponder)
		{
			super(responder, "initUser");
		}
		/**
		 * Creates the parameters to be sent to the RPC
		 * 
		 * @param  UserToken  initialization
		 * 
		 * @return 
		 */
		
		public function initUser(userToken: String):void
		{
			var params:Object = new Object();
			params.userToken = userToken;
			send(params);
		}
	}
}