/* InitTrackingDelegate.as */

package gov.va.med.edp.business
{
	import com.adobe.cairngorm.business.ServiceLocator;
	
	import mx.rpc.AsyncToken;
	import mx.rpc.IResponder;
    
	/**
	 * The delegate class communicates with the VistA RPC to init tracking.
	 * 
	 *
	 */	
	public class InitTrackingDelegate extends ResponderChainingDelegate
	{	
		/**
		 * Defines the main command to be sent to VistA RPC
		 * 
		 * @param responder handles any delegate results
		 */
		public function InitTrackingDelegate(responder:IResponder)
		{
			super(responder, "initTracking" );
		}
		/**
		 * Creates the parameters to be sent to the RPC
		 * 
		 * Tracking initialization
		 * @param areaName
		 * 
		 * @return 
		 */
		public function initTracking(areaName: String = ""):void
		{
			var params:Object = new Object();
			params.area = areaName;
			send(params);
		}
	}
}