/* InitLogAreaDelegate.as */

package gov.va.med.edp.business
{
	import com.adobe.cairngorm.business.ServiceLocator;
	
	import gov.va.med.edp.vo.LogEntryVO;
	
	import mx.rpc.AsyncToken;
	import mx.rpc.IResponder;
    
	/**
	 * The delegate class communicates with the VistA RPC to init log area.
	 * 
	 *
	 */	
	public class InitLogAreaDelegate extends ResponderChainingDelegate
	{	
		/**
		 * Defines the main command to be sent to VistA RPC
		 * 
		 * @param responder handles any delegate results
		 */
		public function InitLogAreaDelegate(responder:IResponder)
		{
			super(responder, "initLogArea" );
		}
		/**
		 * 
		 * 
		 *   
		 * Log area Init
		 * @param area
		 * @param logEntry
		 * 
		 * @return 
		 */
		
		public function initLogArea(area: int, logEntry: LogEntryVO):void
		{
			var params:Object = new Object();
			params.area = area;

			if ((logEntry != null) && (logEntry.id > 0)) {
				params.logEntry = logEntry.toString();
			}

			send(params);
		}
	}
}