/* InitDisplayBoardDelegate.as */

package gov.va.med.edp.business
{
	import com.adobe.cairngorm.business.ServiceLocator;
	
	import mx.rpc.IResponder;
	
	/**
	 * The delegate class communicates with the VistA RPC to init displayboard.
	 * 
	 *
	 */	
	public class InitDisplayBoardDelegate extends ResponderChainingDelegate
	{	
		/**
		 * Defines the main command to be sent to VistA RPC
		 * 
		 * @param responder handles any delegate results
		 */
		public function InitDisplayBoardDelegate(responder:IResponder)
		{
			super(responder, "initDisplayBoard");
		}
	   	 
		/**
		 * Initializes the Display board
		 * @param area The area.
		 * @param name The board name.
		 */
		
		public function initDisplayBoard(area: int, name: String):void
		{
			var params:Object = new Object();
			params.area = area;
			params.board = name; 
			
			send(params);
		}
		
		/**
		 * Initializes the Bigboard Display board
		 */
		
		public function initBigBoard():void
		{
			var params:Object = new Object();
			// The area and board are persisted on the server in the HttpSession when initially passed into the url
			send(params);
		}
	}
}