package gov.va.med.edp.business
{
	import gov.va.med.edp.vo.VitalsVO;
	
	import mx.rpc.IResponder;
	//import mx.controls.Alert;
	
	/**
	 * The delegate class communicates with the VistA RPC.
	 * 
	 *
	 */	
	public class GetVitalsDelegate extends ResponderChainingDelegate
	{	
		
		/**
		 * Defines the main command to be sent to VistA RPC
		 * 
		 * @param responder handles any delegate results
		 */
		public function GetVitalsDelegate(responder:IResponder)
		{
			super(responder, "getVitals");
		}
		
		/**
		 * Creates the vitals
		 * 
		 * @param dfn The patient's demographic data
		 * 
		 * @return 
		 */
		public function getVitals(dfn:String): void
		{
			var params:Object = new Object();
			params.dfn = dfn;
			
			if ((dfn != null) && (dfn != '')) {
				send(params);
			}
			//send(params);
		}
	}
}