package gov.va.med.edp.business
{
	import gov.va.med.edp.control.DetailsEvent;
	import mx.rpc.IResponder;
	import mx.controls.Alert;

	
	/**
	 * The delegate class communicates with the VistA RPC to retrieve data details.
	 * 
	 *
	 */	
	public class GetDetailsDelegate extends ResponderChainingDelegate
	{	
		
		/**
		 * Defines the main command to be sent to VistA RPC
		 * 
		 * @param responder handles any delegate results
		 */
		public function GetDetailsDelegate(responder:IResponder)
		{
			super(responder, "getDetails");
		}
		
		/**
		 * Creates the parameters to be sent to the RPC
		 * 
		 * 
		 * @param id
		 * @param detailsEvent
		 * 
		 * @return 
		 */
		/**
		 * 
		 * 
		 * 
		 */
		public function getDetails(id:Number, detailsEvent:DetailsEvent): void
		{
			var params:Object = new Object();
			
			params.logEntryId = id;						
			
			params.attribute =	detailsEvent.type as String;
									
			send(params);
		}

	}
}