/* DeleteStubEntryDelegate.as */

package gov.va.med.edp.business
{
	import mx.rpc.IResponder;
    
	/**
	 * The delegate class communicates with the VistA RPC to delete patient stub log.
	 * 
	 *
	 */	
	public class DeleteStubEntryDelegate extends ResponderChainingDelegate
	{	
		/**
		 * Defines the main command to be sent to VistA RPC
		 * 
		 * @param responder handles any delegate results
		 */
		public function DeleteStubEntryDelegate(responder:IResponder)
		{
			super(responder, "deleteStubEntry" );
		}
		/**
		 * Creates the parameters to be sent to the RPC
		 * 
		 *  The subentry delete
		 * @param area
		 * @param logID 
		 * 
		 * @return 
		 */
		
		public function deleteStubEntry(area: int, logID: int): void
		{
			var params:Object = new Object();
			params.area = area;
			params.logID = logID;
			
			send(params);
		}
	}
}