/* AddPatientToLogDelegate.as */

package gov.va.med.edp.business
{
	import gov.va.med.edp.pt.demog.model.PatientSelectVO;
	
	import mx.rpc.IResponder;
    
	/**
	 * The delegate class communicates with the VistA RPC to update patient log.
	 * 
	 *
	 */	
	public class AddPatientToLogDelegate extends ResponderChainingDelegate
	{	
		/**
		 * Defines the main command to be sent to VistA RPC
		 * 
		 * @param responder handles any delegate results
		 */

		public function AddPatientToLogDelegate(responder:IResponder)
		{
			super(responder, "addPatientToLog" );		
		}
		/**
		 * Creates the parameters to be sent to the RPC for the log
		 * 
		 *   The patient's addition
		 * @param newPatient
		 * @param area
		 * @param localTime
		 * @param choiceTS 
		 */
		
		public function addPatientToLog(newPatient: PatientSelectVO, area: int,
			localTime: String, choiceTS: String): void
		{
			var params: Object = new Object();
			params.addPatient = newPatient.toString();
			params.area = area;
			params.localTime = localTime;
			params.choiceTS = choiceTS;
			
			send(params);
		}
	}
}
