unit fWorkup;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ComCtrls, ORCtrls, ORNet, ORFn;

type
  TfrmWorkup = class(TForm)
    pcTask: TPageControl;
    TabSheet5: TTabSheet;
    lblTTask1: TLabel;
    cbTask1: TORComboBox;
    btnTask1: TButton;
    edTask1: TCaptionRichEdit;
    TabSheet6: TTabSheet;
    lblTTask2: TLabel;
    cbTask2: TORComboBox;
    edTask2: TCaptionRichEdit;
    btnTask2: TButton;
    TabSheet7: TTabSheet;
    lblTTask3: TLabel;
    cbTask3: TORComboBox;
    edTask3: TCaptionRichEdit;
    btnTask3: TButton;
    TabSheet8: TTabSheet;
    lblTTask4: TLabel;
    cbTask4: TORComboBox;
    edTask4: TCaptionRichEdit;
    cbxTask4: TCheckBox;
    btnTask4: TButton;
    btnExit: TButton;
    procedure cbTask1Change(Sender: TObject);
    procedure cbTask1Click(Sender: TObject);
    procedure edTask1Change(Sender: TObject);
    procedure btnTask1Click(Sender: TObject);
    procedure btnExitClick(Sender: TObject);
    procedure cbTask2Change(Sender: TObject);
    procedure cbTask2Click(Sender: TObject);
    procedure edTask2Change(Sender: TObject);
    procedure btnTask2Click(Sender: TObject);
    procedure cbTask3Change(Sender: TObject);
    procedure cbTask3Click(Sender: TObject);
    procedure edTask3Change(Sender: TObject);
    procedure btnTask3Click(Sender: TObject);
    procedure cbTask4Change(Sender: TObject);
    procedure cbTask4Click(Sender: TObject);
    procedure edTask4Change(Sender: TObject);
    procedure btnTask4Click(Sender: TObject);
    procedure DisableTasks;
    procedure Task1Enable;
    procedure Task2Enable;
    procedure Task3Enable;
    procedure Task4Enable;
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmWorkup: TfrmWorkup;

procedure Workup;

implementation

{$R *.dfm}

uses SurgReqMain, fProcedure;

procedure Workup;
begin
  frmWorkup := TfrmWorkup.Create(Application);
  try
  with frmWorkup do
    begin
      CallV('APTWL GET TASK LIST', [SpecIFN]);
      cbTask1.Items := RPCBrokerV.Results;
      cbTask2.Items := RPCBrokerV.Results;
      cbTask3.Items := RPCBrokerV.Results;
      cbTask4.Items := RPCBrokerV.Results;
      pcTask.ActivePage := TabSheet5;
      ShowModal;
    end;
  finally
    frmWorkup.Release;
  end;
end;

procedure TfrmWorkup.DisableTasks;
begin
  lblTTask1.Enabled := False;
  edTask1.Enabled   := False;
  btnTask1.Enabled  := False;
  lblTTask2.Enabled := False;
  edTask2.Enabled   := False;
  btnTask2.Enabled  := False;
  lblTTask3.Enabled := False;
  edTask3.Enabled   := False;
  btnTask3.Enabled  := False;
  lblTTask4.Enabled := False;
  edTask4.Enabled   := False;
  btnTask4.Enabled  := False;
end;

procedure TfrmWorkup.Task1Enable;
begin
  lblTTask1.Enabled := True;
  edTask1.Enabled   := True;
  btnTask1.Enabled  := True;
end;

procedure TfrmWorkup.Task2Enable;
begin
  lblTTask2.Enabled := True;
  edTask2.Enabled   := True;
  btnTask2.Enabled  := True;
end;

procedure TfrmWorkup.Task3Enable;
begin
  lblTTask3.Enabled := True;
  edTask3.Enabled   := True;
  btnTask3.Enabled  := True;
end;

procedure TfrmWorkup.Task4Enable;
begin
  lblTTask4.Enabled := True;
  edTask4.Enabled   := True;
  btnTask4.Enabled  := True;
end;

procedure TfrmWorkup.cbTask1Change(Sender: TObject);
begin
  Task1IFN := IntToStr(cbTask1.ItemIEN);
  Task1Enable;
  TabSheet5.Highlighted := True;
  Change := 1;
end;

procedure TfrmWorkup.cbTask1Click(Sender: TObject);
begin
  cbTask1.Color     := clWindow;
end;

procedure TfrmWorkup.cbTask2Change(Sender: TObject);
begin
  Task2IFN := IntToStr(cbTask2.ItemIEN);
  Task2Enable;
  TabSheet6.Highlighted := True;
  Change := 1;
end;

procedure TfrmWorkup.cbTask2Click(Sender: TObject);
begin
  cbTask2.Color     := clWindow;
end;

procedure TfrmWorkup.cbTask3Change(Sender: TObject);
begin
  Task3IFN := IntToStr(cbTask3.ItemIEN);
  Task3Enable;
  TabSheet7.Highlighted := True;
  Change := 1;
end;

procedure TfrmWorkup.cbTask3Click(Sender: TObject);
begin
  cbTask3.Color     := clWindow;
end;

procedure TfrmWorkup.cbTask4Change(Sender: TObject);
begin
  Task4IFN := IntToStr(cbTask4.ItemIEN);
  Task4Enable;
  TabSheet8.Highlighted := True;
  Change := 1;
end;

procedure TfrmWorkup.cbTask4Click(Sender: TObject);
begin
  cbTask4.Color     := clWindow;
end;

procedure TfrmWorkup.btnTask1Click(Sender: TObject);
begin
  cbTask1.Text      := '';
  edTask1.Clear;
  TabSheet5.Highlighted := False;
end;

procedure TfrmWorkup.btnTask2Click(Sender: TObject);
begin
  cbTask2.Text      := '';
  edTask2.Clear;
  TabSheet6.Highlighted := False;
end;

procedure TfrmWorkup.btnTask3Click(Sender: TObject);
begin
  cbTask3.Text      := '';
  edTask3.Clear;
  TabSheet7.Highlighted := False;
end;

procedure TfrmWorkup.btnTask4Click(Sender: TObject);
begin
  cbTask4.Text      := '';
  edTask4.Clear;
  TabSheet8.Highlighted := False;
end;

 procedure TfrmWorkup.edTask1Change(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmWorkup.edTask2Change(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmWorkup.edTask3Change(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmWorkup.edTask4Change(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmWorkup.btnExitClick(Sender: TObject);
begin
  Close;
end;

end.
