unit fWait;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, ORCtrls, TRPCB, ORFn, ORNet, ComCtrls,
  Buttons, ORDtTm;

type
  TfrmProcedure = class(TForm)
    pnl1: TPanel;
    bvl1: TBevel;
    lblFind: TLabel;
    memFind: TMemo;
    lblDiag: TLabel;
    edDiag: TEdit;
    lblBrief: TLabel;
    memBrief: TMemo;
    lblRes: TLabel;
    lblAtt: TLabel;
    lblComp: TLabel;
    lblLen: TLabel;
    edLen: TEdit;
    edOrd: TEdit;
    lblOrd: TLabel;
    lblTyp: TLabel;
    lblStat: TLabel;
    lblDis: TLabel;
    lblNeed: TLabel;
    lblEq: TLabel;
    edNeed: TEdit;
    edEq: TEdit;
    cbRes: TORComboBox;
    cbAtt: TORComboBox;
    cbStat: TORComboBox;
    cbDis: TORComboBox;
    lblStar2: TLabel;
    lblStar3: TLabel;
    lblStar4: TLabel;
    lblStar5: TLabel;
    cbType: TORComboBox;
    lblStar6: TLabel;
    pnl4: TPanel;
    btnCan: TBitBtn;
    pnl6: TPanel;
    cbCPT: TORComboBox;
    lblCPT: TLabel;
    edProc: TEdit;
    lblFTProc: TLabel;
    cbProc: TORComboBox;
    lblProc: TLabel;
    lblStar0: TLabel;
    lblOr: TLabel;
    lblLocal: TLabel;
    lblStar15: TLabel;
    cbComp: TORComboBox;
    ORDateTimeDlg1: TORDateTimeDlg;
    btnSec: TPanel;
    lblStar1: TLabel;
    lblLat: TLabel;
    cbLat: TORComboBox;
    edLoc: TEdit;
    lblLoc: TLabel;
    cbSC: TORComboBox;
    lblSC: TLabel;
    lblGComm: TLabel;
    edGComm: TCaptionRichEdit;
    btnNext: TButton;
    lblSpec: TLabel;
    procedure btnCanClick(Sender: TObject);
    procedure cbResChange(Sender: TObject);
    procedure cbAttChange(Sender: TObject);
    procedure btnTranClick(Sender: TObject);
    procedure CollectData;
    procedure cbLatClick(Sender: TObject);
    procedure cbResClick(Sender: TObject);
    procedure cbAttClick(Sender: TObject);
    procedure cbStatClick(Sender: TObject);
    procedure cbDisClick(Sender: TObject);
    function CheckEdit(): integer;
    procedure cbProcChange(Sender: TObject);
    procedure cbProcClick(Sender: TObject);
    procedure cbTypeClick(Sender: TObject);
    procedure btnSaveClick(Sender: TObject);
    procedure cbLatChange(Sender: TObject);
    procedure memFindChange(Sender: TObject);
    procedure edDiagChange(Sender: TObject);
    procedure memBriefChange(Sender: TObject);
    procedure edTimeChange(Sender: TObject);
    procedure edLenChange(Sender: TObject);
    procedure edCompChange(Sender: TObject);
    procedure edOrdChange(Sender: TObject);
    procedure cbTypeChange(Sender: TObject);
    procedure cbStatChange(Sender: TObject);
    procedure cbDisChange(Sender: TObject);
    procedure edNeedChange(Sender: TObject);
    procedure edEqChange(Sender: TObject);
    procedure btnConClick(Sender: TObject);
    procedure HideMedClr;
    procedure btnOrdClick(Sender: TObject);
    procedure CheckStatus;
    procedure cbMed1Change(Sender: TObject);
    procedure cbxMed1Click(Sender: TObject);
    procedure cbMed2Change(Sender: TObject);
    procedure cbxMed2Click(Sender: TObject);
    procedure cbMed3Change(Sender: TObject);
    procedure cbxMed3Click(Sender: TObject);
    procedure cbMed4Change(Sender: TObject);
    procedure cbxMed4Click(Sender: TObject);
    procedure Med1Enable;
    procedure Med2Enable;
    procedure Med3Enable;
    procedure Med4Enable;
    procedure DisableMedClr;
    procedure edCon1Change(Sender: TObject);
    procedure edOrder1Change(Sender: TObject);
    procedure edMed1Change(Sender: TObject);
    procedure edCon2Change(Sender: TObject);
    procedure edOrder2Change(Sender: TObject);
    procedure edMed2Change(Sender: TObject);
    procedure edCon3Change(Sender: TObject);
    procedure edOrder3Change(Sender: TObject);
    procedure edMed3Change(Sender: TObject);
    procedure edCon4Change(Sender: TObject);
    procedure edOrder4Change(Sender: TObject);
    procedure edMed4Change(Sender: TObject);
    procedure edWaitChange(Sender: TObject);
    procedure btnClr1Click(Sender: TObject);
    procedure btnClr2Click(Sender: TObject);
    procedure btnClr3Click(Sender: TObject);
    procedure btnClr4Click(Sender: TObject);
    procedure cbMed1Click(Sender: TObject);
    procedure cbMed2Click(Sender: TObject);
    procedure cbMed3Click(Sender: TObject);
    procedure cbMed4Click(Sender: TObject);
    procedure NotComplete;
    procedure NotComplete2;
    procedure Complete;
    procedure Complete2;
    procedure HideTasks;
    procedure DisableTasks;
    procedure Task1Enable;
    procedure Task2Enable;
    procedure Task3Enable;
    procedure Task4Enable;
    procedure cbTask1Change(Sender: TObject);
    procedure cbTask1Click(Sender: TObject);
    procedure cbTask2Change(Sender: TObject);
    procedure cbTask2Click(Sender: TObject);
    procedure cbTask3Change(Sender: TObject);
    procedure cbTask3Click(Sender: TObject);
    procedure cbTask4Change(Sender: TObject);
    procedure cbTask4Click(Sender: TObject);
    procedure cbxTask4Click(Sender: TObject);
    procedure cbxTask2Click(Sender: TObject);
    procedure cbxTask3Click(Sender: TObject);
    procedure cbxTask1Click(Sender: TObject);
    procedure btnTask1Click(Sender: TObject);
    procedure btnTask2Click(Sender: TObject);
    procedure btnTask3Click(Sender: TObject);
    procedure btnTask4Click(Sender: TObject);
    procedure cbCPTChange(Sender: TObject);
    procedure cbCPTClick(Sender: TObject);
    procedure cbCompChange(Sender: TObject);
    procedure cbCompClick(Sender: TObject);
    procedure edProcChange(Sender: TObject);
    procedure btnSecClick(Sender: TObject);
    procedure CheckMedStatus;
    procedure CheckSurgStatus;
    procedure cbResKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure edGCommChange(Sender: TObject);
    procedure cbSCChange(Sender: TObject);
    procedure cbSCClick(Sender: TObject);
    procedure edLocChange(Sender: TObject);
    procedure dbManualChange(Sender: TObject);
    procedure edTask1Change(Sender: TObject);
    procedure edTask2Change(Sender: TObject);
    procedure edTask3Change(Sender: TObject);
    procedure edTask4Change(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmProcedure: TfrmProcedure;
  star0, star1, star2, star3, star4, star5, star6, star7, star8,star9, star10: integer;
  star11, star12, star13, star14, star15: integer;
  LProcIFN, LProcName, LatIFN, ResIFN, AttIFN, CompIFN, TypeIFN, StatIFN, DisIFN, SCIFN: string;
  ProcName, ProcCPT, CPTIFN, ListName, ListType, PatientDFN, List: string;
  Change, OtChange, wlifn, Edit, Source: integer;
  Med1IFN, Med2IFN, Med3IFN, Med4IFN: string;
  Task1IFN, Task2IFN, Task3IFN, Task4IFN: string;
  Sec1IFN, Sec2IFN, Sec3IFN, Sec4IFN: string;

procedure Wait(WLData: TStrings; Source: integer; List: string);

implementation

{$R *.dfm}

uses SurgReqMain, uCore, fConsults, fOrder, fOther;

procedure Wait(WLData: TStrings; Source: integer; List: string);
// Source - 1 = new entry from request note
//          2 = edit entry
//          3 = direct entry
// List   - A = Action-Required List
//          W = Wait List
//          R = Request List
//          S = Scheduled List
var
  I, J, Local: integer;
  Data, Code: string;
begin
  frmWait := TfrmWait.Create(Application);
  with frmWait do
    begin
      ListType := List;
      Change   := 0;
      OtChange := 0;
      //PutFlag  := 0;
      lbSec.Items.Create;
      if List = 'A' then
        begin
          ListName          := 'Action Required List';
          btnTran.Caption   := 'Put on Action Required List';
          pcMed.ActivePage  := TabSheet1;
          pcTask.ActivePage := TabSheet5;
          DisableMedClr;
          DisableTasks;
          lblWait.Caption  := ListName + lblWait.Caption;
        end;
      if List = 'W' then
        begin
          ListName := 'Wait List';
          HideMedClr;
          HideTasks;
          btnCon.Enabled := False;
          btnOrd.Enabled := False;
          lblWait.Caption := ListName + lblWait.Caption;
        end;
      Caption := Caption + ListName + ' for ' + piece(WLData[0], '^', 2);
      if UserSite <> 648 then  // for portland only
        begin
          lblEq.Enabled := False;
          edEq.Enabled  := False;
        end;
      if Source = 3 then Caption := 'Direct Entry on ' + ListName + ' for ' + piece(WLData[0], '^', 2);
      if Source <> 1 then
        begin
          lblManual.Visible := True;
          dbManual.Visible  := True;
        end;
      if (UsePTLD = 0) then
        begin
          lblLocal.Enabled := False;
          lblProc.Enabled  := False;
          cbProc.Enabled   := False;
          lblOR.Enabled    := False;
          edProc.Text      := piece(WLData[22], '^', 2);
          // if Source = 2 then edProc.Text := piece(WLData[22], '^', 3);
          lblStar0.Caption := '';
          ProcName         := edProc.Text;
          ProcCPT          := '';
          LProcIFN         := '';
          LProcName        := '';
          lblEq.Visible    := False;
          edEq.Visible     := False;
        end;
      if (UsePtld = 1) then
        begin
          CallV('APTWL GET PROC', []);
          cbProc.Items := RPCBrokerV.Results;
          Local := StrToInt(piece(WLData[22], '^', 5));
          if Local = 1 then  // portland procedure
            begin
              cbProc.Text := piece(WLData[22], '^', 2);
              LProcName   := cbProc.Text;
              LProcIFN    := piece(WLData[22], '^', 1);
              ProcName    := '';
              if LProcIFN <> '' then lblStar0.Caption := '';
            end;
          if Local = 0 then  // free text procedure
            begin
              edProc.Text := piece(WLData[22],'^', 2);
              ProcName    := edProc.Text;
              LProcName   := '';
              LProcIFN    := '';
              lblStar0.Caption := '';
            end;
          CPTIFN      := piece(WLData[22], '^', 3);
          cbCPT.Text  := piece(WLData[22], '^', 4);
          ProcCPT     := cbCPT.Text;
        end;
      PatientDFN  := piece(WLData[0], '^', 1);
      cbLat.Text  := piece(WLData[7], '^', 2);
      //cbPos.Text  := piece(WLData(42), '^', 2);
      memFind.Lines[0]  := WLData[8];
      edDiag.Text := WLData[9];
      memBrief.Lines[0] := WLData[10];
      cbRes.Text  := piece(WLData[11], '^', 2);
      ResIFN      := piece(WLData[11], '^', 1);
      cbAtt.Text  := piece(WLData[12], '^', 2);
      AttIFN      := piece(WLData[12], '^', 1);
      // edTime.Text := WLData[13];      // removed 1-14-08
      edLen.Text  := WLData[14];
      cbComp.Text := piece(WLData[15], '^', 2);
      edOrd.Text  := WLData[16];
      cbType.Text := piece(WLData[17], '^', 2);
      cbStat.Text := piece(WLData[18], '^', 2);
      cbDis.Text  := piece(WLData[19], '^', 2);
      edNeed.Text := WLData[20];
      edEq.Text   := WLData[21];
      NIFN        := StrToInt(WLData[26]);
      // secondary procedures, comments, proc location
      if Source = 1 then   // from parsed note
        begin
          if WLData[43] <> '' then
            begin
              lbSec.Items.Add(WLData[43]);
              btnSec.Color      := clRed;
              btnSec.Font.Color := clWhite;
            end;
          if WLData[44] <> '' then lbSec.Items.Add(WLData[44]);
          if WLData[45] <> '' then lbSec.Items.Add(WLData[45]);
          if WLData[46] <> '' then lbSec.Items.Add(WLData[46]);
          if WLData[47] <> '' then lbSec.Items.Add(WLData[47]);
          if WLData[48] <> '' then lbSec.Items.Add(WLData[48]);
          for J := 1 to 3 do edGComm.Lines.Add(piece(WLData[49], '^', J));
          edLoc.Text  := WLData[50];
          cbSC.Text   := WLData[51];
          SCIFN := '';
          if cbSC.Text <> '' then
            begin
              if cbSC.Text = 'Yes' then SCIFN := '1';
              if cbSC.Text = 'No' then SCIFN := '0';
            end;
        end;
      //
      CallV('APTWL GET CPT', []);
      cbCPT.Items := RPCBrokerV.Results;
      CallV('APTWL GET LATERALITY', []);
      cbLat.Items := RPCBrokerV.Results;
      for J := 0 to cbLat.Items.Count-1 do
        begin
          if piece(cbLat.Items[J], '^', 2) = cbLat.Text then
          begin
            LatIFN := piece(cbLat.Items[J], '^', 1);
            lblStar1.Caption := '';
            Break;
          end;
        end;
      CallV('APTWL GET PROVIDER', ['S', SpecIFN]);
      cbRes.Items := RPCBrokerV.Results;
      if (cbRes.Text = '') or (cbRes.Text = 'none') or (ResIFN <> '') then lblStar2.Caption := '';
      cbAtt.Items := RPCBrokerV.Results;
      if (cbAtt.Text = '') or (cbAtt.Text = 'none') or (AttIFN <> '') then lblStar3.Caption := '';
      CallV('APTWL GET COMPLEX', []);
      cbComp.Items := RPCBrokerV.Results;
      for J := 0 to cbComp.Items.Count-1 do
        begin
          if piece(cbComp.Items[J], '^', 2) = cbComp.Text then
          begin
            CompIFN := piece(cbComp.Items[J], '^', 1);
            lblStar15.Caption := '';
            Break;
          end;
        end;
      CallV('APTWL GET PTSTAT', []);
      cbStat.Items := RPCBrokerV.Results;
      for J := 0 to cbStat.Items.Count-1 do
        begin
          if piece(cbStat.Items[J], '^', 2) = cbStat.Text then
          begin
            StatIFN := piece(cbStat.Items[J], '^', 1);
            lblStar4.Caption := '';
            Break;
          end;
        end;
      CallV('APTWL GET DISPO', []);
      cbDis.Items := RPCBrokerV.Results;
      for J := 0 to cbDis.Items.Count-1 do
        begin
          if piece(cbDis.Items[J], '^', 2) = UpperCase(cbDis.Text) then
          begin
            DisIFN := piece(cbDis.Items[J], '^', 1);
            lblStar5.Caption := '';
            Break;
          end;
        end;
      CallV('APTWL GET TYPE', []);
      cbType.Items := RPCBrokerV.Results;
      for J := 0 to cbType.Items.Count-1 do
        begin
          if piece(cbType.Items[J], '^', 2) = cbType.Text then
          begin
            TypeIFN := piece(cbType.Items[J], '^', 1);
            lblStar6.Caption := '';
            Break;
          end;
        end;
      if List = 'A' then
        begin
          CallV('APTWL GET TASK LIST', [SpecIFN]);
          cbTask1.Items := RPCBrokerV.Results;
          cbTask2.Items := RPCBrokerV.Results;
          cbTask3.Items := RPCBrokerV.Results;
          cbTask4.Items := RPCBrokerV.Results;
          CallV('APTWL GET ISSUE LIST', []);
          cbMed1.Items  := RPCBrokerV.Results;
          cbMed2.Items  := RPCBrokerV.Results;
          cbMed3.Items  := RPCBrokerV.Results;
          cbMed4.Items  := RPCBrokerV.Results;
          cbTask4.Items := RPCBrokerV.Results;
          if (Source = 1) or (Source = 3) then  // from request note
          begin
            cbMed1.Text      := piece(WLData[34], '^', 1);
            edMed1.Lines[0]  := piece(WLData[34], '^', 2);
            cbMed2.Text      := piece(WLData[35], '^', 1);
            edMed2.Lines[0]  := piece(WLData[35], '^', 2);
            cbMed3.Text      := piece(WLData[36], '^', 1);
            edMed3.Lines[0]  := piece(WLData[36], '^', 2);
            cbMed4.Text      := piece(WLData[37], '^', 1);
            edMed4.Lines[0]  := piece(WLData[37], '^', 2);
            cbTask1.Text     := piece(WLData[38], '^', 1);
            edTask1.Lines[0] := piece(WLData[38], '^', 2);
            cbTask2.Text     := piece(WLData[39], '^', 1);
            edTask2.Lines[0] := piece(WLData[39], '^', 2);
            cbTask3.Text     := piece(WLData[40], '^', 1);
            edTask3.Lines[0] := piece(WLData[40], '^', 2);
            cbTask4.Text     := piece(WLData[41], '^', 1);
            edTask4.Lines[0] := piece(WLData[41], '^', 2);
            if cbMed1.Text <> '' then
              begin
                TabSheet1.Highlighted := True;
                Med1Enable;
                for J := 0 to cbMed1.Items.Count -1 do
                  begin
                    if piece(cbMed1.Items[J], '^', 2) = cbMed1.Text then
                      begin
                        Med1IFN := piece(cbMed1.Items[J], '^', 1);
                        lblStar7.Caption := '';
                        Break;
                      end;
                  end;
              end
            else lblStar7.Caption := '';
            if cbMed2.Text <> '' then
              begin
                TabSheet2.Highlighted := True;
                Med2Enable;
                for J := 0 to cbMed2.Items.Count -1 do
                  begin
                    if piece(cbMed2.Items[J], '^', 2) = cbMed2.Text then
                      begin
                        Med2IFN := piece(cbMed2.Items[J], '^', 1);
                        lblStar8.Caption := '';
                        Break;
                      end;
                  end;
              end
            else lblStar8.Caption := '';
            if cbMed3.Text <> '' then
              begin
                TabSheet3.Highlighted := True;
                Med3Enable;
                for J := 0 to cbMed3.Items.Count -1 do
                  begin
                    if piece(cbMed3.Items[J], '^', 2) = cbMed3.Text then
                      begin
                        Med3IFN := piece(cbMed3.Items[J], '^', 1);
                        lblStar9.Caption := '';
                        Break;
                      end;
                  end;
              end
            else lblStar9.Caption := '';
            if cbMed4.Text <> '' then
              begin
                TabSheet4.Highlighted := True;
                Med4Enable;
                for J := 0 to cbMed4.Items.Count -1 do
                  begin
                    if piece(cbMed4.Items[J], '^', 2) = cbMed4.Text then
                      begin
                        Med4IFN := piece(cbMed4.Items[J], '^', 1);
                        lblStar10.Caption := '';
                        Break;
                      end;
                  end;
              end
            else lblStar10.Caption := '';
            if cbTask1.Text <> '' then
              begin
                TabSheet5.Highlighted := True;
                Task1Enable;
                for J := 0 to cbTask1.Items.Count -1 do
                  begin
                    if piece(cbTask1.Items[J], '^', 2) = cbTask1.Text then
                      begin
                        Task1IFN := piece(cbTask1.Items[J], '^', 1);
                        lblStar11.Caption := '';
                        Break;
                      end;
                  end;
              end
            else lblStar11.Caption := '';
            if cbTask2.Text <> '' then
              begin
                TabSheet6.Highlighted := True;
                Task2Enable;
                for J := 0 to cbTask2.Items.Count -1 do
                  begin
                    if piece(cbTask2.Items[J], '^', 2) = cbTask2.Text then
                      begin
                        Task2IFN := piece(cbTask2.Items[J], '^', 1);
                        lblStar12.Caption := '';
                        Break;
                      end;
                  end;
              end
            else lblStar12.Caption := '';
            if cbTask3.Text <> '' then
              begin
                TabSheet7.Highlighted := True;
                Task3Enable;
                for J := 0 to cbTask3.Items.Count -1 do
                  begin
                    if piece(cbTask3.Items[J], '^', 2) = cbTask3.Text then
                      begin
                        Task3IFN := piece(cbTask3.Items[J], '^', 1);
                        lblStar13.Caption := '';
                        Break;
                      end;
                  end;
              end
            else lblStar13.Caption := '';
            if cbTask4.Text <> '' then
              begin
                TabSheet8.Highlighted := True;
                Task4Enable;
                for J := 0 to cbTask4.Items.Count -1 do
                  begin
                    if piece(cbTask4.Items[J], '^', 2) = cbTask4.Text then
                      begin
                        Task4IFN := piece(cbTask4.Items[J], '^', 1);
                        lblStar14.Caption := '';
                        Break;
                      end;
                  end;
              end
            else lblStar14.Caption := '';
            CheckStatus;
          end;
        end;
      btnTran.Visible := False;
      btnSave.Visible := False;
      Edit := Source;
      if (Source = 1) or (Source = 3) then btnTran.Visible := True;
      if Source = 2 then  // editing
      begin
        btnSave.Visible := True;
        Caption  := 'Edit ' + ListName + ' Entry for ' + piece(WLData[0], '^', 2);
        wlifn    := StrToInt(WLData[24]);
        LProcIFN := piece(WLData[22], '^', 1);
        CPTIFN   := piece(WLData[22], '^', 3);
        LatIFN   := piece(WLData[7], '^', 1);
        ResIFN   := piece(WLData[11], '^', 1);
        AttIFN   := piece(WLData[12], '^', 1);
        CompIFN  := piece(WLData[15], '^', 1);
        TypeIFN  := piece(WLData[17], '^', 1);
        StatIFN  := piece(WLData[18], '^', 1);
        DisIFN   := piece(WLData[19], '^', 1);
        if WLData[55] <> '' then dbManual.FMDateTime := StrToFloat(piece(WLData[55], '^', 1));
        for J := 1 to 3 do edGComm.Lines.Add(piece(WLData[58], '^', J));
        edLoc.Text := WLData[59];
        cbSC.Text   := piece(WLData[61], '^', 2);
        SCIFN := '';
        if cbSC.Text <> '' then
          begin
            if cbSC.Text = 'Yes' then SCIFN := '1';
            if cbSC.Text = 'No' then SCIFN := '0';
          end;
        //if WLData[42] = 'YES' then cbxAnes.Checked := True;
        if list = 'A' then
          begin
            edMed1.Clear;
            edMed2.Clear;
            edMed3.Clear;
            edMed4.Clear;
            edTask1.Clear;
            edTask2.Clear;
            edTask3.Clear;
            edTask4.Clear;
            if WLData[34] <> '' then
              begin
                TabSheet1.Highlighted := True;
                cbMed1.Text   := piece(piece(WLData[34], '^', 1), ':', 2);
                Med1IFN       := piece(piece(WLData[34], '^', 1), ':', 1);
                edCon1.Text   := piece(WLData[34], '^', 4);
                edOrder1.Text := piece(WLData[34], '^', 6);
                if piece(WLdata[34], '^', 5) <> '' then cbxMed1.Checked := True;
                if WLData[38] <> '' then for I := 1 to 4 do edMed1.Lines.Add(piece(WLData[38], '^', I));
                Med1Enable;
                lblStar7.Caption := '';
              end
            else lblStar7.Caption := '';
            if WLData[35] <> '' then
              begin
                TabSheet2.Highlighted := True;
                cbMed2.Text   := piece(piece(WLData[35], '^', 1), ':', 2);
                Med2IFN       := piece(piece(WLData[35], '^', 1), ':', 1);
                edCon2.Text   := piece(WLData[35], '^', 4);
                edOrder2.Text := piece(WLData[35], '^', 6);
                if piece(WLdata[35], '^', 5) <> '' then cbxMed2.Checked := True;
                if WLData[39] <> '' then for I := 1 to 4 do edMed2.Lines.Add(piece(WLData[39], '^', I));
                Med2Enable;
                lblStar8.Caption := '';
              end
            else lblStar8.Caption := '';
            if WLData[36] <> '' then
              begin
                TabSheet3.Highlighted := True;
                cbMed3.Text   := piece(piece(WLData[36], '^', 1), ':', 2);
                Med3IFN       := piece(piece(WLData[36], '^', 1), ':', 1);
                edCon3.Text   := piece(WLData[36], '^', 4);
                edOrder3.Text := piece(WLData[36], '^', 6);
                if piece(WLdata[36], '^', 5) <> '' then cbxMed3.Checked := True;
                if WLData[40] <> '' then for I := 1 to 4 do edMed3.Lines.Add(piece(WLData[40], '^', I));
                Med3Enable;
                lblStar9.Caption := '';
              end
            else lblStar9.Caption := '';
            if WLData[37] <> '' then
              begin
                TabSheet4.Highlighted := True;
                cbMed4.Text   := piece(piece(WLData[37], '^', 1), ':', 2);
                Med4IFN       := piece(piece(WLData[37], '^', 1), ':', 1);
                edCon4.Text   := piece(WLData[37], '^', 4);
                edOrder4.Text := piece(WLData[37], '^', 6);
                if piece(WLdata[37], '^', 5) <> '' then cbxMed4.Checked := True;
                if WLData[41] <> '' then for I := 1 to 4 do edMed4.Lines.Add(piece(WLData[41], '^', I));
                Med4Enable;
                lblStar10.Caption := '';
              end
            else lblStar10.Caption := '';
            if WLData[43] <> '' then
              begin
                TabSheet5.Highlighted := True;
                cbTask1.Text   := piece(piece(WLData[43], '^', 1), ':', 2);
                Task1IFN       := piece(piece(WLData[43], '^', 1), ':', 1);
                if piece(WLData[43], '^', 4) <> '' then cbxTask1.Checked := True;
                if WLData[47] <> '' then for I := 1 to 4 do edTask1.Lines.Add(piece(WLData[47], '^', I));
                Task1Enable;
                lblStar11.Caption := '';
              end
            else lblStar11.Caption := '';
            if WLData[44] <> '' then
              begin
                TabSheet6.Highlighted := True;
                cbTask2.Text   := piece(piece(WLData[44], '^', 1), ':', 2);
                Task2IFN       := piece(piece(WLData[44], '^', 1), ':', 1);
                if piece(WLdata[44], '^', 4) <> '' then cbxTask2.Checked := True;
                if WLData[48] <> '' then for I := 1 to 4 do edTask2.Lines.Add(piece(WLData[48], '^', I));
                Task2Enable;
                lblStar12.Caption := '';
              end
            else lblStar12.Caption := '';
            if WLData[45] <> '' then
              begin
                TabSheet7.Highlighted := True;
                cbTask3.Text   := piece(piece(WLData[45], '^', 1), ':', 2);
                Task3IFN       := piece(piece(WLData[45], '^', 1), ':', 1);
                if piece(WLdata[45], '^', 4) <> '' then cbxTask3.Checked := True;
                if WLData[49] <> '' then for I := 1 to 4 do edTask3.Lines.Add(piece(WLData[49], '^', I));
                Task3Enable;
                lblStar13.Caption := '';
              end
            else lblStar13.Caption := '';
            if WLData[46] <> '' then
              begin
                TabSheet8.Highlighted := True;
                cbTask4.Text   := piece(piece(WLData[46], '^', 1), ':', 2);
                Task4IFN       := piece(piece(WLData[46], '^', 1), ':', 1);
                if piece(WLdata[46], '^', 4) <> '' then cbxTask4.Checked := True;
                if WLData[50] <> '' then for I := 1 to 4 do edTask4.Lines.Add(piece(WLData[50], '^', I));
                Task4Enable;
                lblStar14.Caption := '';
              end
            else lblStar14.Caption := '';
            CheckStatus;
            end;
          // secondary procedures
          if WLData[51] <> '' then
            begin
              lbSec.Items.Add(WLData[51]);
              btnSec.Color      := clRed;
              btnSec.Font.Color := clWhite;
            end;
          if WLData[52] <> '' then lbSec.Items.Add(WLData[52]);
          if WLData[53] <> '' then lbSec.Items.Add(WLData[53]);
          if WLData[54] <> '' then lbSec.Items.Add(WLData[54]);
          if WLData[56] <> '' then lbSec.Items.Add(WLData[56]);
          if WLData[57] <> '' then lbSec.Items.Add(WLData[57]);
          end;
      Change := 0;
      //if (UsePTLD = 1) then cbProc.SetFocus;
      //if (UsePTLD = 0) then edProc.SetFocus;
      ShowModal;
    end;
  frmWait.Release;
end;


procedure TfrmProcedure.btnCanClick(Sender: TObject);
begin
  Close;
end;

procedure TfrmProcedure.cbResChange(Sender: TObject);
begin
  CallV('APTWL GET PROVIDER', ['S', SpecIFN, cbRes.Text]);
  cbRes.Items := RPCBrokerV.Results;
  cbRes.DroppedDown := True;
  Change := 1;
end;

procedure TfrmProcedure.cbAttChange(Sender: TObject);
begin
  CallV('APTWL GET PROVIDER', ['S', SpecIFN, cbAtt.Text]);
  cbAtt.Items := RPCBrokerV.Results;
  cbAtt.DroppedDown := True;
  Change := 1;
end;

procedure TfrmProcedure.btnTranClick(Sender: TObject);
var
  cnt: integer;
  Success: string;
begin
  if CheckEdit = 0 then
    begin
      cnt := 0;
      MessageDlg('Please edit the data in all "starred" boxes', mtwarning, [mbOK], 0);
      if star0 = 1 then
        begin
          cbProc.Color := clSkyBlue;
          if cnt = 0 then
            begin
              cbProc.SetFocus;
              cnt := 1;
            end;
        end;
      if star1 = 1 then
        begin
          cbLat.Color := clSkyBlue;
          if cnt = 0 then
            begin
              cbLat.SetFocus;
              cnt := 1;
            end;
        end;
      if star2 = 1 then
        begin
          cbRes.Color := clSkyBlue;
          if cnt = 0 then
            begin
              cbRes.SetFocus;
              cnt := 1;
            end;
        end;
      if star3 = 1 then
        begin
          cbAtt.Color := clSkyBlue;
          if cnt = 0 then
            begin
              cbAtt.SetFocus;
              cnt := 1;
            end;
        end;
      if star4 = 1 then
        begin
          cbStat.Color := clSkyBlue;
          if cnt = 0 then
            begin
              cbStat.SetFocus;
              cnt := 1;
            end;
        end;
      if star5 = 1 then
        begin
          cbDis.Color := clSkyBlue;
          if cnt = 0 then
            begin
              cbDis.SetFocus;
              cnt := 1;
            end;
        end;
      if star6 = 1 then
        begin
          cbType.Color := clSkyBlue;
          if cnt = 0 then
            begin
              cbType.SetFocus;
              cnt := 1;
            end;
        end;
      if (list = 'W') then Exit;
      // issues
      if star7 = 1 then
        begin
          cbMed1.Color := clSkyBlue;
          if cnt = 0 then
            begin
              cbMed1.SetFocus;
              cnt := 1;
            end;
        end;
      if star8 = 1 then
        begin
          cbMed2.Color := clSkyBlue;
          if cnt = 0 then
            begin
              cbMed2.SetFocus;
              cnt := 1;
            end;
        end;
      if star9 = 1 then
        begin
          cbMed3.Color := clSkyBlue;
          if cnt = 0 then
            begin
              cbMed3.SetFocus;
              cnt := 1;
            end;
        end;
      if star10 = 1 then
        begin
          cbMed4.Color := clSkyBlue;
          if cnt = 0 then
            begin
              cbMed4.SetFocus;
              cnt := 1;
            end;
        end;
      // tasks
      if star11 = 1 then
        begin
          cbTask1.Color := clSkyBlue;
          if cnt = 0 then
            begin
              cbTask1.SetFocus;
              cnt := 1;
            end;
        end;
      if star12 = 1 then
        begin
          cbTask2.Color := clSkyBlue;
          if cnt = 0 then
            begin
              cbTask2.SetFocus;
              cnt := 1;
            end;
        end;
      if star13 = 1 then
        begin
          cbTask3.Color := clSkyBlue;
          if cnt = 0 then
            begin
              cbTask3.SetFocus;
              cnt := 1;
            end;
        end;
      if star14 = 1 then
        begin
          cbTask4.Color := clSkyBlue;
          if cnt = 0 then
            begin
              cbTask4.SetFocus;
              cnt := 1;
            end;
        end;
      // complexity
      if star15 = 1 then
        begin
          cbComp.Color := clSkyBlue;
          if cnt=0 then
            begin
              cbComp.SetFocus;
              cnt := 1;
            end;
        end;
      Exit;
    end;
  CollectData;
  Success := sCallV('APTWL PUT WAIT LIST', [lbFinal.Items, edMed1.Lines, edMed2.Lines, edMed3.Lines, edMed4.Lines, edTask1.Lines, edTask2.Lines, edTask3.Lines, edTask4.Lines, edWait.Lines, ListType, lbSec.Items, edGComm.Lines]);
  if piece(Success, '^', 1) = '0' then
    begin
      MessageDlg(piece(Success, '^', 2), mterror, [mbOK], 0);
    end;
  if piece(Success, '^', 1) = '1' then
    begin
      MessageDlg('Patient added to the ' + ListName + ' successfully.' + CRLF
      + 'Acession: ' + SpecAbbr + ' ' + piece(success, '^', 2), mtinformation, [mbOK], 0);
      //if Source = 1 then PutFlag := 1;
      Close;
    end;
end;

procedure TfrmProcedure.CollectData;
var
  I: integer;
begin
  if cbProc.Text = '' then LProcIFN := '';
  if cbCPT.Text  = '' then CPTIFN   := '';
  if cbLat.Text  = '' then LatIFN   := '';
  if cbRes.Text  = '' then ResIFN   := '';
  if cbAtt.Text  = '' then AttIFN   := '';
  if cbComp.Text = '' then CompIFN  := '';
  if cbType.Text = '' then TypeIFN  := '';
  if cbStat.Text = '' then StatIFN  := '';
  if cbDis.Text  = '' then DisIFN   := '';
  lbFinal.Clear;
  lbFinal.Items[0]  := LProcIFN + '^' + LProcName + '^' + ProcName + '^' + CPTIFN;
  lbFinal.Items[1]  := PatientDFN;
  lbFinal.Items[2]  := LatIFN + '^' + edLoc.Text;
  lbFinal.Items[3]  := memFind.Lines[0] + ' ' + memFind.Lines[1];
  lbFinal.Items[4]  := edDiag.Text;
  lbFinal.Items[5]  := memBrief.Lines[0] + ' ' + memBrief.Lines[1];
  lbFinal.Items[6]  := ResIFN;
  lbFinal.Items[7]  := AttIFN;
  lbFinal.Items[8]  := SCIFN; // 2-26-08  is procedure SC
  lbFinal.Items[9]  := edLen.Text;
  lbFinal.Items[10] := CompIFN;
  lbFinal.Items[11] := edOrd.Text;
  lbFinal.Items[12] := TypeIFN;
  lbFinal.Items[13] := StatIFN;
  lbFinal.Items[14] := DisIFN;
  lbFinal.Items[15] := edNeed.Text;
  lbFinal.Items[16] := edEq.Text;
  lbFinal.Items[17] := IntToStr(SpecIFN);
  lbFinal.Items[18] := IntToStr(NIFN);
  for I := 19 to 34 do lbFinal.Items[I] := '';
  if dbManual.Text <> '' then lbFinal.Items[33] := FloatToStr(dbManual.FMDateTime);
  //if Source = 1 then lbFinal.Items[34] := IntToStr(PCPConsult);  // 1-31-08
  if ListType = 'A' then
    begin
      for I := 19 to 22 do lbFinal.Items[I] := '';
      if cbMed1.Text <> '' then lbFinal.Items[19] := Med1IFN + '^' + edCon1.Text + '^' + edOrder1.Text + '^' + BoolToStr(cbxMed1.Checked);
      if cbMed2.Text <> '' then lbFinal.Items[20] := Med2IFN + '^' + edCon2.Text + '^' + edOrder2.Text + '^' + BoolToStr(cbxMed2.Checked);
      if cbMed3.Text <> '' then lbFinal.Items[21] := Med3IFN + '^' + edCon3.Text + '^' + edOrder3.Text + '^' + BoolToStr(cbxMed3.Checked);
      if cbMed4.Text <> '' then lbFinal.Items[22] := Med4IFN + '^' + edCon4.Text + '^' + edOrder4.Text + '^' + BoolToStr(cbxMed4.Checked);
      lbFinal.Items[23] := lblMStat1.Caption;
      for I := 25 to 28 do lbFinal.Items[I] := '';
      if cbTask1.Text <> '' then lbFinal.Items[25] := Task1IFN + '^' + BoolToStr(cbxTask1.Checked);
      if cbTask2.Text <> '' then lbFinal.Items[26] := Task2IFN + '^' + BoolToStr(cbxTask2.Checked);
      if cbTask3.Text <> '' then lbFinal.Items[27] := Task3IFN + '^' + BoolToStr(cbxTask3.Checked);
      if cbTask4.Text <> '' then lbFinal.Items[28] := Task4IFN + '^' + BoolToStr(cbxTask4.Checked);
      lbFinal.Items[24] := lblSStat1.Caption;
    end;
end;

procedure TfrmProcedure.cbLatClick(Sender: TObject);
begin
  lblStar1.Caption := '';
  LatIFN := IntToStr(cbLat.ItemIEN);
  cbLat.Color := clWindow;
end;

procedure TfrmProcedure.cbResClick(Sender: TObject);
begin
  lblStar2.Caption := '';
  ResIFN := IntToStr(cbRes.ItemIEN);
  cbRes.Color := clWindow;
end;

procedure TfrmProcedure.cbAttClick(Sender: TObject);
begin
  lblStar3.Caption := '';
  AttIFN := IntToStr(cbAtt.ItemIEN);
  cbAtt.Color := clWindow;
end;

procedure TfrmProcedure.cbStatClick(Sender: TObject);
begin
  lblStar4.Caption := '';
  StatIFN := IntToStr(cbStat.ItemIEN);
  cbStat.Color := clWindow;
end;

procedure TfrmProcedure.cbDisClick(Sender: TObject);
begin
  lblStar5.Caption := '';
  DisIFN := IntToStr(cbDis.ItemIEN);
  cbDis.Color := clWindow;
end;

function TfrmProcedure.CheckEdit(): integer;
begin
  Result := 1;
  if lblStar0.Caption = '>' then
    begin
     star0 := 1;
     Result := 0;
    end;
  if lblStar1.Caption = '>' then
    begin
     star1 := 1;
     Result := 0;
    end;
  if lblStar2.Caption = '>' then
    begin
      star2 := 1;
      Result := 0;
    end;
  if lblStar3.Caption = '>' then
    begin
      star3 := 1;
      Result := 0;
    end;
  if lblStar4.Caption = '>' then
    begin
      star4 := 1;
      Result := 0;
    end;
  if lblStar5.Caption = '>' then
    begin
      star5 := 1;
      Result := 0;
    end;
  if lblStar6.Caption = '>' then
    begin
      star6 := 1;
      Result := 0;
    end;
  if (list = 'W') then Exit;
end;

procedure TfrmProcedure.cbProcChange(Sender: TObject);
begin
  if cbProc.Text = '' then Exit;
  cbProc.Items.Clear;
  CallV('APTWL GET PROC', [cbProc.Text]);
  cbProc.Items := RPCBrokerV.Results;
  cbProc.DroppedDown := True;
  Change := 1;
end;

procedure TfrmProcedure.cbProcClick(Sender: TObject);
begin
  lblStar0.Caption := '';
  LProcIFN  := IntToStr(cbProc.ItemIEN);
  LProcName := cbProc.Text;
  cbProc.Color := clWindow;
end;

procedure TfrmProcedure.cbTypeClick(Sender: TObject);
begin
  lblStar6.Caption := '';
  TypeIFN := cbType.ItemID;
  cbProc.Color := clWindow;
end;

procedure TfrmProcedure.btnSaveClick(Sender: TObject);
var
  Success: string;
begin
  if Change = 0 then
  begin
    ShowMessage('No changes were made!');
    Exit;
  end;
  CollectData;
  Success := sCallV('APTWL SAVE WAIT LIST', [SpecIFN, wlifn, ListType, lbFinal.Items, edMed1.Lines, edMed2.Lines, edMed3.Lines, edMed4.Lines, edTask1.Lines, edTask2.Lines, edTask3.Lines, edTask4.Lines, edWait.Lines, lbSec.Items, edGComm.Lines]);
  if piece(Success, '^', 1) = '0' then
    begin
      MessageDlg(piece(Success, '^', 2), mterror, [mbOK], 0);
      Exit;
    end
  else
    begin
      MessageDlg(ListName + ' entry saved successfully.' + CRLF
      + 'Acession: ' + SpecAbbr + ' ' + piece(Success, '^', 2), mtinformation, [mbOK], 0);
      Close;
    end;
end;

procedure TfrmProcedure.cbLatChange(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmProcedure.memFindChange(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmProcedure.edDiagChange(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmProcedure.memBriefChange(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmProcedure.edTimeChange(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmProcedure.edLenChange(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmProcedure.edCompChange(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmProcedure.edOrdChange(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmProcedure.cbTypeChange(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmProcedure.cbStatChange(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmProcedure.cbDisChange(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmProcedure.edNeedChange(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmProcedure.edEqChange(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmProcedure.cbCPTChange(Sender: TObject);
begin
  CallV('APTWL GET CPT', [cbCPT.Text]);
  cbCPT.Items := RPCBrokerV.Results;
  cbCPT.DroppedDown := True;
  Change := 1;
end;

procedure TfrmProcedure.cbCPTClick(Sender: TObject);
begin
  CPTIFN := IntToStr(cbCPT.ItemIEN);
end;

procedure TfrmProcedure.cbCompChange(Sender: TObject);
begin
  cbComp.DroppedDown := True;
  Change := 1;
end;

procedure TfrmProcedure.cbCompClick(Sender: TObject);
begin
  lblStar15.Caption := '';
  CompIFN := IntToStr(cbComp.ItemIEN);
  cbComp.Color := clWindow;
end;

procedure TfrmProcedure.edProcChange(Sender: TObject);
begin
  Change := 1;
  lblStar0.Caption := '';
  ProcName := edProc.Text;
end;

procedure TfrmProcedure.btnSecClick(Sender: TObject);
var
  I, Num: integer;
begin
  GetOther(lbSec, List);
  Num := lbSec.Items.Count;
  lbSec.Clear;
  with frmOther do
    begin
      if lbOther.Items.Count >0 then
        begin
          btnSec.Color      := clRed;
          btnSec.Font.Color := clWhite;
          for I := 0 to lbOther.Items.Count-1 do lbSec.Items.Add(lbOther.Items[I]);
        end
      else
        begin
          btnSec.Font.Color := clWindowText;
          btnSec.Color      := clBtnFace;
        end;
      if OtherChange = 1 then
        begin
          Change   := 1;
          OtChange := 1;
        end;
    end;
end;

procedure TfrmProcedure.cbResKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if Key = 8 then
    begin
      if cbRes.Text = '' then
        begin
          lblStar2.Caption := '';
          ResIFN := '';
        end;
    end;
end;

procedure TfrmProcedure.edGCommChange(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmProcedure.cbSCChange(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmProcedure.cbSCClick(Sender: TObject);
begin
  SCIFN := IntToStr(cbSC.ItemIEN);
end;

procedure TfrmProcedure.edLocChange(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmProcedure.dbManualChange(Sender: TObject);
begin
  Change := 1;
end;

end.
