
unit fReview;
//  ptld/jit   6-4-08

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ORNet, ORFn, Trpcb, StdCtrls, ComCtrls, ORCtrls, ExtCtrls;

type
  TfrmReview = class(TForm)
    btnPrevious: TButton;
    btnExit: TButton;
    lblSpec: TLabel;
    btnSign: TButton;
    lbNote: TORListBox;
    memNote: TMemo;
    lblNum: TLabel;
    memFinal: TMemo;
    pnlCheck: TPanel;
    lbCheck: TORListBox;
    Label1: TLabel;
    btnCheck: TButton;
    pnlSign: TPanel;
    btnSubmit: TButton;
    edSign: TEdit;
    lblSign: TLabel;
    lblNote: TLabel;
    lblProc: TLabel;
    lblSign1: TLabel;
    btnCanc: TButton;
    procedure btnPreviousClick(Sender: TObject);
    procedure btnExitClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure btnSignClick(Sender: TObject);
    procedure ConvertNote;
    procedure CheckRequiredFields;
    procedure btnCheckClick(Sender: TObject);
    procedure lbCheckClick(Sender: TObject);
    procedure edSignChange(Sender: TObject);
    procedure btnSubmitClick(Sender: TObject);
    procedure btnCancClick(Sender: TObject);
    procedure SetDocumentText;
    procedure edSignKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmReview: TfrmReview;
  SRQues, ES, TIFN, VStr, NoteIFN, Success: string;
  ReqOK, vercnt: integer;

implementation

{$R *.dfm}

uses SurgReqMain, fProcedure, fPatient, fConcur, fOther, uCore;

procedure TfrmReview.FormCreate(Sender: TObject);
begin
  //
end;

procedure TfrmReview.btnPreviousClick(Sender: TObject);
begin
  frmReview.Visible := False;
  frmReview.SendToBack;
  frmPatient.Visible := True;
  frmPatient.BringToFront;
  frmPatient.SetFocus;
end;

procedure TfrmReview.btnExitClick(Sender: TObject);
begin
  frmReview.Visible := False;
  frmReview.SendToBack;
  frmSurgReqMain.SetFocus;
end;

procedure TfrmReview.btnSignClick(Sender: TObject);
begin
  CheckRequiredFields;
end;

procedure TfrmReview.ConvertNote;
// remove null lines from draft in memNote
var
  L, OK: integer;
begin
  memFinal.Lines.Clear;
  for L := 0 to memNote.Lines.Count -1 do
    begin
      OK := 0;
      if memNote.Lines[L] = '    ' then
        begin
          memFinal.Lines.Add('');
          OK := 1;
        end;
      if (OK = 0) and (memNote.Lines[L] <> '') then memFinal.Lines.Add(memNote.Lines[L]);
    end;
end;

procedure TfrmReview.CheckRequiredFields;
var
  J: integer;
begin
  lbCheck.Items.Clear;
  pnlCheck.Visible := False;
  ReqOK := 1;
  with frmSurgReqMain do
    if VisitIFN = '' then lbCheck.Items.Add('Visit Location^Home Page^1');
  with frmConcur do
  begin
    if (rbConcur1.Checked = False) and (rbConcur2.Checked = False) and (rbConcur3.Checked = False) then
      begin
        lbCheck.Items.Add('Requestor staff position^Page 5^1');
      end;
    if (rbConcur1.Checked = True) or (rbConcur2.Checked = True) then
      if (CAttIFN = '') then
        begin
          lbCheck.Items.Add('Clinic Attending^Page 5^2');
        end;
    if (rbConcur1.Checked = True) or (rbConcur2.Checked = True) then
      if (CosigIFN = '') then
        begin
          lbCheck.Items.Add('Request Cosigner^Page 5^6');
        end;
    if (rbEval1.Checked = False) and (rbEval2.Checked = False) and (rbEval3.Checked = False) and (rbEval4.Checked = False) then
      begin
        lbCheck.Items.Add('Medical Evaluation Status^Page 5^3');
      end;
    if (rbEval3.Checked = True) or (rbEval4.Checked = True) then
      if lbMEval.Items.Count = 0 then lbCheck.Items.Add('Medical Issue^Page 5^4');
    if (rbEval2.Checked = True) or (rbEval4.Checked = True) then
      if lbSTask.Items.Count = 0 then lbCheck.Items.Add('Surgical Tasks^Page 5^5');
  end;
  with frmProcedure do
  begin
    if ProcName = '' then    lbCheck.Items.Add('Primary Procedure^Page 6^1');
    if LatIFN = '' then      lbCheck.Items.Add('Laterality^Page 6^2');
    if edDiag.Text = '' then lbCHeck.Items.Add('Diagnosis^Page 6^3');
    if CompIFN = '' then     lbCheck.Items.Add('Case Complexity^Page 6^4');
    if edLen.Text = '' then  lbCheck.Items.Add('Estimated Case Length^Page 6^5');
    if TypeIFN = '' then     lbCheck.Items.Add('Case Type^Page 6^6');
    if StatIFN = '' then     lbCheck.Items.Add('Patient Status^Page 6^7');
    if DisIFN = '' then      lbCheck.Items.Add('Post-Op Disposition^Page 6^8');
    if lbNeed.Items.Count = 0 then  lbCheck.Items.Add('Intraop Needs^Page 6^9');
    if lbEquip.Items.Count = 0 then lbCheck.Items.Add('Special Equipment^Page 6^10');
    if AttIFN = '' then      lbCheck.Items.Add('Attending^Page 6^11');
    if lbSec.Items.Count > 0 then
      begin
        for J := 0 to lbSec.Items.Count -1 do if piece(lbSec.Items[J], '^', 8) = '' then lbCheck.Items.Add('Sec Procedure Laterality^Page 9^1^' + IntToStr(J));
      end;
  end;
  with frmPatient do
  begin
    if gbAntiCoag.Visible = True then
      if (rbAntiY.Checked = False) and (rbAntiN.Checked = False) then
        begin
          lbCheck.Items.Add('Anticoagulation^page 7^1');
        end;
    if gbBeta.Visible = True then
      if (rbBetaY.Checked = False) and (rbBetaN.Checked = False) then
        begin
          lbCheck.Items.Add('Beta Blockers^page 7^2');
        end;
    if gbDiab.Visible = True then
      if (rbDiabY.Checked = False) and (rbDiabN.Checked = False) then
        begin
          lbCheck.Items.Add('Diabetes^page 7^3');
        end;
    if gbLatex.Visible = True then
      if (rbLatex1.Checked = False) and (rbLatex2.Checked = False) and (rbLatex3.Checked = False) and (rbLatex4.Checked = False) then
        begin
          lbCheck.Items.Add('Latex Sensitivity^page 7^4');
        end;
    if gbBMI.Visible = True then
      if (edBMI.Text = '') then
        begin
          lbCheck.Items.Add('BMI^page 7^5');
        end;
    if gbSmok.Visible = True then
      if (rbSmok1.Checked = False) and (rbSmok2.Checked = False) and (rbSmok3.Checked = False) then
        begin
          lbCheck.Items.Add('Smoking Status^page 7^6');
        end;
    if gbSC.Visible = True then
      if (rbSCY.Checked = False) and (rbSCN.Checked = False) then
        begin
          lbCheck.Items.Add('Service Connected^page 7^8');
        end;
    if gbAller.Visible = True then
      if (rbAllerY.Checked = False) and (rbAllerN.Checked = False) then
        begin
          lbCheck.Items.Add('Allergies^page 7^9');
        end;
    if gbJoint.Visible = True then
      if (rbJointY.Checked = False) and (rbJointN.Checked = False) then
        begin
          lbCheck.Items.Add('Artificial Joints/Valves^page 7^10');
        end;
  end;
  if lbCheck.Items.Count > 0 then
    begin
      pnlCheck.Visible := True;
      ReqOK := 0;
    end
  else
    begin
      ES     := '';
      vercnt := 0;
      pnlSign.Visible    := True;
      lblNote.Caption    := piece(Title, ':', 2);
      lblProc.Caption    := ProcName;
      edSign.SetFocus;
    end;
end;

procedure TfrmReview.btnCheckClick(Sender: TObject);
begin
  pnlCheck.Visible := False;
end;

procedure TfrmReview.lbCheckClick(Sender: TObject);
var
  node, page, data: string;
  field: integer;
begin
  node  := lbCheck.Items[lbCheck.ItemIndex];
  field := StrToInt(piece(node, '^', 3));
  page  := piece(node, '^', 2);
  if page = 'Home Page' then
    with frmSurgReqMain do
    begin
      Visible := True;
      frmReview.SendToBack;
      cbVisit.Color := clYellow;
    end;
  if page = 'Page 5' then
    with frmConcur do
    begin
      Visible := True;
      BringToFront;
      if field = 1 then
        begin
          rbConcur1.Color := clYellow;
          rbConcur2.Color := clYellow;
          rbConcur3.Color := clYellow;
        end;
      if field = 2 then
        begin
          cbCAtt.Color := clYellow;
          cbCAtt.SetFocus;
        end;
      if field = 3 then
        begin
          rbEval1.Color := clYellow;
          rbEval2.Color := clYellow;
          rbEval3.Color := clYellow;
          rbEval4.Color := clYellow;
        end;
      if field = 4 then
        begin
          cbMEval.Color := clYellow;
          cbMEval.SetFocus;
        end;
      if field = 5 then
        begin
          cbSTask.Color := clYellow;
          cbSTask.SetFocus;
        end;
      if field = 6 then
        begin
          cbCosig.Color := clYellow;
          cbCosig.SetFocus;
        end;
    end;
  if page = 'Page 6' then
    with frmProcedure do
    begin
      Visible := True;
      BringToFront;
      if field = 1 then
        begin
          edProc.Color := clYellow;
          edProc.SetFocus;
        end;
      if field = 2 then
        begin
          cbLat.Color  := clYellow;
          cbLat.SetFocus;
        end;
      if field = 3 then
        begin
          edDiag.Color := clYellow;
          edDiag.SetFocus;
        end;
      if field = 4 then
        begin
          cbComp.Color := clYellow;
          cbComp.SetFocus;
        end;
      if field = 5 then
        begin
          edLen.Color  := clYellow;
          edLen.SetFocus;
        end;
      if field = 6 then
        begin
          cbType.Color := clYellow;
          cbType.SetFocus;
        end;
      if field = 7 then
        begin
          cbStat.Color := clYellow;
          cbStat.SetFocus;
        end;
      if field = 8 then
        begin
          cbDis.Color  := clYellow;
          cbDis.SetFocus;
        end;
      if field = 9 then
        begin
          cbNeed.Color := clYellow;
          cbNeed.SetFocus;
        end;
      if field = 10 then
        begin
          cbEquip.Color := clYellow;
          cbEquip.SetFocus;
        end;
     if field = 11 then
        begin
          cbAtt.Color := clYellow;
          cbAtt.SetFocus;
        end;
     end;
  if page = 'page 7' then
    with frmPatient do
      begin
        Visible := True;
        BringToFront;
        if field = 1 then
          begin
            rbAntiy.Color := clYellow;
            rbAntiN.Color := clYellow;
          end;
        if field = 2 then
          begin
            rbBetaY.Color := clYellow;
            rbBetaN.Color := clYellow;
          end;
        if field = 3 then
          begin
            rbDiabY.Color := clYellow;
            rbDiabN.Color := clYellow;
          end;
        if field = 4 then
          begin
            rbLatex1.Color := clYellow;
            rbLatex2.Color := clYellow;
            rbLatex3.Color := clYellow;
            rbLatex4.Color := clYellow;
          end;
        if field = 5 then
          begin
            edBMI.Color   := clYellow;
            edBMI.SetFocus;
          end;
        if field = 6 then
          begin
            rbSmok1.Color := clYellow;
            rbSmok2.Color := clYellow;
            rbSmok3.Color := clYellow;
            edSmok.Color  := clYellow;
          end;
        if field = 8 then
          begin
            rbSCY.Color := clYellow;
            rbSCN.Color := clYellow;
          end;
        if field = 9 then
          begin
            rbAllerY.Color := clYellow;
            rbAllerN.Color := clYellow;
            edAller.Color  := clYellow;
          end;
        if field = 10 then
          begin
            rbJointY.Color := clYellow;
            rbJointN.Color := clYellow;
          end;
      end;
  if page = 'Page 9' then
    with frmOther do
      begin
        Visible := True;
        pnlProc.Visible := True;
        BringToFront;
        if field = 1 then
          begin
            cbOLat.Color := clYellow;
            OItem := StrToInt(piece(node, '^', 4));
            lbOther.ItemIndex := OItem;
            data  := lbOther.Items[OItem];
            if piece(data, '^', 2) <> '' then
              begin
                cbOther.Text := piece(data, '^', 1);
                ProcIFN      := piece(data, '^', 2);
              end
            else edOProc.Text := piece(data, '^', 1);
            edOLoc.Text := piece(data, '^', 9);
          end;
      end;
end;

procedure TfrmReview.edSignChange(Sender: TObject);
begin
  ES := edSign.Text;
  lblSign1.Visible := False;
end;

procedure TfrmReview.btnSubmitClick(Sender: TObject);
var
  verok, Encrypt, AddNote: string;
begin
  vercnt := vercnt + 1;
  lblSign1.Visible := False;
  verok := sCallV('APTWL VERIFY ES', [ES]);
  if piece(verok, '^', 1) = '0' then
    begin
      lblSign1.Visible := True;
      edSign.Text := '';
      edSign.SetFocus;
      Exit;
    end;
  pnlSign.Visible := False;
  if vercnt = 3 then Exit;
  Encrypt := piece(verok, '^', 2);
  TIFN    := piece(Title, ':', 1);
  VStr    := VLoc + ';' + VDT + ';' + VType;
  frmProcedure.CollectRequestData;
  NoteIFN := sCallV('TIU CREATE RECORD', [Patient.DFN, TIFN, VDT, VLoc, VisitIFN, '', VStr, 1, 1]);
  if piece(NoteIFN, '^', 1) = '0' then
    begin
      MessageDlg('Could not create a new note entry.' + CRLF + piece(NoteIFN, '^', 2), mterror, [mbOK], 0);
      Exit;
    end;
  frmProcedure.lbFinal.Items[26] := NoteIFN;
  SetDocumentText;
  if piece(Success, '^', 1)= '0' then
    begin
      CallV('TIU DELETE RECORD', [NoteIFN, '', 1]);
      Exit;
    end;
  if CosigIFN <> '' then Success := sCallV('APTWL SET COSIGNER', [NoteIFN, CosigIFN]);
  Success := sCallV('TIU SIGN RECORD', [NoteIFN, Encrypt]);
  if piece(Success, '^', 1) <> '0' then
    begin
      MessageDlg(piece(Success, '^', 2), mtwarning, [mbOK], 0);
      CallV('TIU DELETE RECORD', [NoteIFN, '', 1]);
      Exit;
    end;
  Success := sCallV('APTWL PUT SRM DATA TO SCM', [frmProcedure.lbFinal.Items]);
  if piece(Success, '^', 1) = '0' then
    begin
      MessageDlg('Could not create new SCM entry.' + CRLF + piece(Success, '^', 2), mterror, [mbOK], 0);
      CallV('TIU DELETE RECORD', [NoteIFN, '', 1]);
      Exit;
    end;
  AddNote := '';
  if UserID = 165 then AddNote := 'Document: ' + NoteIFN + CRLF + 'Accession: ' + SpecAbbr + ' ' + piece(Success, '^', 2);
  MessageDlg('Request for ' + SpecName + ' Surgery for ' + CRLF + PtName + ' completed successfully.' + CRLF +
    AddNote, mtinformation, [mbOK], 0);
  frmSurgReqMain.cbPat.Text := '';
  Patient.DFN := '';
  PtName      := '';
  frmSurgReqMain.UpdatePatient;
  frmSurgReqMain.DisableMenu;
  frmSurgReqMain.ClearPages;
  frmSurgReqMain.cbPat.SetFocus;
  Close;
end;

procedure TfrmReview.btnCancClick(Sender: TObject);
begin
  pnlSign.Visible := False;
end;

procedure TfrmReview.SetDocumentText;
var
  I: integer;
begin
    with RPCBrokerV do
    begin
      ClearParameters := True;
      RemoteProcedure := 'TIU SET DOCUMENT TEXT';
      Param[0].PType := Literal;
      Param[0].Value := NoteIFN;
      Param[1].PType := List;
      with Param[1] do
        begin
          for I := 0 to memFinal.Lines.Count -1 do
            Mult['"TEXT",' + IntToStr(I+1) + ',0'] := memFinal.Lines[I];
          Mult['"HDR"'] := '1^1';
        end;
      CallBroker;
      Success := Results[0];
      if piece(Success, '^', 1) = '0' then
        begin
          MessageDlg('Could not add text to the note.' + CRLF + piece(Success, '^', 4), mterror, [mbOK], 0);
          Exit;
        end;
    end;
end;

procedure TfrmReview.edSignKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if Key = 13 then btnSubmitClick(Self);
end;

end.
