unit fProcedure;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, ORCtrls, TRPCB, ORFn, ORNet, ComCtrls,
  Buttons, ORDtTm, ShellAPI;

type
  TfrmProcedure = class(TForm)
    pnl1: TPanel;
    lblDiag: TLabel;
    edDiag: TEdit;
    lblBrief: TLabel;
    memBrief: TMemo;
    lblRes: TLabel;
    lblAtt: TLabel;
    lblComp: TLabel;
    lblLen: TLabel;
    edLen: TEdit;
    edOrd: TEdit;
    lblOrd: TLabel;
    lblTyp: TLabel;
    lblStat: TLabel;
    lblDis: TLabel;
    cbRes: TORComboBox;
    cbAtt: TORComboBox;
    cbStat: TORComboBox;
    cbDis: TORComboBox;
    cbType: TORComboBox;
    pnl4: TPanel;
    pnl6: TPanel;
    edProc: TEdit;
    lblFTProc: TLabel;
    cbComp: TORComboBox;
    ORDateTimeDlg1: TORDateTimeDlg;
    lblLat: TLabel;
    cbLat: TORComboBox;
    edLoc: TEdit;
    lblLoc: TLabel;
    lblGComm: TLabel;
    btnNext: TButton;
    lblSpec: TLabel;
    lbSec: TORListBox;
    lbFinal: TORListBox;
    btnPrev: TButton;
    btnCan: TButton;
    tvProc: TORTreeView;
    lbTemp: TORListBox;
    edGComm: TMemo;
    lblPos: TLabel;
    cbPos: TORComboBox;
    pnlNeed: TPanel;
    lblNeed: TLabel;
    cbNeed: TORComboBox;
    lblNeed1: TLabel;
    edNeed: TEdit;
    btnNeed: TButton;
    lblNeed2: TLabel;
    lbNeed: TORListBox;
    btnNDel: TButton;
    pnlEq: TPanel;
    lblEq: TLabel;
    cbEquip: TORComboBox;
    lblEq1: TLabel;
    edEq: TEdit;
    btnEq: TButton;
    lblEq2: TLabel;
    lbEquip: TORListBox;
    btnEDel: TButton;
    lblNum: TLabel;
    pnlAver: TPanel;
    lblIn: TLabel;
    lblIn1: TLabel;
    lblStart: TLabel;
    lblStart1: TLabel;
    lblEnd: TLabel;
    lblEnd1: TLabel;
    lblAver: TLabel;
    lblCol1: TLabel;
    lblCol2: TLabel;
    lblIn2: TLabel;
    lblStart2: TLabel;
    lblEnd2: TLabel;
    lblTot: TLabel;
    lblTot1: TLabel;
    lblTot2: TLabel;
    lblProcA: TLabel;
    btnSec: TPanel;
    pnlMatch: TPanel;
    lblMatch: TLabel;
    lbMatch: TORListBox;
    btnExit: TBitBtn;
    procedure btnCanClick(Sender: TObject);
    procedure cbResChange(Sender: TObject);
    procedure cbAttChange(Sender: TObject);
    procedure CollectRequestData;
    procedure cbLatClick(Sender: TObject);
    procedure cbResClick(Sender: TObject);
    procedure cbAttClick(Sender: TObject);
    procedure cbStatClick(Sender: TObject);
    procedure cbDisClick(Sender: TObject);
    function CheckEdit(): integer;
    procedure cbTypeClick(Sender: TObject);
    procedure cbLatChange(Sender: TObject);
    procedure memFindChange(Sender: TObject);
    procedure edDiagChange(Sender: TObject);
    procedure memBriefChange(Sender: TObject);
    procedure edTimeChange(Sender: TObject);
    procedure edLenChange(Sender: TObject);
    procedure edCompChange(Sender: TObject);
    procedure edOrdChange(Sender: TObject);
    procedure cbTypeChange(Sender: TObject);
    procedure cbStatChange(Sender: TObject);
    procedure cbDisChange(Sender: TObject);
    procedure edNeedChange(Sender: TObject);
    procedure edEqChange(Sender: TObject);
    procedure edProcChange(Sender: TObject);
    procedure edLocChange(Sender: TObject);
    procedure cbCompChange(Sender: TObject);
    procedure cbCompClick(Sender: TObject);
    procedure btnSecClick(Sender: TObject);
    procedure edGCommChange(Sender: TObject);
    procedure cbResKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
    procedure btnPrevClick(Sender: TObject);
    procedure btnNextClick(Sender: TObject);
    procedure SetUpProcTree;
    procedure tvProcChange(Sender: TObject; Node: TTreeNode);
    procedure FormCreate(Sender: TObject);
    procedure cbPosChange(Sender: TObject);
    procedure cbPosClick(Sender: TObject);
    procedure cbNeedClick(Sender: TObject);
    procedure cbEquipClick(Sender: TObject);
    procedure btnNeedClick(Sender: TObject);
    procedure btnEqClick(Sender: TObject);
    procedure lbNeedClick(Sender: TObject);
    procedure lbEquipClick(Sender: TObject);
    procedure btnNDelClick(Sender: TObject);
    procedure btnEDelClick(Sender: TObject);
    procedure NeedToNote;
    procedure EquipToNote;
    procedure edLocExit(Sender: TObject);
    procedure edDiagExit(Sender: TObject);
    procedure edLenExit(Sender: TObject);
    procedure edOrdExit(Sender: TObject);
    procedure edProcExit(Sender: TObject);
    procedure BackToRequired;
    procedure edGCommExit(Sender: TObject);
    procedure memBriefExit(Sender: TObject);
    procedure edProcKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure edDiagKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure edLenKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure edOrdKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure lblTot1Click(Sender: TObject);
    procedure lblTot2Click(Sender: TObject);
    procedure lblStart1Click(Sender: TObject);
    procedure lblStart2Click(Sender: TObject);
    procedure GetAverages;
    procedure lbMatchClick(Sender: TObject);
    procedure btnExitClick(Sender: TObject);
    procedure ClearAverages;
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmProcedure: TfrmProcedure;
  star0, star1, star2, star3, star4, star5, star6, star7, star8,star9, star10: integer;
  star11, star12, star13, star14, star15, MSel: integer;
  LProcIFN, LProcName, LatIFN, PosIFN, ResIFN, AttIFN, CompIFN, TypeIFN, StatIFN, DisIFN, SCIFN: string;
  ProcName, ProcCPT, CPTIFN, ListName, ListType, PatientDFN: string;
  Change, OtChange, wlifn, Edit, Source, seccnt: integer;
  NeedIFN, EqIFN, Proc, PType: string;
  Sec1IFN, Sec2IFN, Sec3IFN, Sec4IFN: string;

implementation

{$R *.dfm}

uses SurgReqMain, uCore, fConsults, fOrder, fOther, fInfo,
     fPatient, fReview, fConcur;

procedure TfrmProcedure.FormCreate(Sender: TObject);
begin
  Change   := 0;
  OtChange := 0;
  seccnt   := 0;  // secondary procedure count
  LProcIFN := '';
  ProcName := '';
  MSel     := 0;
  lblIn1.Caption    := '';
  lblIn2.Caption    := '';
  lblStart1.Caption := '';
  lblStart2.Caption := '';
  lblEnd1.Caption   := '';
  lblEnd2.Caption   := '';
  lblTot1.Caption   := '';
  lblTot2.Caption   := '';
  lbSec.Items.Create;
  if UserSite <> 648 then  // for portland only
    begin
      lblEq.Enabled := False;
      edEq.Enabled  := False;
    end;
  {if (UsePTLD = 0) then
    begin
      //
    end;
  if (UsePtld = 1) then
    begin
      CallV('APTWL GET PROC', []);
      //cbProc.Items := RPCBrokerV.Results;
    end;}
  CallV('APTWL GET LATERALITY', []);
  cbLat.Items := RPCBrokerV.Results;
  CallV('APTWL GET SURG POSITION', []);
  cbPos.Items := RPCBrokerV.Results;
  CallV('APTWL GET COMPLEX', []);
  cbComp.Items := RPCBrokerV.Results;
  CallV('APTWL GET PTSTAT', []);
  cbStat.Items := RPCBrokerV.Results;
  CallV('APTWL GET DISPO', []);
  cbDis.Items := RPCBrokerV.Results;
  CallV('APTWL GET TYPE', []);
  cbType.Items := RPCBrokerV.Results;
  Change := 0;
  lbNeed.Items.Clear;
  lbEquip.Items.Clear;
  if SpecName = 'DERMATOLOGY' then
    begin
      cbType.ItemIndex := 1;  // elective
      cbStat.ItemIndex := 1;  // patient status
      cbDis.ItemIndex  := 6;  // disposition
    end;
  //memBrief.Lines.Add('');
  //memBrief.Lines.Add('');
end;

procedure TfrmProcedure.btnCanClick(Sender: TObject);
begin
  frmProcedure.Visible := False;
  frmProcedure.SendToBack;
  frmSurgReqMain.SetFocus;
end;

procedure TfrmProcedure.cbResChange(Sender: TObject);
begin
  if cbRes.Text <> '' then
    begin
      CallV('APTWL GET PROVIDER', ['S', SpecIFN, cbRes.Text]);
      cbRes.Items := RPCBrokerV.Results;
      cbRes.DroppedDown := True;
    end;
  if (ResIFN <> '') and (cbRes.Text = '') then
    begin
      ResIFN := '';
      frmReview.memNote.Lines[72] := '';
      cbRes.DroppedDown := False;
    end;
  if cbRes.Text = '' then cbRes.DroppedDown := False;
  Change := 1;
end;

procedure TfrmProcedure.cbAttChange(Sender: TObject);
begin
  if cbAtt.Text <> '' then
    begin
      CallV('APTWL GET PROVIDER', ['S', SpecIFN, cbAtt.Text]);
      cbAtt.Items := RPCBrokerV.Results;
      cbAtt.DroppedDown := True;
    end;
  if (AttIFN <> '') and (cbAtt.Text = '') then
    begin
      AttIFN := '';
      frmReview.memNote.Lines[73] := '';
      cbAtt.DroppedDown := False;
    end;
  if cbAtt.Text = '' then cbAtt.DroppedDown := False;
  Change := 1;
end;

procedure TfrmProcedure.CollectRequestData;
var
  I, mcnt: integer;
  Key, data: string;
begin
  if frmConcur.cbCAtt.Text  = '' then CAttIFN := '';
  if frmConcur.cbCosig.Text = '' then CosigIFN := '';
  if cbLat.Text  = '' then LatIFN   := '';
  if cbRes.Text  = '' then ResIFN   := '';
  if cbAtt.Text  = '' then AttIFN   := '';
  if cbComp.Text = '' then CompIFN  := '';
  if cbType.Text = '' then TypeIFN  := '';
  if cbStat.Text = '' then StatIFN  := '';
  if cbDis.Text  = '' then DisIFN   := '';
  lbFinal.Clear;
  for I := 0 to 63 do lbFinal.Items.Add('');
  lbFinal.Items[1]  := Patient.DFN + '^' + Patient.Name + '^' + Patient.SSN;
  lbFinal.Items[2]  := piece(Address, '^', 1);
  lbFinal.Items[3]  := piece(Address, '^', 4);
  lbFinal.Items[4]  := piece(Address, '^', 5);
  lbFinal.Items[5]  := piece(Address, '^', 6);
  lbFinal.Items[6]  := piece(Address, '^', 7);
  lbFinal.Items[7]  := LatIFN;
  lbFinal.Items[9]  := edDiag.Text;
  for I := 0 to memBrief.Lines.Count -1 do
    begin
      lbFinal.Items[10]  := lbFinal.Items[10] + memBrief.Lines[I] + ' ';
    end;
  lbFinal.Items[11] := ResIFN;
  lbFinal.Items[12] := AttIFN;
  lbFinal.Items[14] := edLen.Text;
  lbFinal.Items[15] := CompIFN;
  lbFinal.Items[16] := edOrd.Text;
  lbFinal.Items[17] := TypeIFN;
  lbFinal.Items[18] := StatIFN;
  lbFinal.Items[19] := DisIFN;
  for I := 0 to lbNeed.Items.Count -1 do
    begin
      data := piece(lbNeed.Items[I], '^', 2);
      if I = 0 then lbFinal.Items[20] := lbFinal.Items[20] + data
      else lbFinal.Items[20] := lbFinal.Items[20] + ', ' + data;
    end;
  for I := 0 to lbEquip.Items.Count -1 do
    begin
      data := piece(lbEquip.Items[I], '^', 2);
      if I = 0 then lbFinal.Items[21] := lbFinal.Items[21] + data
      else lbFinal.Items[21] := lbFinal.Items[21] + ', ' + data;
    end;
  if LProcIFN = '' then Key := '0'
  else Key := '1';
  lbFinal.Items[22] := LProcIFN + '^' + ProcName + '^^^' + Key;
  lbFinal.Items[23] := IntToStr(SpecIFN);
  lbFinal.Items[27] := '13'; // SCM STATUS = NOTE REQUEST
  mcnt := 0;
  for I := 0 to frmConcur.lbMEval.Items.Count -1 do
    begin
      mcnt := mcnt + 1;
      lbFinal.Items[33 + mcnt] := frmConcur.lbMEval.Items[I];
    end;
  mcnt := 0;
  for I := 0 to frmConcur.lbSTask.Items.Count -1 do
    begin
      mcnt := mcnt + 1;
      lbFinal.Items[37 + mcnt] := frmConcur.lbSTask.Items[I];
    end;
  lbFinal.Items[42] := PosIFN;
  mcnt := 0;
  for I := 0 to lbSec.Items.Count -1 do
    begin
      mcnt := mcnt + 1;
      lbFinal.Items[42 + mcnt] := lbSec.Items[I];
    end;
  for I := 0 to edGComm.Lines.Count -1 do
    begin
      lbFinal.Items[49]  := lbFinal.Items[49] + edGComm.Lines[I] + '^';
    end;
  lbFinal.Items[50] := edLoc.Text;
  lbFinal.Items[51] := SConn;
  lbFinal.Items[52] := Concur + '^' + CAttIFN + '^' + CosigIFN;
  lbFinal.Items[53] := AntiC;
  lbFinal.Items[54] := Beta;
  lbFinal.Items[55] := Diab;
  lbFinal.Items[56] := Latex;
  lbFinal.Items[57] := BMI;
  lbFinal.Items[58] := Smok + '^' + frmPatient.edSmok.Text;
  lbFinal.Items[59] := Leg;
  lbFinal.Items[60] := '2'; // SRM entry method
  lbFinal.Items[61] := MedEval;
  lbFinal.Items[62] := Aller;
  lbFinal.Items[63] := Joint;
end;

procedure TfrmProcedure.cbLatClick(Sender: TObject);
begin
  LatIFN := IntToStr(cbLat.ItemIEN);
  frmReview.memNote.Lines[32] := '    LATERALITY: ' + cbLat.Text;
  if cbLat.Color = clYellow then
    begin
      cbLat.Color := clWindow;
      cbLat.DroppedDown := False;
      BackToRequired;
    end;
end;

procedure TfrmProcedure.cbResClick(Sender: TObject);
begin
  ResIFN := IntToStr(cbRes.ItemIEN);
  cbRes.Color := clWindow;
  frmReview.memNote.Lines[72] := '    Resident Surgeon: ' + cbRes.Text;
end;

procedure TfrmProcedure.cbAttClick(Sender: TObject);
var
  PType, Data, Proc: string;
begin
  AttIFN := IntToStr(cbAtt.ItemIEN);
  cbAtt.Color := clWindow;
  frmReview.memNote.Lines[73] := '    Attending Surgeon: ' + cbAtt.Text;
  if edProc.Text <> '' then GetAverages;
end;

procedure TfrmProcedure.cbStatClick(Sender: TObject);
begin
  StatIFN := IntToStr(cbStat.ItemIEN);
  frmReview.memNote.Lines[79] := '    Patient Status: ' + cbStat.Text;
  if cbStat.Color = clYellow then
    begin
      cbStat.Color := clWindow;
      cbStat.DroppedDown := False;
      BackToRequired;
    end;
end;

procedure TfrmProcedure.cbDisClick(Sender: TObject);
begin
  DisIFN := IntToStr(cbDis.ItemIEN);
  frmReview.memNote.Lines[80] := '    PostOp Disposition: ' + cbDis.Text;
  if cbDis.Color = clYellow then
    begin
      cbDis.Color := clWindow;
      cbDis.DroppedDown := False;
      BackToRequired;
    end;
end;

function TfrmProcedure.CheckEdit(): integer;
begin
  Result := 1;
end;

procedure TfrmProcedure.cbTypeClick(Sender: TObject);
begin
  TypeIFN := cbType.ItemID;
  frmReview.memNote.Lines[78] := '    Case Type: ' + cbType.Text;
  if cbType.Color = clYellow then
    begin
      cbType.Color := clWindow;
      cbType.DroppedDown := False;
      BackToRequired;
    end;
end;

procedure TfrmProcedure.cbLatChange(Sender: TObject);
begin
  Change := 1;
  if (LatIFN <> '') and (cbLat.Text = '') then
    begin
      LatIFN := '';
      frmReview.memNote.Lines[32] := '';
    end;
end;

procedure TfrmProcedure.memFindChange(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmProcedure.edDiagChange(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmProcedure.memBriefChange(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmProcedure.edTimeChange(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmProcedure.edLenChange(Sender: TObject);
begin
  Change := 1;
  edLen.Color := clWindow;
end;

procedure TfrmProcedure.edCompChange(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmProcedure.edOrdChange(Sender: TObject);
begin
  Change := 1;
  edOrd.Color := clWindow;
end;

procedure TfrmProcedure.cbTypeChange(Sender: TObject);
begin
  Change := 1;
   if (TypeIFN <> '') and (cbType.Text = '') then
    begin
      TypeIFN := '';
      frmReview.memNote.Lines[78] := '';
    end;
end;

procedure TfrmProcedure.cbStatChange(Sender: TObject);
begin
  Change := 1;
  if (StatIFN <> '') and (cbStat.Text = '') then
    begin
      StatIFN := '';
      frmReview.memNote.Lines[79] := '';
    end;
end;

procedure TfrmProcedure.cbDisChange(Sender: TObject);
begin
  Change := 1;
  if (DisIFN <> '') and (cbDis.Text = '') then
    begin
      DisIFN := '';
      frmReview.memNote.Lines[80] := '';
    end;
end;

procedure TfrmProcedure.edNeedChange(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmProcedure.edEqChange(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmProcedure.cbCompChange(Sender: TObject);
begin
  Change := 1;
  if (CompIFN <> '') and (cbComp.Text = '') then
    begin
      CompIFN := '';
      frmReview.memNote.Lines[75] := '';
    end;
end;

procedure TfrmProcedure.cbCompClick(Sender: TObject);
begin
  CompIFN := IntToStr(cbComp.ItemIEN);
  frmReview.memNote.Lines[75] := '    Case Complexity: ' + cbComp.Text;
  if cbComp.Color = clYellow then
    begin
      cbComp.Color := clWindow;
      cbComp.DroppedDown := False;
      BackToRequired;
    end;
end;

procedure TfrmProcedure.edProcChange(Sender: TObject);
begin
  if edProc.Text = '' then
    begin
      pnlMatch.Visible := False;
      MSel := 0;
      ClearAverages;
      Exit;
    end;
  Change := 1;
  if length(edProc.Text) < 10 then LProcIFN := '';  // reset
  if (length(edProc.Text) > 4) and (MSel = 0) then
    begin
      CallV('APTWL GET PROC MATCHES', [SpecIFN, edProc.Text]);
      lbMatch.Items := RPCBrokerV.Results;
      if lbMatch.Items.Count > 0 then
        begin
          pnlMatch.Visible := True;
        end;
    end;
  if (length(edProc.Text) > 10) and (cbAtt.Text <> '') then
    begin
      GetAverages;
      MSel := 0;
    end;
end;

procedure TfrmProcedure.btnSecClick(Sender: TObject);
var
  I: integer;
begin
  frmProcedure.Visible := False;
  frmProcedure.SendToBack;
  frmOther.Visible := True;
  frmOther.BringToFront;
  begin
    if lbSec.Items.Count >0 then
      begin
        btnSec.Color      := clRed;
        btnSec.Font.Color := clWhite;
        for I := 0 to lbSec.Items.Count-1 do frmOther.lbOther.Items.Add(lbSec.Items[I]);
      end
    else
      begin
        btnSec.Font.Color := clWindowText;
        btnSec.Color      := clBtnFace;
      end;
    if OtherChange = 1 then
      begin
        Change   := 1;
        OtChange := 1;
      end;
  end;
end;

procedure TfrmProcedure.cbResKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if Key = 8 then
    begin
      if cbRes.Text = '' then
        begin
          ResIFN := '';
        end;
    end;
end;

procedure TfrmProcedure.edGCommChange(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmProcedure.edLocChange(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmProcedure.btnPrevClick(Sender: TObject);
begin
  frmProcedure.Visible := False;
  frmProcedure.SendToBack;
  frmConcur.Visible := True;
  frmConcur.BringToFront;
  frmConcur.SetFocus;
end;

procedure TfrmProcedure.btnNextClick(Sender: TObject);
begin
  frmProcedure.Visible := False;
  frmProcedure.SendToBack;
  frmPatient.Visible := True;
  frmPatient.BringToFront;
end;

procedure TfrmProcedure.SetUpProcTree;
var
  I: integer;
  PTreeNode1, PTreeNode2, PTreeNode3, PTreeNode4, PTreeNode5, tmpNode: TTreeNode;
  data, lev1nm, lev2nm, lev3nm, lev4nm, lev5nm: string;
  last1, last2, last3, last4, last5: string;
begin
  with frmProcedure do
    begin
      tvProc.Items.Clear;
      lev1nm  := '';
      lev2nm  := '';
      lev3nm  := '';
      lev4nm  := '';
      lev5nm  := '';
      for I := 0 to lbTemp.Items.Count -1 do
        begin
          data := lbTemp.Items[I];
          lev1nm := piece(data, '^', 1);
          lev2nm := piece(data, '^', 2);
          lev3nm := piece(data, '^', 3);
          lev4nm := piece(data, '^', 4);
          lev5nm := piece(data, '^', 5);
          if I = 0 then
            begin
              PTreeNode1 := tvProc.Items.Add(nil, lev1nm);
              TORTreeNode(PTreeNode1).StringData := lev1nm;
              last1 := lev1nm;
            end;
          if I > 0 then
            begin
              if (lev1nm <> '') and (lev1nm <> last1) then
                begin
                  tmpNode := tvProc.Items.Add(PTreeNode1, lev1nm);
                  TORTreeNode(tmpNode).StringData := lev1nm;
                  last1   := lev1nm;
                  PTreeNode1 := tmpNode;
                end;
              if (lev2nm <> '') and (lev2nm <> last2) then
                begin
                  tmpNode := tvProc.Items.AddChild(PTreeNode1, lev2nm);
                  TORTreeNode(tmpNode).StringData := lev2nm;
                  last2   := lev2nm;
                  PTreeNode2 := tmpNode;
                end;
              if (lev3nm <> '') and (lev3nm <> last3) then
                begin
                  tmpNode := tvProc.Items.AddChild(PTreeNode2, lev3nm);
                  TORTreeNode(tmpNode).StringData := lev3nm;
                  last3   := lev3nm;
                  PTreeNode3 := tmpNode;
                end;
              if (lev4nm <> '') and (lev4nm <> last4) then
                 begin
                  tmpNode := tvProc.Items.AddChild(PTreeNode3, lev4nm);
                  TORTreeNode(tmpNode).StringData := lev4nm;
                  last4   := lev4nm;
                  PTreeNode4 := tmpNode;
                end;
              if (lev5nm <> '') and (lev5nm <> last5) then
                 begin
                  tmpNode := tvProc.Items.AddChild(PTreeNode4, lev5nm);
                  TORTreeNode(tmpNode).StringData := lev5nm;
                  last5   := lev5nm;
                  PTreeNode5 := tmpNode;
                end;
            end;
        end;
    end;
end;

procedure TfrmProcedure.tvProcChange(Sender: TObject; Node: TTreeNode);
var
  SelNode, Proc, Key: string;
begin
  with tvProc do
    begin
      SelNode := TORTreeNode(Selected).StringData;
      if piece(SelNode, ':', 1) = '' then Exit;
      if piece(SelNode, ':', 1) = 'P' then
        begin
          if edProc.Text <> '' then
            begin
              if MessageDlg('Is this going to be a secondary procedure?', mtInformation, [mbYes, mbNo], 0) = mrYes then
                begin
                  seccnt   := seccnt + 1;
                  Key      := '0';
                  ProcName := piece(SelNode, ':', 2);
                  LProcIFN := piece(SelNode, ':', 3);
                  if LProcIFN <> '' then Key := '1';
                  lbSec.Items.Add(ProcName + '^' + LProcIFN + '^^^^^' + Key);
                  frmReview.memNote.Lines[37 + (seccnt * 2)] := ProcName;
                  btnSec.Color := clRed;
                  Exit;
                end;
            end;
          LProcIFN    := piece(SelNode, ':', 3);
          MSel := 1;
          edProc.Text := piece(SelNode, ':', 2);
          ProcName    := edProc.Text;
          frmReview.memNote.Lines[31] := '    PROCEDURE: ' + ProcName;
        end;
      if piece(SelNode, ':', 1) = 'D' then
        begin
          edDiag.Text := piece(SelNode, ':', 2);
          frmReview.memNote.Lines[33] := '    DIAGNOSIS: ' + edDiag.Text;
        end;
      if piece(SelNode, ':', 1) = 'S' then
        begin
          memBrief.Lines.Add(piece(SelNode, ':', 2));
          frmReview.memNote.Lines[34] := '    BRIEF HX: ' + piece(SelNode, ':', 2);
        end;
    end;
end;

procedure TfrmProcedure.cbPosChange(Sender: TObject);
begin
  Change := 1;
  if cbPos.Text <> '' then
    begin
      CallV('APTWL GET SURG POSITION', [cbPos.Text]);
      cbPos.Items := RPCBrokerV.Results;
      cbPos.DroppedDown := True;
    end;
  if (PosIFN <> '') and (cbPos.Text = '') then
    begin
      PosIFN := '';
      frmReview.memNote.Lines[77] := '';
      cbPos.DroppedDown := False;
    end;
  if cbPos.Text = '' then cbPos.DroppedDown := False;
end;

procedure TfrmProcedure.cbPosClick(Sender: TObject);
begin
  PosIFN := IntToStr(cbPos.ItemIEN);
  cbPos.Color := clWindow;
  frmReview.memNote.Lines[77] := '    Position: ' + cbPos.Text;
end;

procedure TfrmProcedure.cbNeedClick(Sender: TObject);
begin
  NeedIFN := IntToStr(cbNeed.ItemIEN);
  if cbNeed.Text = 'Other' then
    begin
      lblNeed1.Visible := True;
      edNeed.Visible   := True;
      btnNeed.Visible  := True;
      edNeed.SetFocus;
      Exit;
    end
  else lbNeed.Items.Add(NeedIFN + '^' + cbNeed.Text);
  NeedToNote;
  cbNeed.Text := '';
  if cbNeed.Color = clYellow then
    begin
      cbNeed.Color := clWindow;
      cbNeed.DroppedDown := False;
      BackToRequired;
    end;
end;

procedure TfrmProcedure.cbEquipClick(Sender: TObject);
begin
  EqIFN := IntToStr(cbEquip.ItemIEN);
  if cbEquip.Text = 'Other' then
    begin
      lblEq1.Visible := True;
      edEq.Visible   := True;
      btnEq.Visible  := True;
      edEq.SetFocus;
      Exit;
    end
  else lbEquip.Items.Add(EqIFN + '^' + cbEquip.Text);
  EquipToNote;
  cbEquip.Text := '';
  if cbEquip.Color = clYellow then
    begin
      cbEquip.Color := clWindow;
      cbEquip.DroppedDown := False;
      BackToRequired;
    end;
end;

procedure TfrmProcedure.btnNeedClick(Sender: TObject);
begin
  if edNeed.Text = '' then Exit;
  lbNeed.Items.Add(NeedIFN + '^' + edNeed.Text);
  NeedToNote;
  edNeed.Text := '';
  cbNeed.Text := '';
end;

procedure TfrmProcedure.btnEqClick(Sender: TObject);
begin
  if edEq.Text = '' then Exit;
  lbEquip.Items.Add(EqIFN + '^' + edEq.Text);
  EquipToNote;
  edEq.Text := '';
  cbEquip.Text := '';
end;

procedure TfrmProcedure.lbNeedClick(Sender: TObject);
begin
  btnNDel.Enabled := True;
end;

procedure TfrmProcedure.lbEquipClick(Sender: TObject);
begin
  btnEDel.Enabled := True;
end;

procedure TfrmProcedure.btnNDelClick(Sender: TObject);
begin
  lbNeed.Items.Delete(lbNeed.ItemINdex);
  NeedToNote;
end;

procedure TfrmProcedure.btnEDelClick(Sender: TObject);
begin
  lbEquip.Items.Delete(lbEquip.ItemIndex);
  EquipToNote;
end;

procedure TfrmProcedure.NeedToNote;
var
  J: integer;
begin
  for J := 0 to lbNeed.Items.Count -1 do
    begin
      if J = 0 then frmReview.memNote.Lines[86] := '    Intraop Needs: ' + piece(lbNeed.Items[J], '^', 2)
      else frmReview.memNote.Lines[86] := frmReview.memNote.Lines[86] + ', ' + piece(lbNeed.Items[J], '^', 2);
    end;
end;

procedure TfrmProcedure.EquipToNote;
var
  J: integer;
  header: string;
begin
  if SpecName = 'CARDIO/THORACIC' then header := 'Positioning Aide: '
  else header := 'Special Equipment: ';
  for J := 0 to lbEquip.Items.Count -1 do
    begin
      if J = 0 then frmReview.memNote.Lines[87] := '    ' + header + piece(lbEquip.Items[J], '^', 2)
      else frmReview.memNote.Lines[87] := frmReview.memNote.Lines[87] + ', ' + piece(lbEquip.Items[J], '^', 2);
    end;
end;

procedure TfrmProcedure.edLocExit(Sender: TObject);
begin
  frmReview.memNote.Lines[32] := frmReview.memNote.Lines[32] + '   ' + edLoc.Text;
end;

procedure TfrmProcedure.edDiagExit(Sender: TObject);
begin
  frmReview.memNote.Lines[33] := '    DIAGNOSIS: ' + edDiag.Text;
end;

procedure TfrmProcedure.edLenExit(Sender: TObject);
begin
  frmReview.memNote.Lines[76] := '    Estimated Case Length: ' + edLen.Text;
end;

procedure TfrmProcedure.edOrdExit(Sender: TObject);
begin
  frmReview.memNote.Lines[74] := '    Case Order: ' + edOrd.Text;
end;

procedure TfrmProcedure.edProcExit(Sender: TObject);
begin
  if edProc.Color <> clYellow then Exit;
  ProcName := edProc.Text;
  frmReview.memNote.Lines[31] := '    PROCEDURE: ' + ProcName;
  if pnlMatch.Visible = True then pnlMatch.Visible := False;
  //if (edProc.Text <> '') and (cbAtt.Text <> '') then GetAverages;
end;

procedure TfrmProcedure.BackToRequired;
begin
  frmReview.ConvertNote;
  frmProcedure.Visible := False;
  frmProcedure.SendToBack;
  frmReview.SetFocus;
  frmReview.CheckRequiredFields;
end;

procedure TfrmProcedure.edGCommExit(Sender: TObject);
var
  L: integer;
begin
  frmReview.memNote.Lines[81] := '';
  frmReview.memNote.Lines[82] := '';
  if edGComm.Lines.Count > 0 then
    begin
      for L := 0 to edGComm.Lines.Count -1 do
        begin
          if L = 0 then frmReview.memNote.Lines[81] := '    Scheduling Comments: ' + edGComm.Lines[L];
          if L = 1 then frmReview.memNote.Lines[82] := '                                          ' + edGComm.Lines[L];
        end;
    end;
end;

procedure TfrmProcedure.memBriefExit(Sender: TObject);
var
  L: integer;
begin
  frmReview.memNote.Lines[34] := '';
  frmReview.memNote.Lines[35] := '';
  if memBrief.Lines.Count > 0 then
    begin
      for L := 0 to memBrief.Lines.Count -1 do
        begin
          if L = 0 then frmReview.memNote.Lines[34] := '    BRIEF CLINICAL HX: ' + memBrief.Lines[0];
          if L = 1 then frmReview.memNote.Lines[35] := '                                        ' + memBrief.Lines[1];
        end;
    end;
end;

procedure TfrmProcedure.edProcKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if Key = 13 then
    begin
      ProcName := edProc.Text;
      frmReview.memNote.Lines[31] := '    PROCEDURE: ' + ProcName;
      pnlMatch.Visible := False;
      BackToRequired;
    end;
end;

procedure TfrmProcedure.edDiagKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if Key = 13 then
    begin
      frmReview.memNote.Lines[33] := '    DIAGNOSIS: ' + edDiag.Text;
      BackToRequired;
    end;
end;

procedure TfrmProcedure.edLenKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if key = 13 then
    begin
      frmReview.memNote.Lines[76] := '    Estimated Case Length: ' + edLen.Text;
      BackToRequired;
    end;
end;

procedure TfrmProcedure.edOrdKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if key = 13 then
    begin
      frmReview.memNote.Lines[74] := '    Case Order: ' + edOrd.Text;
      BackToRequired;
    end;
end;

procedure TfrmProcedure.lblTot1Click(Sender: TObject);
begin
  edLen.Text := piece(lblTot1.Caption, ' ', 1);
end;

procedure TfrmProcedure.lblTot2Click(Sender: TObject);
begin
  edLen.Text := piece(lblTot2.Caption, ' ', 1);
end;

procedure TfrmProcedure.lblStart1Click(Sender: TObject);
begin
  edLen.Text := piece(lblStart1.Caption, ' ', 1);
end;

procedure TfrmProcedure.lblStart2Click(Sender: TObject);
begin
  edLen.Text := piece(lblStart2.Caption, ' ', 1);
end;

procedure TfrmProcedure.GetAverages;
var
  Data: string;
begin
  if LProcIFN <> '' then
    begin
      PType := 'LP';
      Proc  := LProcIFN;
    end
  else
    begin
      PType := 'FT';
      Proc  := ProcName;
    end;
  Data := sCallV('APTWL GET AVER', [SpecIFN, AttIFN, Proc, PType]);
  lblIn1.Caption    := piece(Data, '^', 3);
  lblIn2.Caption    := piece(Data, '^', 7);
  lblStart1.Caption := piece(Data, '^', 2);
  lblStart2.Caption := piece(Data, '^', 6);
  lblEnd1.Caption   := piece(Data, '^', 4);
  lblEnd2.Caption   := piece(Data, '^', 8);
  lblTot1.Caption   := piece(Data, '^', 1);
  lblTot2.Caption   := piece(Data, '^', 5);
  lblCol2.Caption   := piece(cbAtt.Text, ',', 1);
  lblCol1.Caption   := SpecName;
  lblProcA.Caption  := edProc.Text;
  if (PType = 'FT') and (lblTot1.Caption <> 'No Data') then lblProca.Caption := piece(Data, '^', 9); // compiled free text procedure name
  if lblTot2.Caption <> 'No Data' then edLen.Text := piece(lblTot2.Caption, ' ', 1) // default time
  else if lblTot1.Caption <> 'No Data' then edLen.Text := piece(lblTot1.Caption, ' ', 1);
end;

procedure TfrmProcedure.lbMatchClick(Sender: TObject);
begin
  MSel := 1;
  LProcIFN    := piece(lbMatch.Items[lbMatch.ItemIndex], '^', 1);
  ProcName    := piece(lbMatch.Items[lbMatch.ItemIndex], '^', 2);
  edProc.Text := ProcName;
  frmReview.memNote.Lines[31] := '    PROCEDURE: ' + ProcName;
  pnlMatch.Visible := False;
end;

procedure TfrmProcedure.btnExitClick(Sender: TObject);
var
  AFile, Param: string;
begin
  pnlMatch.Visible := False;
  {AFile := 'C:\Program FileS\Vista\SurgCaseMan\SurgCaseMan.exe';
  Param := 'S=ECP-POR.V00.domain.ext P=00000';
  ShellExecute(Handle, 'open', PChar(AFile), PChar(''), '', SW_NORMAL); }
end;

procedure TfrmProcedure.ClearAverages;
begin
  lblIn1.Caption    := '';
  lblIn2.Caption    := '';
  lblStart1.Caption := '';
  lblStart2.Caption := '';
  lblEnd1.Caption   := '';
  lblEnd2.Caption   := '';
  lblTot1.Caption   := '';
  lblTot2.Caption   := '';
  lblCol2.Caption   := 'Attending';
  lblCol1.Caption   := 'Specialty';
  lblProcA.Caption  := 'Procedure';
  edLen.Text        := '';
  LProcIFN          := '';
end;

end.
