unit fPatient;
// ptld/jit  6-4-08

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ORNet, ORFn, StdCtrls, ExtCtrls, ORCtrls;

type
  TfrmPatient = class(TForm)
    btnPrevious: TButton;
    btnNext: TButton;
    btnExit: TButton;
    lblSpec: TLabel;
    gbAntiCoag: TGroupBox;
    lblAnti: TLabel;
    gbBeta: TGroupBox;
    lblBeta: TLabel;
    lblBeta1: TLabel;
    gbDiab: TGroupBox;
    lblDiab: TLabel;
    gbLatex: TGroupBox;
    gbBMI: TGroupBox;
    lblBMI: TLabel;
    edBMI: TEdit;
    gbSmok: TGroupBox;
    lblSmok: TLabel;
    edSmok: TEdit;
    gbLeg: TGroupBox;
    lblLeg: TLabel;
    gbSC: TGroupBox;
    gbAller: TGroupBox;
    rbAntiY: TRadioButton;
    rbAntiN: TRadioButton;
    rbBetaY: TRadioButton;
    rbBetaN: TRadioButton;
    rbDiabY: TRadioButton;
    rbDiabN: TRadioButton;
    rbLatex1: TRadioButton;
    rbLatex2: TRadioButton;
    rbLatex3: TRadioButton;
    rbLatex4: TRadioButton;
    rbSmok1: TRadioButton;
    rbSmok2: TRadioButton;
    rbSmok3: TRadioButton;
    rbLegY: TRadioButton;
    rbLegN: TRadioButton;
    lblSC: TLabel;
    lblSC1: TLabel;
    rbSCY: TRadioButton;
    rbSCN: TRadioButton;
    lblNVA: TLabel;
    edNVA: TEdit;
    lbBetaTemp: TORListBox;
    lbSCTemp: TORListBox;
    lblNum: TLabel;
    lblAller: TLabel;
    rbAllerY: TRadioButton;
    rbAllerN: TRadioButton;
    lblDet: TLabel;
    edAller: TEdit;
    gbJoint: TGroupBox;
    gb2: TGroupBox;
    gb3: TGroupBox;
    lblJoint: TLabel;
    rbJointY: TRadioButton;
    rbJointN: TRadioButton;
    lbAllerTemp: TORListBox;
    memCoag: TMemo;
    memDiab: TMemo;
    memBMI: TMemo;
    memSC: TMemo;
    memBeta: TMemo;
    memLatex: TMemo;
    memAller: TMemo;
    procedure btnPreviousClick(Sender: TObject);
    procedure btnNextClick(Sender: TObject);
    procedure btnExitClick(Sender: TObject);
    procedure CollectPtData;
    procedure rbAntiYClick(Sender: TObject);
    procedure rbAntiNClick(Sender: TObject);
    procedure rbBetaYClick(Sender: TObject);
    procedure rbBetaNClick(Sender: TObject);
    procedure rbDiabYClick(Sender: TObject);
    procedure rbDiabNClick(Sender: TObject);
    procedure rbLatex1Click(Sender: TObject);
    procedure rbLatex2Click(Sender: TObject);
    procedure rbLatex3Click(Sender: TObject);
    procedure rbLatex4Click(Sender: TObject);
    procedure edBMIChange(Sender: TObject);
    procedure rbSmok1Click(Sender: TObject);
    procedure rbSmok2Click(Sender: TObject);
    procedure rbSmok3Click(Sender: TObject);
    procedure edSmokChange(Sender: TObject);
    procedure rbLegYClick(Sender: TObject);
    procedure rbLegNClick(Sender: TObject);
    procedure rbSCYClick(Sender: TObject);
    procedure rbSCNClick(Sender: TObject);
    procedure GetSC;
    procedure GetINR;
    procedure GetBeta;
    procedure GetA1C;
    procedure GetLat;
    procedure GetBMI;
    procedure FormCreate(Sender: TObject);
    procedure SetUpQuestions;
    procedure edNVAChange(Sender: TObject);
    procedure ResetColor1;
    procedure ResetColor2;
    procedure ResetColor3;
    procedure ResetColor4;
    procedure ResetColor6;
    procedure ResetColor8;
    procedure BackToRequired;
    procedure edBMIKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure edSmokKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure rbAllerYClick(Sender: TObject);
    procedure rbAllerNClick(Sender: TObject);
    procedure rbJointYClick(Sender: TObject);
    procedure rbJointNClick(Sender: TObject);
    procedure ResetColor9;
    procedure ResetColor10;
    procedure GetAller;
    procedure edAllerChange(Sender: TObject);
    procedure edAllerKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure edNVAKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure RequiredFields;
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmPatient: TfrmPatient;
  Param, PtData: string;

implementation

{$R *.dfm}

uses SurgReqMain, fProcedure, fReview, uCore, fConcur;

procedure TfrmPatient.FormCreate(Sender: TObject);
begin
  //
end;

procedure TfrmPatient.btnPreviousClick(Sender: TObject);
begin
  frmPatient.Visible := False;
  frmPatient.SendToBack;
  frmProcedure.Visible := True;
  frmProcedure.BringToFront;
  frmProcedure.SetFocus;
end;

procedure TfrmPatient.btnNextClick(Sender: TObject);
begin
  frmPatient.Visible := False;
  frmPatient.SendToBack;
  frmReview.Visible  := True;
  frmReview.BringToFront;
  frmReview.ConvertNote;
end;

procedure TfrmPatient.btnExitClick(Sender: TObject);
begin
  frmPatient.Visible := False;
  frmPatient.SendToBack;
  frmSurgReqMain.SetFocus;
end;

procedure TfrmPatient.CollectPtData;
begin
  PtData := '';
  if (piece(Param, '^', 1) = '1') and (rbAntiY.Checked = True) then  SetPiece(PtData, '^', 1, '1');
  if (piece(Param, '^', 2) = '1') and (rbBetaY.Checked = True) then  SetPiece(PtData, '^', 2, '1');
  if (piece(Param, '^', 3) = '1') and (rbDiabY.Checked = True) then  SetPiece(PtData, '^', 3, '1');
  if piece(Param, '^', 4) = '1' then
    begin
     if rbLatex1.Checked = True then  SetPiece(PtData, '^', 4, '1');
     if rbLatex2.Checked = True then  SetPiece(PtData, '^', 4, '2');
     if rbLatex3.Checked = True then  SetPiece(PtData, '^', 4, '3');
     if rbLatex4.Checked = True then  SetPiece(PtData, '^', 4, '4');
    end;
  if piece(Param, '^', 5) = '1' then  SetPiece(PtData, '^', 5, edBMI.Text);
  if piece(Param, '^', 6) = '1' then
    begin
      if rbSmok1.Checked = True then  SetPiece(PtData, '^', 6, '1');
      if rbSmok2.Checked = True then  SetPiece(PtData, '^', 6, '2');
      if rbSmok3.Checked = True then  SetPiece(PtData, '^', 6, '3:' + edSmok.Text);
    end;
  if (piece(Param, '^', 7) = '1') and (rbLegY.Checked = True) then SetPiece(PtData, '^', 7, '1');
  if (piece(Param, '^', 8) = '1') and (rbSCY.Checked = True) then SetPiece(PtData, '^', 8, '1');
  if (piece(Param, '^', 9) = '1') and (rbAllerY.Checked = True) then SetPiece(PtData, '^', 9, '1');
  if (piece(Param, '^', 10) = '1') and (rbJointY.Checked = True) then SetPiece(PtData, '^', 10, '1');
  //if (piece(Param, '^', 11) = '1') and (??? = True then SetPiece(PtData, '^', 11, '1');
  //if (piece(Param, '^', 12) = '1') and (??? = True then SetPiece(PtData, '^', 12, '1');
end;

procedure TfrmPatient.rbAntiYClick(Sender: TObject);
begin
  SetPiece(SRisk, '^', 1, '1');
  frmReview.memNote.Lines[50] := '    Patient is taking Coumadin';
  AntiC := '1';
  if rbAntiY.Color = clYellow then
    begin
      ResetColor1;
      BackToRequired;
    end;
end;

procedure TfrmPatient.rbAntiNClick(Sender: TObject);
begin
  SetPiece(SRisk, '^', 1, '0');
  frmReview.memNote.Lines[50] := '    Patient is not taking Coumadin';
  AntiC := '0';
  if rbAntiN.Color = clYellow then
    begin
      ResetColor1;
      BackToRequired;
    end;
end;

procedure TfrmPatient.rbBetaYClick(Sender: TObject);
var
  dcnt, J, line: integer;
begin
  SetPiece(SRisk, '^', 2, '1');
  frmReview.memNote.Lines[51] := '    Patient is on beta blocker medication';
  Beta := '1';
  if lbBetaTemp.Items.Count = 0 then  // double check
    begin
      CallV('APTWL GET SR OBJECT DATA', [2, Patient.DFN]);
      lbBetaTemp.Items := RPCBrokerV.Results;
    end;
  line := 51;
  dcnt := 0;
  if lbBetaTemp.Items.Count >0 then
    begin
      for J := 0 to lbBetaTemp.Items.Count -1 do
        begin
          dcnt := dcnt + 1;
          if dcnt > 4 then break;
          frmReview.memNote.Lines[line + dcnt] := '        ' + lbBetaTemp.Items[J];
        end;
    end;
  if edNVA.Text <> '' then frmReview.memNote.Lines[57] := '        Non-VA Meds: ' + edNVA.Text;
  if rbBetaY.Color = clYellow then
    begin
      ResetColor2;
      BackToRequired;
    end;
end;

procedure TfrmPatient.rbBetaNClick(Sender: TObject);
begin
  SetPiece(SRisk, '^', 2, '0');
  frmReview.memNote.Lines[51] := '    Patient is not on beta blocker medication';
  Beta := '0';
  if rbBetaN.Color = clYellow then
    begin
      ResetColor2;
      BackToRequired;
    end;
end;

procedure TfrmPatient.rbDiabYClick(Sender: TObject);
begin
  SetPiece(SRisk, '^', 3, '1');
  frmReview.memNote.Lines[58] := '    Patient is a diabetic';
  Diab := '1';
  if rbDiabY.Color = clYellow then
    begin
      ResetColor3;
      BackToRequired;
    end;
end;

procedure TfrmPatient.rbDiabNClick(Sender: TObject);
begin
  SetPiece(SRisk, '^', 3, '0');
  frmReview.memNote.Lines[58] := '    Patient is not a diabetic';
  Diab := '0';
  if rbDiabN.Color = clYellow then
    begin
      ResetColor3;
      BackToRequired;
    end;
end;

procedure TfrmPatient.rbLatex1Click(Sender: TObject);
begin
  SetPiece(SRisk, '^', 4, '1');
  frmReview.memNote.Lines[59] := '    ' + rbLatex1.Caption;
  Latex := '1';
  if rbLatex1.Color = clYellow then
    begin
      ResetColor4;
      BackToRequired;
    end;
end;

procedure TfrmPatient.rbLatex2Click(Sender: TObject);
begin
  SetPiece(SRisk, '^', 4, '2');
  frmReview.memNote.Lines[59] := '    ' + rbLatex2.Caption;
  Latex := '2';
  if rbLatex2.Color = clYellow then
    begin
      ResetColor4;
      BackToRequired;
    end;
end;

procedure TfrmPatient.rbLatex3Click(Sender: TObject);
begin
  SetPiece(SRisk, '^', 4, '3');
  frmReview.memNote.Lines[59] := '    ' + rbLatex3.Caption;
  Latex := '3';
  if rbLatex3.Color = clYellow then
    begin
      ResetColor4;
      BackToRequired;
    end;
end;

procedure TfrmPatient.rbLatex4Click(Sender: TObject);
begin
  SetPiece(SRisk, '^', 4, '4');
  frmReview.memNote.Lines[59] := '    ' + rbLatex4.Caption;
  Latex := '4';
  if rbLatex4.Color = clYellow then
    begin
      ResetColor4;
      BackToRequired;
    end;
end;

procedure TfrmPatient.edBMIChange(Sender: TObject);
begin
  SetPiece(SRisk, '^', 5, edBMI.Text);
  if edBMI.Text = '' then frmReview.memNote.Lines[60] := '    Patient has no BMI available'
  else frmReview.memNote.Lines[60] := '    Patients last BMI is ' + edBMI.Text;
  BMI := edBMI.Text;
end;

procedure TfrmPatient.rbSmok1Click(Sender: TObject);
begin
  SetPiece(SRisk, '^', 6, '1');
  frmReview.memNote.Lines[61] := '    ' + rbSmok1.Caption;
  Smok := '1';
  if rbSmok1.Color = clYellow then
    begin
      ResetColor6;
      BackToRequired;
    end;
end;

procedure TfrmPatient.rbSmok2Click(Sender: TObject);
begin
  SetPiece(SRisk, '^', 6, '2');
  frmReview.memNote.Lines[61] := '    ' + rbSmok2.Caption;
  Smok := '2';
  if rbSmok2.Color = clYellow then
    begin
      ResetColor6;
      BackToRequired;
    end;
end;

procedure TfrmPatient.rbSmok3Click(Sender: TObject);
begin
  SetPiece(SRisk, '^', 6, '3');
  frmReview.memNote.Lines[61] := '    ' + rbSmok3.Caption + ' ' + edSmok.Text;
  Smok := '3';
  edSmok.SetFocus;
  if rbSmok3.Color = clYellow then
    begin
      ResetColor6;
      BackToRequired;
    end;
end;

procedure TfrmPatient.edSmokChange(Sender: TObject);
begin
  SetPiece(SRisk, '^', 6, '3:' + edSmok.Text);
  frmReview.memNote.Lines[61] := '    ' + rbSmok3.Caption + ' ' + edSmok.Text;
  SUntil := edSmok.Text;
end;

procedure TfrmPatient.rbLegYClick(Sender: TObject);
begin
  SetPiece(SRisk, '^', 7, '1');
  frmReview.memNote.Lines[62] := '    Patient has leg clots';
  Leg := '1';
end;

procedure TfrmPatient.rbLegNClick(Sender: TObject);
begin
  SetPiece(SRisk, '^', 7, '0');
  frmReview.memNote.Lines[62] := '    Patient does not have leg clots';
  Leg := '0';
end;

procedure TfrmPatient.rbSCYClick(Sender: TObject);
var
  scnt, J, line: integer;
begin
  SetPiece(SRisk, '^', 8, '1');
  frmReview.memNote.Lines[63] := '    Patient is service-connected for the primary procedure';
  SConn := '1';
  if lbSCTemp.Items.Count = 0 then  // double check+
    begin
      CallV('APTWL GET SR OBJECT DATA', [8, Patient.DFN]);
      lbSCTemp.Items := RPCBrokerV.Results;
    end;
  line := 63;
  scnt := 0;
  if lbSCTemp.Items.Count > 0 then
   begin
      for J := 0 to lbSCTemp.Items.Count -1 do
        begin
          scnt := scnt + 1;
          if scnt > 5 then break;
          frmReview.memNote.Lines[line + scnt] := '        ' + lbSCTemp.Items[J];
        end;
    end;
     if rbSCY.Color = clYellow then
    begin
      ResetColor8;
      BackToRequired;
    end;
end;

procedure TfrmPatient.rbSCNClick(Sender: TObject);
begin
  SetPiece(SRisk, '^', 8, '0');
  frmReview.memNote.Lines[63] := '    Patient is not service-connected for the primary procedure';
  SConn := '0';
  if rbSCN.Color = clYellow then
    begin
      ResetColor8;
      BackToRequired;
    end;
end;

procedure TfrmPatient.GetSC;
begin
  CallV('APTWL GET SR OBJECT DATA', [8, Patient.DFN]);
  memSC.Lines   := RPCBrokerV.Results;
  lbSCTemp.Items := RPCBrokerV.Results;
end;

procedure TfrmPatient.GetINR;
begin
  CallV('APTWL GET SR OBJECT DATA', [1, Patient.DFN]);
  memCoag.Lines := RPCBrokerV.Results;
end;

procedure TfrmPatient.GetBeta;
begin
  CallV('APTWL GET SR OBJECT DATA', [2, Patient.DFN]);
  memBeta.Lines     := RPCBrokerV.Results;
  lbBetaTemp.Items := RPCBrokerV.Results;
end;

procedure TfrmPatient.GetA1C;
begin
  CallV('APTWL GET SR OBJECT DATA', [3, Patient.DFN]);
  memDiab.Lines := RPCBrokerV.Results;
end;

procedure TfrmPatient.GetLat;
begin
  CallV('APTWL GET SR OBJECT DATA', [4, Patient.DFN]);
  memLatex.Lines := RPCBrokerV.Results;
end;

procedure TfrmPatient.GetBMI;
begin
  CallV('APTWL GET SR OBJECT DATA', [5, Patient.DFN]);
  memBMI.Lines := RPCBrokerV.Results;
end;

procedure TfrmPatient.SetUpQuestions;
begin
  with frmPatient do
    begin
      Param   := sCallV('APTWL GET SRM QUESTION', [SpecIFN]);
      if piece(Param, '^', 1) = '1' then
        begin
          GetINR;
          gbAntiCoag.Visible := True;
        end;
      if piece(Param, '^', 2) = '1' then
        begin
          GetBeta;
          gbBeta.Visible   := True;
        end;
      if piece(Param, '^', 3) = '1' then
        begin
          GetA1C;
          gbDiab.Visible   := True;
        end;
      if piece(Param, '^', 4) = '1' then
        begin
          GetLat;
          gbLatex.Visible  := True;
        end;
      if piece(Param, '^', 5) = '1' then
        begin
          GetBMI;
          gbBMI.Visible    := True;
        end;
      if piece(Param, '^', 6) = '1' then gbSmok.Visible   := True;
      if piece(Param, '^', 7) = '1' then gbLeg.Visible    := True;
      if piece(Param, '^', 8) = '1' then
        begin
          GetSC;
          gbSC.Visible     := True;
        end;
      if piece(Param, '^', 9) = '1' then
        begin
          GetAller;
          gbAller.Visible  := True;
        end;
      if piece(Param, '^', 10) = '1' then gbJoint.Visible := True;
      if piece(Param, '^', 11) = '1' then gb2.Visible     := True;
      if piece(Param, '^', 12) = '1' then gb3.Visible     := True;
      SRisk := '^^^^^^^^^^';
    end;
end;

procedure TfrmPatient.edNVAChange(Sender: TObject);
begin
  if edNVA.Text = '' then frmReview.memNote.Lines[57] := '';
  if edNVA.Text <> '' then frmReview.memNote.Lines[57] := '        Non-VA Meds: ' + edNVA.Text;
end;

procedure TfrmPatient.ResetColor1;
begin
  rbAntiY.Color := clMoneyGreen;
  rbAntiN.Color := clMoneyGreen;
end;

procedure TfrmPatient.ResetColor2;
begin
  rbBetaY.Color := clMoneyGreen;
  rbBetaN.Color := clMoneyGreen;
end;

procedure TfrmPatient.ResetColor3;
begin
  rbDiabY.Color := clMoneyGreen;
  rbDiabN.Color := clMoneyGreen;
end;

procedure TfrmPatient.ResetColor4;
begin
  rbLatex1.Color := clSkyBlue;
  rbLatex2.Color := clSkyBlue;
  rbLatex3.Color := clSkyBlue;
  rbLatex4.Color := clSkyBlue;
end;

procedure TfrmPatient.ResetColor6;
begin
  rbSmok1.Color := clSkyBlue;
  rbSmok2.Color := clSkyBlue;
  rbSmok3.Color := clSkyBlue;
  edSmok.Color  := clWindow;
end;

procedure TfrmPatient.ResetColor8;
begin
  rbSCY.Color := clActiveBorder;
  rbSCN.Color := clActiveBorder;
end;

procedure TfrmPatient.BackToRequired;
begin
  frmReview.ConvertNote;
  frmPatient.Visible := False;
  frmPatient.SendToBack;
  frmReview.SetFocus;
  frmReview.CheckRequiredFields;
end;

procedure TfrmPatient.edBMIKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if (key = 13) and (edBMI.Color = clYellow) then
    begin
      edBMI.Color := clWindow;
      BackToRequired;
    end;
end;

procedure TfrmPatient.edSmokKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
   if (key = 13) and (edSmok.Color = clYellow) then
    begin
      ResetColor6;
      BackToRequired;
    end;
end;

procedure TfrmPatient.rbAllerYClick(Sender: TObject);
var
  line, dcnt, J: integer;
begin
  SetPiece(SRisk, '^', 9, '1');
  frmReview.memNote.Lines[64] := '    Patient does not report allergies';
  Aller := '1';
  edAller.SetFocus;
  if lbAllerTemp.Items.Count = 0 then  // double check
    begin
      CallV('APTWL GET SR OBJECT DATA', [9, Patient.DFN]);
      lbAllerTemp.Items := RPCBrokerV.Results;
    end;
  line := 64;
  dcnt := 0;
  if lbAllerTemp.Items.Count >0 then
    begin
      for J := 0 to lbAllerTemp.Items.Count -1 do
        begin
          dcnt := dcnt + 1;
          if dcnt > 2 then break;
          frmReview.memNote.Lines[line + dcnt] := '        ' + lbBetaTemp.Items[J];
        end;
    end;
  if edAller.Text <> '' then frmReview.memNote.Lines[67] := '        Allergy Details: ' + edAller.Text;
  if rbAllerY.Color = clYellow then
    begin
      ResetColor9;
      BackToRequired;
    end;
end;

procedure TfrmPatient.rbAllerNClick(Sender: TObject);
begin
  SetPiece(SRisk, '^', 9, '0');
  frmReview.memNote.Lines[64] := '    Patient has no allergies';
  Aller := '0';
  edAller.SetFocus;
  if rbAllerN.Color = clYellow then
    begin
      ResetColor9;
      BackToRequired;
    end;
end;

procedure TfrmPatient.rbJointYClick(Sender: TObject);
begin
  SetPiece(SRisk, '^', 10, '1');
  frmReview.memNote.Lines[68] := '    Patient has artificial joints or heart valves';
  Joint := '1';
  if rbJointY.Color = clYellow then
    begin
      ResetColor10;
      BackToRequired;
    end;
end;

procedure TfrmPatient.rbJointNClick(Sender: TObject);
begin
  SetPiece(SRisk, '^', 10, '0');
  frmReview.memNote.Lines[68] := '    Patient has no artificial joints or heart valves';
  Joint := '0';
  if rbJointN.Color = clYellow then
    begin
      ResetColor10;
      BackToRequired;
    end;
end;

procedure TfrmPatient.ResetColor9;
begin
  rbAllerY.Color := clActiveBorder;
  rbAllerN.Color := clActiveBorder;
  edAller.Color  := clWindow;
end;

procedure TfrmPatient.ResetColor10;
begin
  rbJointY.Color := clMoneyGreen;
  rbJointN.Color := clMoneyGreen;
end;

procedure TfrmPatient.GetAller;
begin
  CallV('APTWL GET SR OBJECT DATA', [9, Patient.DFN]);
  memAller.Lines      := RPCBrokerV.Results;
  lbAllerTemp.Items := RPCBrokerV.Results;
end;

procedure TfrmPatient.edAllerChange(Sender: TObject);
begin
  if edAller.Text <> '' then frmReview.memNote.Lines[67] := '        Allergy Details: ' + edAller.Text;
  if edAller.Text = '' then frmReview.memNote.Lines[67] := '';
end;

procedure TfrmPatient.edAllerKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if (key = 13) and (edAller.Color = clYellow) then
    begin
      ResetColor9;
      BackToRequired;
    end;
end;

procedure TfrmPatient.edNVAKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if (key = 13) and (edNVA.Color = clYellow) then
    begin
      ResetColor2;
      BackToRequired;
    end;
end;

procedure TfrmPatient.RequiredFields;
begin
  Reqfld   := sCallV('APTWL GET SRM REQUIRED', [SpecIFN]);
  with frmConcur do
    begin
      if piece(Reqfld, '^', 1) = '1' then
        begin
          rbConcur1.Font.Color := clBlue;
          rbConcur2.Font.Color := clBlue;
          rbConcur3.Font.Color := clBlue;
          lblCAtt.Font.Color   := clBlue;
          lblCosig.Font.Color  := clBlue;
        end;
      if piece(Reqfld, '^', 2) = '1' then
        begin
          rbEval1.Font.Color   := clBlue;
          rbEval2.Font.Color   := clBlue;
          rbEval3.Font.Color   := clBlue;
          rbEval4.Font.Color   := clBlue;
          gbMed.Font.Color     := clBlue;
          gbSurg.Font.Color    := clBlue;
        end;
    end;
  with frmProcedure do
    begin
      if piece(Reqfld, '^', 3) = '1' then lblFTProc.Font.Color := clBlue;
      if piece(Reqfld, '^', 4) = '1' then lblLat.Font.Color    := clBlue;
      if piece(Reqfld, '^', 5) = '1' then lblPos.Font.Color    := clBlue;
      if piece(Reqfld, '^', 6) = '1' then lblLoc.Font.Color    := clBlue;
      if piece(Reqfld, '^', 7) = '1' then lblDiag.Font.Color   := clBlue;
      if piece(Reqfld, '^', 8) = '1' then lblBrief.Font.Color  := clBlue;
      if piece(Reqfld, '^', 9) = '1' then lblRes.Font.Color    := clBlue;
      if piece(Reqfld, '^', 10) = '1' then lblAtt.Font.Color   := clBlue;
      if piece(Reqfld, '^', 11) = '1' then lblLen.Font.Color   := clBlue;
      if piece(Reqfld, '^', 12) = '1' then lblComp.Font.Color  := clBlue;
      if piece(Reqfld, '^', 13) = '1' then lblTyp.Font.Color   := clBlue;
      if piece(Reqfld, '^', 14) = '1' then lblOrd.Font.Color   := clBlue;
      if piece(Reqfld, '^', 15) = '1' then lblStat.Font.Color  := clBlue;
      if piece(Reqfld, '^', 16) = '1' then lblDis.Font.Color   := clBlue;
      if piece(Reqfld, '^', 17) = '1' then lblNeed.Font.Color  := clBlue;
      if piece(Reqfld, '^', 18) = '1' then lblEq.Font.Color    := clBlue;
    end;
end;

end.
