unit fOther;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Buttons, ORCtrls, ExtCtrls, ORNet, ORFn;

type
  TfrmOther = class(TForm)
    lblProc: TLabel;
    pnl1: TPanel;
    btnEdit: TButton;
    btnDel: TButton;
    lbOther: TORListBox;
    btnExit: TBitBtn;
    btnEnter: TBitBtn;
    pnlProc: TPanel;
    cbOther: TORComboBox;
    btnAdd: TButton;
    lblSel: TLabel;
    lblSel3: TLabel;
    lblLat: TLabel;
    cbOLat: TORComboBox;
    lblLat2: TLabel;
    pnlOR: TPanel;
    lblSel2: TLabel;
    edOProc: TEdit;
    lblLoc: TLabel;
    edOLoc: TEdit;
    lblLoc1: TLabel;
    btnAct: TButton;
    lblNum: TLabel;
    procedure lbOtherClick(Sender: TObject);
    procedure btnAddClick(Sender: TObject);
    procedure HideSelection;
    procedure ShowSelection;
    procedure btnEditClick(Sender: TObject);
    procedure btnDelClick(Sender: TObject);
    procedure btnExitClick(Sender: TObject);
    procedure btnEnterClick(Sender: TObject);
    procedure cbOtherClick(Sender: TObject);
    procedure edOProcClick(Sender: TObject);
    procedure cbOLatClick(Sender: TObject);
    procedure cbOtherChange(Sender: TObject);
    procedure btnActClick(Sender: TObject);
    procedure OtherToNote;
    procedure FormCreate(Sender: TOBject);
    procedure BackToRequired;
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmOther: TfrmOther;
  Edit, OtherChange: integer;
  ProcIFN, Proc, Lat, Loc: string;

implementation

{$R *.dfm}

uses SurgReqMain, fProcedure, rLocal, fReview;

procedure TfrmOther.FormCreate(Sender: TObject);
var
  J: integer;
begin
  with frmOther do
    begin
      lbOther.Clear;
      if frmProcedure.lbSec.Items.Count > 0 then
        begin
          for J := 0 to frmProcedure.lbSec.Items.Count-1 do lbOther.Items.Add(frmProcedure.lbSec.Items[J]);
        end;
      if (UsePTLD = 1) then
        begin
          CallV('APTWL GET PROC', []);
          cbOther.Items := RPCBrokerV.Results;
        end;
      CallV('APTWL GET LATERALITY', []);
      cbOLat.Items      := RPCBrokerV.Results;
      HideSelection;
      btnEdit.Enabled  := False;
      btnDel.Enabled   := False;
      btnEnter.Enabled := False;
      if UsePTLD = 0 then
        begin
          lblSel.Enabled  := False;
          cbOther.Enabled := False;
          lblSel3.Enabled := False;
        end;
      Edit := 0;
      OtherChange := 0;
    end;
end;

procedure TfrmOther.lbOtherClick(Sender: TObject);
begin
  //ResetTimeOut;
  btnEdit.Enabled := True;
  btnDel.Enabled  := True;
end;

procedure TfrmOther.btnAddClick(Sender: TObject);
begin
  ShowSelection;
  btnEnter.Caption := 'Place on List';
end;

procedure TfrmOther.HideSelection;
begin
  pnlProc.Visible  := False;
  btnEnter.Visible := False;
end;

procedure TfrmOther.ShowSelection;
begin
  pnlProc.Visible  := True;
  btnEnter.Visible := True;
  if UsePTLD = 0 then
    begin
      lblSel.Enabled  := False;
      cbOther.Enabled := False;
    end;
end;

procedure TfrmOther.btnEditClick(Sender: TObject);
var
  Node, Key: string;
begin
  node := lbOther.Items[lbOther.ItemIndex];
  Key  := piece(node, '^', 7);
  if Key = '1' then
    begin
      ProcIFN      := piece(Node, '^', 2);
      cbOther.Text := piece(Node, '^', 1);
    end
  else edOProc.Text := piece(Node, '^', 1);
  cbOLat.Text := piece(Node, '^', 8);
  edOLoc.Text := piece(Node, '^', 9);
  ShowSelection;
  Edit := 1;
  btnEnter.Caption := 'Save Changes';
end;

procedure TfrmOther.btnDelClick(Sender: TObject);
begin
  if MessageDlg('Are you sure you want to delete the entry?', mtconfirmation, [mbYes, mbNo], 0) = mrNo then
    begin
      Exit;
    end;
  lbOther.Items.Delete(lbOther.ItemIndex);
  OtherToNote;
  OtherChange := 1;
end;

procedure TfrmOther.btnExitClick(Sender: TObject);
begin
  OtherToNote;
  frmOther.Visible := False;
  frmOther.SendToBack;
  frmProcedure.Visible := True;
  frmProcedure.BringToFront;
  frmProcedure.SetFocus;
end;

procedure TfrmOther.btnEnterClick(Sender: TObject);
var
  X, Data: string;
  Key: integer;
  // if using Portland procedures, KEY = 1
begin
  if cbOther.Text <> '' then Key := 1
    else Key := 0;
  if Key = 1 then Proc := cbOther.Text
    else Proc := edOProc.Text;
  if Edit = 1 then
    begin
      X := lbOther.Items[lbOther.ItemIndex];
      SetPiece(X, '^', 1, Proc);
      SetPiece(X, '^', 2, ProcIFN);
      SetPiece(X, '^', 3, cbOther.Text);
      SetPiece(X, '^', 4, edOProc.Text);
      SetPiece(X, '^', 7, IntToStr(Key));
      SetPiece(X, '^', 8, cbOLat.Text);
      SetPiece(X, '^', 9, edOLoc.Text);
      lbOther.Items[lbOther.ItemIndex] := X;
      OtherChange := 1;
    end;
  if Edit = 0 then
    begin
      if (cbOther.Text = '') and (edOProc.Text = '') then Exit;
      //if cbOther.Text <> '' then ProcIFN := IntToStr(cbOther.ItemIEN);
      Data := Proc + '^' + ProcIFN + '^' + cbOther.Text + '^' + edOProc.Text;
      SetPiece(Data, '^', 7, IntToStr(Key));
      SetPiece(Data, '^', 8, cbOLat.Text);
      SetPiece(Data, '^', 9, edOLoc.Text);
      lbOther.Items.Add(Data);
      OtherChange := 1;
    end;
  Edit := 0;
  HideSelection;
  cbOther.Text  := '';
  edOProc.Text  := '';
  cbOLat.Text    := '';
  edOLoc.Text    := '';
end;

procedure TfrmOther.cbOtherClick(Sender: TObject);
begin
  ProcIFN := IntToStr(cbOther.ItemIEN);
  btnEnter.Enabled := True;
end;

procedure TfrmOther.edOProcClick(Sender: TObject);
begin
  btnEnter.Enabled := True;
end;

procedure TfrmOther.cbOLatClick(Sender: TObject);
var
  X: string;
begin
  btnEnter.Enabled := True;
  if cbOLat.Color = clYellow then
    begin
      cbOLat.Color := clWindow;
      cbOLat.DroppedDown := False;
      X := lbOther.Items[OItem];
      SetPiece(X, '^', 8, cbOLat.Text);
      lbOther.Items[OItem] := X;
      cbOLat.Text := '';
      OtherToNote;
      BackToRequired;
    end;
end;

procedure TfrmOther.cbOtherChange(Sender: TObject);
begin
  if cbOther.Text = '' then Exit;
  CallV('APTWL GET PROC', [cbOther.Text]);
  cbOther.Items := RPCBrokerV.Results;
  cbOther.DroppedDown := True;
end;

procedure TfrmOther.btnActClick(Sender: TObject);
begin
  HideSelection;
  if Edit = 1 then btnEdit.Enabled := False;
end;

procedure TfrmOther.OtherToNote;
var
  J, ocnt, incr: integer;
  data: string;
begin
  ocnt := 0;
  frmProcedure.lbSec.Items.Clear;
  for J := 0 to lbOther.Items.Count -1 do
    begin
      data := lbOther.Items[J];
      Proc := piece(data, '^', 1);
      Lat  := piece(data, '^', 8);
      Loc  := piece(data, '^', 9);
      ocnt := ocnt + 1;
      if ocnt > 4 then break;
      if ocnt = 1 then incr := 1;
      if ocnt = 2 then incr := 3;
      if ocnt = 3 then incr := 5;
      if ocnt = 4 then incr := 7;
      frmReview.memNote.Lines[38 + incr] := '    Procedure: ' + Proc;
      frmReview.memNote.Lines[38 + incr + 1] := '          Laterality: ' + Lat + '  ' + Loc;
      frmProcedure.lbSec.Items.Add(lbOther.Items[J]);
    end;
end;

procedure TfrmOther.BackToRequired;
begin
  frmReview.ConvertNote;
  frmOther.Visible := False;
  frmOther.SendToBack;
  frmReview.SetFocus;
  frmReview.CheckRequiredFields;
end;

end.
