unit fMailTo;
{ DATE CREATED:  9-99
  CREATED BY:    user   user, PORTLAND VAMC
  DESCRIPTION:   GENERIC 'MAIL TO' MODULE, RECIPIENTS CAN BE SELECTED FROM USER
                 FILE, MAIL GROUP FILE, REMOTE PROVIDER FILE OR THE PERSONAL
                 HOT LIST
  MODIFIED:      2-18-00, 2-21-00, 2-22-00, 3-23-00}


interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, ORCtrls, ORNet, ORFn, uCore, Trpcb, FmCmpnts,
  Diaccess, Fmcntrls, Rpcberr, Menus, ComCtrls, fAddComm, fNotes, fTemp, fRptBox,
  Buttons;

type
  TfrmMailTo = class(TForm)
    pnlMailTo1: TPanel;
    pnlMailTo2: TPanel;
    pnlMailTo3: TPanel;
    btnSend: TButton;
    btnCanc: TButton;
    grbMailTo1: TGroupBox;
    pnlMailTo4: TPanel;
    gbMailTo2: TGroupBox;
    lblPCP: TLabel;
    lblPCPv: TLabel;
    lblMHPCP: TLabel;
    lblMHPCPv: TLabel;
    lblAdm: TLabel;
    lblAdmv: TLabel;
    lblAtt: TLabel;
    lblRes: TLabel;
    lblProv: TLabel;
    lblAttv: TLabel;
    lblResv: TLabel;
    lblProvv: TLabel;
    pnlMailTo5: TPanel;
    gbMailTo3: TGroupBox;
    edSubject: TEdit;
    lblSelect: TLabel;
    gbMailTo4: TGroupBox;
    lbRecip: TORListBox;
    lblList: TLabel;
    rbUser: TRadioButton;
    rbGroup: TRadioButton;
    btnEdit: TButton;
    popRecip: TPopupMenu;
    popDelAll: TMenuItem;
    popDelHigh: TMenuItem;
    Dtext: TListBox;
    cbPrior: TCheckBox;
    cbInfo: TCheckBox;
    cbConf: TCheckBox;
    cbCopy: TCheckBox;
    Temp: TListBox;
    PCPList: TListBox;
    rbProv: TRadioButton;
    rbHot: TRadioButton;
    lstMem: TListBox;
    lstProv: TListBox;
    lstHot: TListBox;
    rbOther: TRadioButton;
    lblOther: TLabel;
    edOther: TEdit;
    popComm: TMenuItem;
    popProp: TMenuItem;
    lbSpec: TListBox;
    rbTeam: TRadioButton;
    btnMove: TBitBtn;
    btnOMove: TBitBtn;
    memNote: TMemo;
    edSelect: TEdit;
    lbSelect: TORListBox;
    procedure btnCancClick(Sender: TObject);
    procedure btnSendClick(Sender: TObject);
    procedure rbUserClick(Sender: TObject);
    procedure rbGroupClick(Sender: TObject);
    procedure popDelAllClick(Sender: TObject);
    procedure popDelHighClick(Sender: TObject);
    procedure btnMessClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure rbProvClick(Sender: TObject);
    procedure edSelectChng(Sender: TObject);
    procedure rbHotClick(Sender: TObject);
    procedure rbOtherClick(Sender: TObject);
    procedure edOtherKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure edSelectKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure popCommClick(Sender: TObject);
    procedure popPropClick(Sender: TObject);
    function UserProp(DUZ: integer): TStrings;
    procedure lbRecipClick(Sender: TObject);
    procedure SiteCheck(Site: string);
    procedure rbTeamClick(Sender: TObject);
    procedure btnOMoveClick(Sender: TObject);
    procedure btnMoveClick(Sender: TObject);
    procedure lbSelectClick(Sender: TObject);
    procedure lbSelectDblClick(Sender: TObject);
  private
    { Private declarations }
    procedure DeleteOther;
    procedure EnablePop;
    procedure GetData(Dest: TStrings; Key, St: string);
  public
    { Public declarations }
  end;

var
  frmMailTo: TfrmMailTo;
  Doctype, DocID, Key, St, ID: string;
  vaOK, Change: integer;

procedure MailTo(TextList: TRichEdit; Subject: string; DocData: string);

implementation

{$R *.DFM}

procedure MailTo(TextList: TRichEdit; Subject: string; DocData: string);
var
  I: integer;
  Check: string;
begin
  if TextList.Lines.Count = 0 then
  begin
    MessageDlg('There is no document identified to mail.', mterror, [mbok], 0);
  end
  else
  begin
  frmMailTo := TfrmMailTo.Create(Application);
  try
    with frmMailTo do
    begin
      Dtext.Clear;
      for I := 0 to TextList.Lines.Count-1 do Dtext.Items.Add(TextList.Lines[I]);
      lblPCPv.Caption := '';
      lblMHPCPv.Caption := '';
      lblAdmv.Caption := '';
      lblAttv.Caption := '';
      lblResv.Caption := '';
      lblProvv.Caption := '';
      edSubject.Text := Subject;
      lbRecip.Items.Clear;
      lbSpec.Items.Clear;
      lbSelect.Items.Clear;
      lbSelect.Visible := False;
      CallV('APTO GET PCP', [Patient.DFN]);
      PCPList.Items := RPCBrokerV.Results;
      Check := sCallV('APTO CHECK LOCAL', [User.DUZ]);
      lblPCPv.Caption := piece(PCPList.Items[0],U,2);
      lblMHPCPv.Caption := piece(PCPList.Items[4],U,2);
      lblAdmv.Caption := piece(PCPList.Items[5],U,2);
      lblAttv.Caption := piece(PCPList.Items[3],U,2);
      lblResv.Caption := piece(PCPList.Items[6],U,2);
      lblProvv.Caption := piece(PCPList.Items[10],U,2);
      edSubject.Text := Subject + ' for ' + Patient.Name;
      edSelect.Enabled := False;
      if piece(Check, '^', 1) = '0' then rbHot.Enabled := False;
      if piece(Check, '^', 2) = '0' then rbProv.Enabled := False;
      DocID := DocData;
      DocType := '0';
      Change := 1;
      if Subject = 'Discharge Summary' then DocType := '1';
      if Subject = 'Progress Note' then Doctype := '14';
      if subject = 'Consult' then Doctype := '20';
      DeleteOther;
      ShowModal;
    end;
  finally
    frmMailTo.Release;
  end;
  end;
end;

procedure TfrmMailTo.btnCancClick(Sender: TObject);
begin
  Close;
end;

procedure TfrmMailTo.btnSendClick(Sender: TObject);
var
  I,J: integer;
  Success,MParam,Prior,Info,Conf,Copy: string;
begin
  J := 1;
  if edSubject.Text = '' then
  begin
    MessageDlg('A message subject must be entered.', mterror, [mbok],0);
    edSubject.SetFocus;
    J := 0;
  end;
  if lbRecip.Items.Count = 0 then
  begin
    MessageDlg('There are no recipients listed.', mterror, [mbok], 0);
    if edSelect.Enabled = true then edSelect.SetFocus;
    J := 0;
  end;
  if J = 1 then
  begin
    //Success := sCallV('APTO MAILTO', [Dtext.Strings, edSubject.Text, lbRecip.Items, User.DUZ]);
    Prior := '';
    if cbPrior.Checked = True then Prior := '1';
    Info := '';
    if cbInfo.Checked = True then Info := '1';
    Conf := '';
    if cbConf.Checked = True then Conf := '1';
    Copy := '';
    if cbCopy.Checked = True then Copy := '1';
    Mparam := Prior + U + Info + U + Conf + U + Copy + U + DocType
     + U + DocID + U + Patient.DFN;
    with RPCBrokerV do
    begin
      ClearParameters := True;
      RemoteProcedure := 'APTO MAILTO';
      Param[0].PType := Literal;
      Param[0].Value := User.DUZ;
      Param[1].PType := Literal;
      Param[1].Value := edSubject.Text;
      Param[2].PType := Literal;
      Param[2].Value := Mparam;
      Param[3].PType := List;
      with Param[3] do
      begin
        for I := 0 to Dtext.Items.Count -1 do
          Mult['"TEXT",' + IntToStr(I+1)] := Dtext.Items[I];
        for I := 0 to lbRecip.Items.Count-1 do
          Mult['"TO",' + IntToStr(I+1)] := lbRecip.Items[I];
        if lbSpec.Items.Count >0 then
          for I := 0 to lbSpec.Items.Count-1 do
            Mult['"SPEC",' + IntToStr(I+1)] := lbSpec.Items[I];
      end;
      CallBroker;
      Success := Results[0];
    end;
    if Success = '1' then MessageDlg('Message sent to Vista Email.', mtinformation, [mbok], 0)
    else MessageDlg('Message transmission was not successful.', mtinformation, [mbok], 0);
    Close;
  end;
end;

procedure TfrmMailTo.rbUserClick(Sender: TObject);
begin
  DeleteOther;
  edSelect.Enabled := True;
  edSelect.Text := '';
  lblSelect.Caption := 'Select User';
  Key := '200';
  St := '';
  GetData(lbSelect.Items, Key, St);
  lbSelect.Visible := True;
  edSelect.SetFocus;
end;

procedure TfrmMailTo.rbGroupClick(Sender: TObject);
begin
  DeleteOther;
  edSelect.Enabled := True;
  edSelect.Text := '';
  lblSelect.Caption := 'Select Mail Group';
  Key := '3.8';
  St := '';
  GetData(lbSelect.Items, Key, St);
  lbSelect.Visible := True;
  edSelect.SetFocus;
end;

procedure TfrmMailTo.btnMoveClick(Sender: TObject);
var
  IFN, Dom, Forw, Msg, Recip: string;
  I: integer;
begin
  lstMem.Clear;
  lstProv.Clear;
  if ID = '' then Exit;
  if Key = '200' then      // Users
  begin
    IFN := piece(ID, '^', 1);
    Forw := sCallV('APTO GET FORWARD', [IFN]);
    if Forw <> '' then
    begin
      SiteCheck(piece(Forw, '@', 2));
      if vaOK = 0 then
        begin
          Msg := Recip + ' has an Email forwarding address of ' + Forw + '.  Sending a message to that address may violate patient confidentiality.  This recipient will not be included.';
          MessageDlg(Msg, mtinformation, [mbOK], 0);
          Exit;
        end;
    end;
    lbRecip.Items.Add(pieces(ID, '^',1, 2));
  end;
  if Key = '3.8' then      // mail groups
  begin
    lstMem.Clear;
    CallV('APTO GET MEMBERS', [piece(ID, '^', 2)]);
    lstMem.Items := RPCBrokerV.Results;
    if lstMem.Items.Count >0 then
    begin
      for I := 0 to lstMem.Items.Count-1 do
        begin
          Recip := piece(lstMem.Items[I], '^', 2);
          IFN := piece(lstMem.Items[I], '^', 1);
          Forw := sCallV('APTO GET FORWARD', [IFN]);
          if Forw <> '' then
          begin
            SiteCheck(piece(Forw, '@', 2));
            if vaok = 0 then
              begin
                Msg := 'Group member ' + Recip + ' has an Email forwarding address of ' + Forw + '.  Sending a message to that address may violate patient confidentiality.  This recipient will not be added to the list.';
                MessageDlg(Msg, mtinformation, [mbok], 0);
                lstMem.Items[I] := '';
              end;
          end;
          if lstMem.Items[I] <> '' then lbRecip.Items.Add(lstMem.Items[I]);
        end;
    end;
  end;
  if Key = '4.2' then     // domains/remote providers
  begin
    lstProv.Clear;
    Dom := piece(ID, '^', 2);
    CallV('APTO GET REM PROV', [Dom]);
    lstProv.Items := RPCBrokerV.Results;
    if lstProv.Items.Count >0 then TempList(lstProv, Dom+' Providers');
    with frmTemp do
    begin
      if lbFinal.Items.Count >0 then
      begin
        for I := 0 to lbFinal.Items.Count-1 do
        lbRecip.Items.Add(lbFinal.Items[I] + '^' + lbFinal.Items[I]);
      end;
    end
  end;
  if Key = '404.51' then       // teams
  begin
    lstProv.Clear;
    CallV('APTO GET TEAM', [piece(ID, '^', 2)]);
    lstProv.Items := RPCBrokerV.Results;
    if lstProv.Items.Count >0 then
      begin
        for I := 0 to lstProv.Items.Count-1 do
        lbRecip.Items.Add(lstProv.Items[I]);
      end;
  end;
  //lbSelect.Items.Clear;
  edSelect.SetFocus;
  EnablePop;
end;

procedure TfrmMailTo.popDelAllClick(Sender: TObject);
begin
  lbRecip.Items.Clear;
  EnablePop;
  popDelHigh.Enabled := False;
  popComm.Enabled := False;
  PopProp.Enabled := False;
end;

procedure TfrmMailTo.popDelHighClick(Sender: TObject);
begin
  if lbRecip.ItemIndex >-1 then lbRecip.Items.Delete(lbRecip.ItemIndex);
  EnablePop;
  popDelHigh.Enabled := False;
  popComm.Enabled := False;
  popProp.Enabled := False;
end;

procedure TfrmMailTo.btnMessClick(Sender: TObject);
// move comment lines to top of message text
var
  I: integer;
begin
  AddComm('Add General Comment');
  with frmAddComm do
  begin
    if memComm.Lines.Count >0 then
    begin
      Temp.Items.Clear;
      Temp.Items.Add('General Comment:');
      for I := 0 to memComm.Lines.Count-1 do Temp.Items.Add(memComm.Lines[I]);
      Temp.Items.Add(' ');
      Temp.Items.Add('*************************************************');
      Temp.Items.Add(' ');
      for I := 0 to Dtext.Items.Count-1 do Temp.Items.Add(Dtext.Items[I]);
      Dtext.Clear;
      for I := 0 to Temp.Items.Count-1 do Dtext.Items.Add(Temp.Items[I]);
    end;
  end;
end;

procedure TfrmMailTo.FormShow(Sender: TObject);
begin
  edSubject.SetFocus
end;

procedure TfrmMailTo.rbProvClick(Sender: TObject);
begin
  DeleteOther;
  edSelect.Enabled := True;
  edSelect.Text := '';
  lblSelect.Caption := 'Select Site';
  Key := '4.2';
  St := '';
  GetData(lbSelect.Items, Key, St);
  lbSelect.Visible := True;
  edSelect.SetFocus;
end;

procedure TfrmMailTo.edSelectChng(Sender: TObject);
begin
  if Change = 0 then Exit;
  St := edSelect.Text;
  lbSelect.Items.Clear;
  GetData(lbSelect.Items, Key, St);
end;

procedure TfrmMailTo.rbHotClick(Sender: TObject);
var
  Head: string;
  I: integer;
begin
  DeleteOther;
  lstHot.Clear;
  Head := 'Email list for ' + User.Name;
  CallV('APTO GET HOT LIST', [User.DUZ]);
  lstHot.Items := RPCBrokerV.Results;
  if lstHot.Items.Count >0 then TempList(lstHot, Head);
  with frmTemp do
  begin
    if lbFinal.Items.Count >0 then
    begin
      for I := 0 to lbFinal.Items.Count-1 do
      lbRecip.Items.Add(lbFinal.Items[I] + '^' + lbFinal.Items[I]);
    end;
  rbHot.Checked := False;
  EnablePop;
  end;
end;

procedure TfrmMailTo.rbOtherClick(Sender: TObject);
begin
  lblOther.Visible := True;
  edOther.visible := True;
  edOther.Text := '';
  btnOMove.Visible :=  True;
  lbSelect.Visible := False;
  edOther.SetFocus;
end;

procedure TfrmMailTo.edOtherKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if Key <> 13 then Exit;          // not <RET> key
  if edOther.Text = '' then
    begin
      DeleteOther;
      Exit;
    end;
  SiteCheck(piece(edOther.Text, '@', 2));
  if vaOK = 0 then
      begin
        Messagedlg('Cannot send patient data to a non-VA site.', mtinformation, [mbok], 0);
        edOther.Text := '';
        Exit;
      end;
  lbRecip.Items.Add(edOther.Text + '^' + edOther.Text);
  edOther.Text := '';
  EnablePop;
end;

procedure TfrmMailTo.DeleteOther;
{ hide components associated with 'other' button }
begin
  lblOther.Visible := False;
  edOther.Visible := False;
  btnOMove.Visible := False;
  rbOther.Checked := False;
end;

procedure TfrmMailTo.edSelectKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if Key = 13 then
    if edSelect.Text = '' then
      begin
        edSubject.SetFocus;
        Exit;
      end
  else
    begin
      ID := lbSelect.Items[lbSelect.ItemIndex];
      btnMoveClick(Self);
    end;
end;

procedure TfrmMailTo.popCommClick(Sender: TObject);
var
  I: integer;
begin
  AddComm('Add Comment for ' + piece(lbRecip.Items[lbRecip.ItemIndex], '^', 2));
  with frmAddComm do
  begin
    if memComm.Lines.Count >0 then
    begin
      lbSpec.Items.Add(lbRecip.Items[lbRecip.ItemIndex]);
      for I := 0 to memComm.Lines.Count-1 do lbSpec.Items.Add(memComm.Lines[I]);
      lbSpec.Items.Add(' ');
      lbSpec.Items.Add('*************************************************');
      lbSpec.Items.Add(' ');
    end;
  end;
  popComm.Enabled := False;
end;

procedure TfrmMailTo.popPropClick(Sender: TObject);
var
  Title: string;
begin
  if lbRecip.ItemIndex <0 then Exit;
  if ContainsAlpha(piece(lbRecip.Items[lbRecip.ItemIndex], '^', 1)) = True then Exit;
  Title := 'Properties for ' + piece(lbRecip.Items[lbRecip.ItemIndex], '^', 2);
  ReportBox(UserProp(lbRecip.ItemIEN), Title, False);
  popProp.Enabled := False;
end;

function TfrmMailTo.UserProp(DUZ: integer): TStrings;
begin
  CallV('APTO GET PROP', [DUZ]);
  Result := RPCBrokerV.Results;
end;

procedure TfrmMailTo.EnablePop;
{ enable pop menu items if there are recipients }
begin
  popDelAll.Enabled := False;
  if lbRecip.Items.Count >0 then
  begin
    popDelAll.Enabled := True;
  end;
end;

procedure TfrmMailTo.lbRecipClick(Sender: TObject);
begin
  popDelHigh.Enabled := False;
  popComm.Enabled := False;
  popProp.Enabled := False;
  if lbRecip.ItemIndex >-1 then
  begin
    popDelHigh.Enabled := True;
    popComm.Enabled := True;
    popProp.Enabled := True;
  end;
end;

procedure TfrmMailTo.SiteCheck(Site: string);
begin
  vaOK := 0;
  if piece(Site, '.', 2) = 'va' then vaOK := 1;
  if piece(Site, '.', 3) = 'va' then vaOK := 1;
  if piece(Site, '.', 2) = 'VA' then vaOK := 1;
  if piece(Site, '.', 3) = 'VA' then vaOK := 1;
end;

procedure TfrmMailTo.GetData(Dest: TStrings; Key, St: string);
begin
  CallV('APTO GET DATA', [Key, St]);
  Dest.Assign(RPCBrokerV.Results);
end;

procedure TfrmMailTo.rbTeamClick(Sender: TObject);
begin
  DeleteOther;
  edSelect.Enabled := True;
  lblSelect.Caption := 'Select Team';
  edSelect.Text := '';
  Key := '404.51';
  St := '';
  GetData(lbSelect.Items, Key, St);
  lbSelect.Visible := True;
  edSelect.SetFocus;
end;

procedure TfrmMailTo.btnOMoveClick(Sender: TObject);
begin
  if edOther.Text = '' then Exit;
  lbRecip.Items.Add(edOther.Text + '^' + edOther.Text);
  edOther.Text := '';
  edOther.SetFocus;
end;

procedure TfrmMailTo.lbSelectClick(Sender: TObject);
begin
  ID := lbSelect.Items[lbSelect.ItemIndex];
  Change := 0;
  edSelect.Text := piece(lbSelect.Items[lbSelect.ItemIndex], '^', 2) +
    '   ' + piece(lbSelect.Items[lbSelect.ItemIndex], '^', 3);
  Change := 1;
  edSelect.SetFocus;
end;

procedure TfrmMailTo.lbSelectDblClick(Sender: TObject);
begin
  lbSelectClick(Self);
  btnMoveClick(Self);
end;

end.
