unit fConcur;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ORCtrls, StdCtrls, ExtCtrls, ORNet, ORFn;

type
  TfrmConcur = class(TForm)
    lblSpec: TLabel;
    pnlConcur: TPanel;
    lblConcur: TLabel;
    rbConcur1: TRadioButton;
    rbConcur2: TRadioButton;
    rbConcur3: TRadioButton;
    pnlConcur2: TPanel;
    lblConcur1: TLabel;
    lblConcur2: TLabel;
    lblConcur3: TLabel;
    lblConcur4: TLabel;
    cbCAtt: TORComboBox;
    lblCAtt: TLabel;
    pnlConcur3: TPanel;
    rbEval1: TRadioButton;
    rbEval2: TRadioButton;
    rbEval3: TRadioButton;
    rbEval4: TRadioButton;
    gbMed: TGroupBox;
    cbMEval: TORComboBox;
    edMEval: TEdit;
    btnMEAdd: TButton;
    lbMEval: TORListBox;
    gbSurg: TGroupBox;
    cbSTask: TORComboBox;
    edSTask: TEdit;
    btnSTAdd: TButton;
    lbSTask: TORListBox;
    pnlMap: TPanel;
    lblMap: TLabel;
    lbMap: TORListBox;
    btnHome: TButton;
    btnNext: TButton;
    btnPrev: TButton;
    btnExit: TButton;
    lblSNote: TLabel;
    lblSList: TLabel;
    btnSDel: TButton;
    lblMNote: TLabel;
    lblMList: TLabel;
    btnMDel: TButton;
    lblNum: TLabel;
    lblCosig: TLabel;
    cbCosig: TORComboBox;
    procedure FormCreate(Sender: TObject);
    procedure rbConcur1Click(Sender: TObject);
    procedure rbConcur2Click(Sender: TObject);
    procedure rbConcur3Click(Sender: TObject);
    procedure cbCAttChange(Sender: TObject);
    procedure cbCAttClick(Sender: TObject);
    procedure rbEval1Click(Sender: TObject);
    procedure rbEval2Click(Sender: TObject);
    procedure rbEval3Click(Sender: TObject);
    procedure rbEval4Click(Sender: TObject);
    procedure cbMEvalClick(Sender: TObject);
    procedure cbSTaskClick(Sender: TObject);
    procedure btnMEAddClick(Sender: TObject);
    procedure btnSTAddClick(Sender: TObject);
    procedure lbMapClick(Sender: TObject);
    procedure btnHomeClick(Sender: TObject);
    procedure btnNextClick(Sender: TObject);
    procedure btnPrevClick(Sender: TObject);
    procedure btnExitClick(Sender: TObject);
    procedure lbSTaskClick(Sender: TObject);
    procedure lbMEvalClick(Sender: TObject);
    procedure btnMDelClick(Sender: TObject);
    procedure btnSDelClick(Sender: TObject);
    procedure ConcurText;
    procedure ResetColor1;
    procedure ResetColor2;
    procedure BackToRequired;
    procedure cbCosigChange(Sender: TObject);
    procedure cbCosigClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmConcur: TfrmConcur;

implementation

{$R *.dfm}

uses SurgReqMain, fInfo, fProcedure, fReview;

procedure TfrmConcur.FormCreate(Sender: TObject);
begin
  CallV('APTWL GET ISSUE LIST', []);
  cbMEval.Items := RPCBrokerV.Results;
  CallV('APTWL GET TASK LIST', [SpecIFN]);
  cbSTask.Items := RPCBrokerV.Results;
end;

procedure TfrmConcur.rbConcur1Click(Sender: TObject);
begin
  if rbConcur1.Checked = True then
    begin
      pnlConcur2.Visible := True;
      cbCAtt.SetFocus;
      frmReview.memNote.Lines[10] := 'This request has been entered by a Resident';
      Concur := '1';
      ConcurText;
      if rbConcur1.Color = clYellow then
        begin
          ResetColor1;
          BackToRequired;
        end;
    end;
end;

procedure TfrmConcur.rbConcur2Click(Sender: TObject);
begin
  if rbConcur2.Checked = True then
    begin
      pnlConcur2.Visible := True;
      cbCAtt.SetFocus;
      frmReview.memNote.Lines[10] := 'This request has been entered by a PA or an NP';
      Concur := '2';
      ConcurText;
      if rbConcur2.Color = clYellow then
        begin
          ResetColor1;
          BackToRequired;
        end;
    end;
end;

procedure TfrmConcur.rbConcur3Click(Sender: TObject);
begin
  if rbConcur3.Checked = True then
  begin
    pnlConcur2.Visible := False;
    frmReview.memNote.Lines[10] := 'This request has been entered by an Attending';
    Concur := '3';
    if rbConcur3.Color = clYellow then
      begin
        ResetColor1;
        BackToRequired;
      end;
  end;
end;

procedure TfrmConcur.cbCAttChange(Sender: TObject);
begin
  if cbCAtt.Text <> '' then
    begin
      CallV('APTWL GET PROVIDER', ['S', SpecIFN, cbCAtt.Text]);
      cbCAtt.Items := RPCBrokerV.Results;
      cbCAtt.DroppedDown := True;
    end;
  if (CAttIFN <> '') and (cbCAtt.Text = '') then
    begin
      CAttIFN := '';
      frmReview.memNote.Lines[16] := '';
      cbCAtt.DroppedDown := False;
    end;
end;

procedure TfrmConcur.cbCAttClick(Sender: TObject);
begin
  CAttIFN := IntToStr(cbCAtt.ItemIEN);
  frmReview.memNote.Lines[16] := '     Clinic Attending: ' + piece(cbCAtt.Items[cbCAtt.ItemIndex], '^', 2);
  if cbCAtt.Color = clYellow then
    begin
      cbCAtt.Color := clWindow;
      cbCatt.DroppedDown := False;
      BackToRequired;
    end;
end;

procedure TfrmConcur.rbEval1Click(Sender: TObject);
begin
  if rbEval1.Checked = True then
    begin
      gbMed.Visible  := False;
      gbSurg.Visible := False;
      frmReview.memNote.Lines[21] := 'Medical Evaluation Complete - No Addtional Workup Required';
      MedEval := '1';
      if rbEval1.Color = clYellow then
        begin
          ResetColor2;
          BackToRequired;
        end
      else if rbConcur3.Checked = True then btnNextClick(Self);
    end;
end;

procedure TfrmConcur.rbEval2Click(Sender: TObject);
begin
  if rbEval2.Checked = True then
    begin
      gbMed.Visible  := False;
      gbSurg.Visible := True;
      frmReview.memNote.Lines[21] := 'Medical Evaluation Complete - Needs Surgical Evaluation';
      MedEval := '2';
      if rbEval2.Color = clYellow then
        begin
          ResetColor2;
          BackToRequired;
        end;
    end;
end;

procedure TfrmConcur.rbEval3Click(Sender: TObject);
begin
  if rbEval3.Checked = True then
    begin
      gbMed.Visible  := True;
      gbSurg.Visible := False;
      frmReview.memNote.Lines[21] := 'Medical Evaluation Not Complete -  Requires Additional Medical Workup';
      MedEval := '3';
      if rbEval3.Color = clYellow then
        begin
          ResetColor2;
          BackToRequired;
        end;
    end;
end;

procedure TfrmConcur.rbEval4Click(Sender: TObject);
begin
  if rbEval4.Checked = True then
    begin
      gbMed.Visible  := True;
      gbSurg.Visible := True;
      frmReview.memNote.Lines[21] := 'Requires Both Medical and Surgical Workup';
      MedEval := '4';
      if rbEval4.Color = clYellow then
        begin
          ResetColor2;
          BackToRequired;
        end;
    end;
end;

procedure TfrmConcur.cbMEvalClick(Sender: TObject);
begin
  edMEval.Enabled  := True;
  btnMEAdd.Enabled := True;
  if cbMEval.Text = 'VASCULAR MAPPING' then
    begin
      pnlMap.Visible := True;
    end
  else edMEval.SetFocus;
end;

procedure TfrmConcur.cbSTaskClick(Sender: TObject);
begin
  edSTask.Enabled  := True;
  btnSTAdd.Enabled := True;
  edSTask.SetFocus;
end;

procedure TfrmConcur.btnMEAddClick(Sender: TObject);
var
  mdata: string;
begin
  mdata := '        ' + cbMEval.Text;
  if edMEval.Text <> '' then mdata := mdata + '  (' + edMEval.Text + ')';
  lbMEval.Items.Add(IntToStr(cbMEval.ItemIEN) + '^' + cbMEval.Text + '^' + edMEval.Text);
  if lbMEval.Items.Count = 1 then frmReview.memNote.Lines[22] := '    Medical Issues:';
  frmReview.memNote.Lines[22 + lbMEval.Items.Count] := mdata;
  edMEval.Text := '';
  cbMEval.Text := '';
  if cbMEval.Color = clYellow then
    begin
      cbMEval.Color := clWindow;
      BackToRequired;
    end;
end;

procedure TfrmConcur.btnSTAddClick(Sender: TObject);
var
  sdata: string;
begin
  sdata := '        ' + cbSTask.Text;
  if edSTask.Text <> '' then sdata := sdata + '  (' + edSTask.Text + ')';
  lbSTask.Items.Add(IntToStr(cbSTask.ItemIEN) + '^' + cbSTask.Text + '^' + edSTask.Text);
  if lbSTask.Items.Count = 1 then frmReview.memNote.Lines[25] := '    Surgical Tasks:';
  frmReview.memNote.Lines[25 + lbSTask.Items.Count] := sdata;
  edSTask.Text := '';
  cbSTask.Text := '';
  if cbSTask.Color = clYellow then
    begin
      cbSTask.Color := clWindow;
      BackToRequired;
    end;
end;

procedure TfrmConcur.lbMapClick(Sender: TObject);
begin
  edMEval.Text   := piece(lbMap.Items[lbMap.ItemIndex], '^', 2);
  if edMEval.Text = 'Other' then edMEval.Text := 'Vascular Study - Other';
  pnlMap.Visible := False;
end;

procedure TfrmConcur.btnHomeClick(Sender: TObject);
begin
  frmCOncur.Visible := False;
  frmConcur.SendToBack;
  frmSurgReqMain.SetFocus;
end;

procedure TfrmConcur.btnNextClick(Sender: TObject);
begin
  frmConcur.Visible := False;
  frmConcur.SendToBack;
  frmProcedure.Visible := True;
  frmProcedure.BringToFront;
end;

procedure TfrmConcur.btnPrevClick(Sender: TObject);
begin
  frmConcur.Visible := False;
  frmConcur.SendToBack;
  frmInfo.Visible := True;
  frmInfo.BringToFront;
  frmInfo.SetFocus;
end;

procedure TfrmConcur.btnExitClick(Sender: TObject);
begin
  edMEval.Text   := 'Vascular Study';
  pnlMap.Visible := False;
end;

procedure TfrmConcur.lbSTaskClick(Sender: TObject);
begin
  btnSDel.Enabled := True;
end;

procedure TfrmConcur.lbMEvalClick(Sender: TObject);
begin
  btnMDel.Enabled := True;
end;

procedure TfrmConcur.btnMDelClick(Sender: TObject);
begin
  lbMEval.Items.Delete(lbMEval.ItemIndex);
  btnMDel.Enabled := False;
end;

procedure TfrmConcur.btnSDelClick(Sender: TObject);
begin
  lbSTask.Items.Delete(lbSTask.ItemIndex);
  btnSDel.Enabled := False;
end;

procedure TfrmConcur.ConcurText;
begin
  frmReview.memNote.Lines[11] := '    ';
  frmReview.memNote.Lines[12] := '  I have seen and discussed this patient with my supervising practioner';
  frmReview.memNote.Lines[13] := 'who agrees with my assessment that surgery is indicated.';
  frmReview.memNote.Lines[14] := '  The risks, benefits and alternatives of the procedure have been discussed';
  frmReview.memNote.Lines[15] := 'and questions have been answered.  The patient wished to proceed.';
end;

procedure TfrmConcur.ResetColor1;
begin
  rbConcur1.Color := clActiveBorder;
  rbConcur2.Color := clActiveBorder;
  rbConcur3.Color := clActiveBorder;
end;

procedure TfrmConcur.ResetColor2;
begin
  rbEval1.Color := clActiveBorder;
  rbEval2.Color := clActiveBorder;
  rbEval3.Color := clActiveBorder;
  rbEval4.Color := clActiveBorder;
end;

procedure TfrmConcur.BackToRequired;
begin
  frmReview.ConvertNote;
  frmConcur.Visible := False;
  frmConcur.SendToBack;
  frmReview.SetFocus;
  frmReview.CheckRequiredFields;
end;

procedure TfrmConcur.cbCosigChange(Sender: TObject);
begin
  if cbCosig.Text <> '' then
    begin
      CallV('APTWL GET PROVIDER', ['S', SpecIFN, cbCosig.Text]);
      cbCosig.Items := RPCBrokerV.Results;
      cbCosig.DroppedDown := True;
    end;
  if (CosigIFN <> '') and (cbCosig.Text = '') then
    begin
      CosigIFN := '';
      frmReview.memNote.Lines[17] := '';
      cbCosig.DroppedDown := False;
    end;
end;

procedure TfrmConcur.cbCosigClick(Sender: TObject);
begin
  CosigIFN := IntToStr(cbCosig.ItemIEN);
  frmReview.memNote.Lines[17] := '     Request Cosigner: ' + piece(cbCosig.Items[cbCosig.ItemIndex], '^', 2);
  if cbCosig.Color = clYellow then
    begin
      cbCosig.Color := clWindow;
      cbCosig.DroppedDown := False;
      BackToRequired;
    end;
end;

end.
