unit SurgReqMain;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ORNet, ORFn, StdCtrls, ORCtrls, ExtCtrls, ORDtTm;

type
  TfrmSurgReqMain = class(TForm)
    lblSpec: TLabel;
    cbSpec: TORComboBox;
    cbPat: TORComboBox;
    lblPat: TLabel;
    btnInfo: TButton;
    btnCase: TButton;
    btnPat: TButton;
    btnRev: TButton;
    lblStep1: TLabel;
    lblStep2: TLabel;
    lblStep4: TLabel;
    lblStep6: TLabel;
    lblStep7: TLabel;
    lblStep8: TLabel;
    lblSpec2: TLabel;
    lbStaff: TORListBox;
    lbSurg: TORListBox;
    pnlTop: TORAutoPanel;
    Label1: TLabel;
    lblPat1: TLabel;
    lblSSN: TLabel;
    lblSSN1: TLabel;
    lblDOB: TLabel;
    lblDOB1: TLabel;
    lblElig: TLabel;
    lblElig1: TLabel;
    lblLoc: TLabel;
    lblLoc1: TLabel;
    lblVet: TLabel;
    lblVet1: TLabel;
    lblSex1: TLabel;
    btnPatInq: TButton;
    pnlFlag: TPanel;
    pnlOEF: TPanel;
    btnExit: TButton;
    lbSite: TORListBox;
    Image1: TImage;
    Image2: TImage;
    pnlHist: TPanel;
    lblHist: TLabel;
    lblUser: TLabel;
    btnEval: TButton;
    lblStep5: TLabel;
    lblStep3: TLabel;
    lblVisit: TLabel;
    cbVisit: TORComboBox;
    btnVisit: TButton;
    pnlVisit: TPanel;
    lblNew: TLabel;
    lblNLoc: TLabel;
    lblNDate: TLabel;
    cbVLoc: TORComboBox;
    dbVDate: TORDateBox;
    btnVEnt: TButton;
    btnVExit: TButton;
    ORDateTimeDlg1: TORDateTimeDlg;
    lblDef1: TLabel;
    lblDef2: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure cbSpecChange(Sender: TObject);
    procedure DisableMenu;
    procedure EnableMenu;
    procedure cbPatChange(Sender: TObject);
    procedure DisableSpec;
    procedure EnableSpec;
    procedure DisableHx;
    procedure EnableHx;
    procedure cbPatClick(Sender: TObject);
    procedure lbSurgClick(Sender: TObject);
    procedure btnInfoClick(Sender: TObject);
    procedure btnCaseClick(Sender: TObject);
    procedure btnPatInqClick(Sender: TObject);
    procedure btnExitClick(Sender: TObject);
    procedure btnPatClick(Sender: TObject);
    procedure btnRevClick(Sender: TObject);
    procedure Image1Click(Sender: TObject);
    procedure Image2Click(Sender: TObject);
    procedure StartNote;
    procedure UpdateSpec;
    procedure UpdatePatient;
    procedure ClearPages;
    procedure btnEvalClick(Sender: TObject);
    procedure cbVisitClick(Sender: TObject);
    procedure SurgicalHistory;
    procedure BackToRequired;
    procedure btnVisitClick(Sender: TObject);
    procedure btnVExitClick(Sender: TObject);
    procedure cbVLocChange(Sender: TObject);
    procedure cbVLocClick(Sender: TObject);
    procedure dbVDateChange(Sender: TObject);
    procedure btnVEntClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure lbStaffClick(Sender: TObject);
    procedure SetDefaultAttending;
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmSurgReqMain: TfrmSurgReqMain;
  UsePTLD, ConMatch, SiteIFN, UserID, UserFac, UserSpec, UserSite, SpecIFN, SSIFN, UseSRM: integer;
  NIFN, SRisk, Address, CAttIFN, Title, VisitIFN, VDT, VLoc, VType, VLocIFN, CosigIFN: string;
  UserName, UserMan, UserPos, UserSched, SpecName, SpecAbbr, FacName, FacIFN, CareName, CareIFN: string;
  Fac, Care, PtName, OpCase, WLIFN, SiteName, UserTitle, DefATT, DefIFN: string;
  Concur, MedEval, AntiC, Beta, Diab, Latex, BMI, Smok, SUntil, Leg, SConn, Aller, Joint, Reqfld: string;
  SpecColor: TColor;
  Today: double;
  FlagList: TStringList;
  OItem: integer;

implementation

{$R *.dfm}

uses uCore, ORSystem, uORPtf, fRptBox, fInfo, fConsults, fOrder,
     fGenPrint, fOther, fProcedure, fPatInq, fPatient, fReview,
     fAbout, fConcur;

procedure TfrmSurgReqMain.FormCreate(Sender: TObject);
var
  data: string;
begin
  if not ConnectToServer('APTWL') then
    begin
      Close;
      Exit;
    end;
  CallV('APTWL GET SITE', []);
  lbSite.Items := RPCBrokerV.Results;
  UsePTLD := StrToInt(piece(lbSite.Items[2], '^', 1));
  //DisplayTimerMin  := StrToInt(piece(lbSite.Items[3], '^', 1));
  //TimeOut.Interval := StrToInt(piece(lbSite.Items[3], '^', 2));
  ConMatch := StrToInt(piece(lbSite.Items[4], '^', 1));
  SiteIFN  := StrToInt(piece(lbSite.Items[5], '^', 1));
  SiteName := piece(lbSite.Items[0], '^', 2);
  //sync      := sCallV('APTWL XREF', [0, SiteIFN]);  // initiate synchronization
  data      := sCallV('APTWL USERINFO', [SiteIFN]);
  UserID    := StrToInt(piece(data, '^', 1));
  UserName  := piece(data, '^', 2);
  UserMan   := piece(data, '^', 3);  // scm manager
  UserFac   := StrToInt(piece(data, '^', 4));  // 1=facilitator, 2=care coordinator, 3=or coordinator , 4=surgeon, 5=read-only
  UserSched := piece(data, '^', 5);  // can schedule ops
  UserSpec  := StrToInt(piece(data, '^', 6));  // user specialty if one only
  UserTitle := piece(data, '^', 7);
  //UserStart := DateToStr(Date) + ' ' + TimeToStr(Time);
  if UserMan = 'YES' then UserPos := 'Manager'
    else
      begin
        if UserFac = 1 then UserPos := 'Facilitator';
        if UserFac = 2 then UserPos := 'Care Coordinator';
        if UserFac = 3 then UserPos := 'OR Coordinator';
        if UserFac = 4 then UserPos := 'Surgeon';
        if UserFac = 5 then UserPos := 'Read-Only User';
        if UserFac = 6 then UserPos := 'Intraop Staff';
        if UserSched = 'YES' then UserPos := 'Scheduler';
      end;
  UserSite := StrToInt(piece(lbSite.Items[0], '^', 1)); // domain file ifn
  Today := StrToFloat(sCallV('APTWL GET TODAY', []));
  CallV('APTWL GET SPEC', [2, UserID, SiteIFN]);
  cbSpec.Items := RPCBrokerV.Results;
  CallV('APTWL GET PATIENTS', ['A']);
  cbPat.Items  := RPCBrokerV.Results;
  Caption := 'Surgery Request Manager - ' + SiteName;
  lblUser.Caption := UserName + '   ' + UserTitle;
  lblPat.Enabled := False;
  cbPat.Enabled  := False;
  DisableMenu;
  DisableSpec;
  DisableHx;
  Patient := TPatient.Create;
  Leg := '';
  DefAtt := '';
  DefIFN := '';
  Show;
end;

procedure TfrmSurgReqMain.cbSpecChange(Sender: TObject);
var
  data: string;
begin
  if length(cbspec.Text) > 1 then
    begin
      data      := cbSpec.Items[cbSpec.ItemIndex];
      SpecIFN   := StrToInt(piece(data, '^', 1));
      SpecName  := piece(data, '^', 2);
      SpecAbbr  := piece(data, '^', 4);
      SSIFN     := StrToInt(piece(data, '^', 5));
      SpecColor := clWindowText;  // default
      if piece(data, '^', 7) <> '' then SpecColor := StringToColor(piece(data, '^', 7));
      lblSpec2.Font.Color := SpecColor;
      lblSpec2.Caption    := SpecName;
      lblPat.Enabled      := True;
      cbPat.Enabled       := True;
      data     := sCallV('APTWL GET SPEC PARAM', [SpecIFN]);
      Title    := piece(data, '^', 1);
      FacName  := piece(piece(data, '^', 5), ':', 2);
      FacIFN   := piece(piece(data, '^', 5), ':', 1);
      CareName := piece(piece(data, '^', 6), ':', 2);
      CareIFN  := piece(piece(data, '^', 6), ':', 1);
      UseSRM   := StrToInt(piece(data, '^', 7));
      Fac      := FacIFN + '^' + FacName + '^^Facilitator';
      Care     := CareIFN + '^' + CareName + '^^Care Coordinator';
      if FacName <> '' then lbStaff.Items.Add(Fac);
      if CareName <> '' then lbStaff.Items.Add(Care);
      CallV('APTWL GET SURGEONS', [SpecIFN]);
      lbStaff.Items := RPCBrokerV.Results;
      CallV('APTWL GET NEEDS', [SpecIFN]);
      frmProcedure.cbNeed.Items := RPCBrokerV.Results;
      CallV('APTWL GET EQUIP', [SpecIFN]);
      frmProcedure.cbEquip.Items := RPCBrokerV.Results;
      CallV('APTWL GET PROVIDER', ['S', SpecIFN]);
      frmProcedure.cbRes.Items := RPCBrokerV.Results;
      frmProcedure.cbAtt.Items := RPCBrokerV.Results;
      CallV('APTWL GET PROVIDER', ['S', SpecIFN]);
      frmConcur.cbCAtt.Items  := RPCBrokerV.Results;
      frmConcur.cbCosig.Items := RPCBrokerV.Results;
      CallV('APTWL GET HOSP LOC', []);
      cbVLoc.Items := RPCBrokerV.Results;
      EnableSpec;
      DisableHx;
      DisableMenu;
      cbPat.Text  := '';
      Patient.DFN := '';
      PtName      := '';
      DefAtt      := '';
      DefIFN      := '';
      lblDef2.Caption := '';
      UpdateSpec;
      CallV('APTWL GET TREE ROOTS', [SpecIFN]);
      frmProcedure.lbTemp.Items := RPCBrokerV.Results;
      frmProcedure.SetUpProcTree;
      frmPatient.RequiredFields;
      if SpecName = 'CARDIO/THORACIC' then
        begin
          frmProcedure.lblEq.Caption  := 'Positioning Aides';
          frmProcedure.lblEq1.Caption := 'Other Aides';
          frmProcedure.lblEq2.Caption := 'Positioning Aides List';
        end
      else
        begin
          frmProcedure.lblEq.Caption  := 'Special Equipment';
          frmProcedure.lblEq1.Caption := 'Other Equipment';
          frmProcedure.lblEq2.Caption := 'Equipment List';
        end;
      if SpecName = 'PLASTIC SURGERY' then
        begin
          frmProcedure.lblNeed1.Caption := frmProcedure.lblNeed1.Caption + '(enter manufacturer and size)';
          frmProcedure.lblEq1.Caption   := frmProcedure.lblEq1.Caption + '(enter manufacturer and size)';
        end
      else
        begin
          frmProcedure.lblNeed1.Caption := 'Other Needs';
          frmProcedure.lblEq1.Caption   := 'Other Equipment';
        end;
    end;
end;

procedure TfrmSurgReqMain.DisableMenu;
begin
  btnInfo.Enabled := False;
  btnEval.Enabled := False;
  btnCase.Enabled := False;
  btnPat.Enabled  := False;
  btnRev.Enabled  := False;
end;

procedure TfrmSurgReqMain.EnableMenu;
begin
  btnInfo.Enabled := True;
  btnEval.Enabled := True;
  btnCase.Enabled := True;
  btnPat.Enabled  := True;
  btnRev.Enabled  := True;
end;

procedure TfrmSurgReqMain.cbPatChange(Sender: TObject);
begin
  if cbPat.Text = '' then
    begin
      cbPat.DroppedDown := False;
      ClearPages;
      Patient.DFN := '';
      PtName := '';
      UpdatePatient;
      DisableMenu;
      Exit;
    end;
  CallV('APTWL GET PATIENTS', [cbPat.Text]);
  cbPat.Items := RPCBrokerV.Results;
  cbPat.DroppedDown := True;
end;

procedure TfrmSurgReqMain.DisableSpec;
begin
  lblSpec2.Visible := False;
  lbStaff.Visible  := False;
  lblDef1.Visible  := False;
  lblDef2.Visible  := False;
end;

procedure TfrmSurgReqMain.EnableSpec;
begin
  lblSpec2.Visible := True;
  lbStaff.Visible  := True;
  lblDef1.Visible  := True;
  lblDef2.Visible  := True;
end;

procedure TfrmSurgReqMain.DisableHx;
begin
  pnlTop.Visible  := False;
  pnlHist.Visible := False;
  lbSurg.Visible  := False;
end;

procedure TfrmSurgReqMain.EnableHx;
begin
  pnlTop.Visible  := True;
  pnlHist.Visible := True;
  lbSurg.Visible  := True;
end;

procedure TfrmSurgReqMain.cbPatClick(Sender: TObject);
var
  Result: string;
  HasFlag: boolean;
begin
  Patient.DFN  := IntToStr(cbPat.ItemIEN);
  PtName := piece(cbPat.Items[cbPat.ItemIndex], '^', 2);
  {if ConMatch = 1 then
    begin
      FindConsult(SpecIFN);
      PCPConsult := StrToInt(frmFindCon.lbFSelect.Items[0]);
    end;}
  ClearPages;
  Result := sCallV('APTWL GET DEMOG', [Patient.DFN]);
  lblPat1.Caption  := piece(Result, '^', 1);
  lblSSN1.Caption  := piece(Result, '^', 2);
  lblDOB1.Caption  := piece(Result, '^', 3);
  lblSex1.Caption  := piece(Result, '^', 5) + ', ' + piece(Result, '^', 6);
  lblVet1.Caption  := piece(Result, '^', 7);
  lblElig1.Caption := piece(Result, '^', 4);
  lblLoc1.Caption  := piece(Result, '^', 8);
  if piece(Result, '^', 9) <> '' then lblLoc1.Caption := lblLoc1.Caption + ', ' + piece(Result, '^', 9);
  pnlOEF.Visible := False;
  if piece(Result, '^', 10) <> '' then pnlOEF.Visible := True;
  Address := sCallV('APTWL GET PAT DEMOG2', [Patient.DFN]);
  HasFlag := False;
  FlagList := TStringList.Create;
  pnlFlag.Visible  := False;
  HasActiveFlg(FlagList, HasFlag, Patient.DFN);
  if HasFlag then pnlFlag.Visible := True;
  SurgicalHistory;
  CallV('APTWL GET PATIENT VISITS', [Patient.DFN]);
  cbVisit.Items := RPCBrokerV.Results;
  lblVisit.Enabled := True;
  cbVisit.Enabled  := True;
  btnVisit.Enabled := True;
  cbPat.DroppedDown := False;
  EnableHx;
  EnableMenu;
  UpdatePatient;
  frmPatient.SetUpQuestions;
  StartNote;
  SetDefaultAttending;
end;

procedure TfrmSurgReqMain.lbSurgClick(Sender: TObject);
begin
  WLIFN  := piece(lbSurg.Items[lbSurg.ItemIndex], '^', 2);
  OpCase := piece(lbSurg.Items[lbSurg.ItemIndex], '^', 3);
  NIFN   := piece(lbSurg.Items[lbSurg.ItemIndex], '^', 8);
  if OpCase <> '' then
    begin
      CallV('APTWL GET REQ DETAIL', [OpCase, 'R']);
      ReportBox(RPCBrokerV.Results, 'Surgery Request Detail for ' + PtName, True);
    end;
  if WLIFN <> '' then
    begin
      CallV('APTWL GET WL DETAIL', [SpecIFN, WLIFN, 'W']);
      ReportBox(RPCBrokerV.Results, 'Wait List Detail for ' + PtName, True);
    end;
  if NIFN <> '' then
    begin
      CallV('APTWL GET TEXT', [NIFN]);
      ReportBox(RPCBrokerV.Results, 'Note Request Text for ' + PtName, True);
    end;
end;

procedure TfrmSurgReqMain.btnInfoClick(Sender: TObject);
begin
  frmInfo.Visible := True;
  frmInfo.BringToFront;
end;

procedure TfrmSurgReqMain.btnCaseClick(Sender: TObject);
begin
  frmProcedure.Visible := True;
  frmProcedure.BringToFront;
end;

procedure TfrmSurgReqMain.btnPatInqClick(Sender: TObject);
begin
  PtInq;
end;

procedure TfrmSurgReqMain.btnExitClick(Sender: TObject);
begin
  Close;
end;

procedure TfrmSurgReqMain.btnPatClick(Sender: TObject);
begin
  frmPatient.Visible := True;
  frmPatient.BringToFront;
end;

procedure TfrmSurgReqMain.btnRevClick(Sender: TObject);
begin
  frmReview.Visible := True;
  frmReview.BringToFront;
  frmReview.ConvertNote;
end;

procedure TfrmSurgReqMain.Image1Click(Sender: TObject);
begin
  ShowAbout;
end;

procedure TfrmSurgReqMain.Image2Click(Sender: TObject);
begin
  ShowAbout;
end;

procedure TfrmSurgReqMain.StartNote;
var
  data: string;
  J: integer;
begin
  with frmReview do
  begin
    for J := 0 to 90 do memNote.Lines.Add('');
    memNote.Lines[0] := '                       ' + SpecName + ' Request for Surgery';
    memNote.Lines[1] := '    ';
    memNote.Lines[2] := Patient.Name + '  ' + Patient.SSN;
    memNote.Lines[3] := piece(Address, '^', 1);
    if piece(Address, '^', 2) <> '' then memNote.Lines[4] := piece(Address, '^', 2);
    if piece(Address, '^', 3) <> '' then memNote.Lines[5] := piece(Address, '^', 3);
    data := piece(Address, '^', 4) + ', ' + piece(Address, '^', 5) + '  ' + piece(Address, '^', 6) + '  ' + piece(Address, '^', 7);
    if (memNote.Lines[4] <> '') and (memNote.Lines[5] <> '') then memNote.Lines[6] := data;
    if (memNote.Lines[4] <> '') and (memNote.Lines[5] = '') then memNote.Lines[5] := data;
    if memNote.Lines[4] = '' then memNote.Lines[4] := data;
    memNote.Lines[7]  := '    ';
    memNote.Lines[8]  := 'STAFF CONCURRENCE';
    memNote.Lines[9]  := '======================';
    memNote.Lines[18] := '    ';
    memNote.Lines[19] := 'MEDICAL/SURGICAL EVALUATION';
    memNote.Lines[20] := '=================================';
    memNote.Lines[28] := '    ';
    memNote.Lines[29] := 'PRIMARY ' + SpecName + ' PROCEDURE';
    memNote.Lines[30] := '===============================================';
    memNote.Lines[36] := '    ';
    memNote.Lines[37] := 'SECONDARY PROCEDURE(S)';
    memNote.Lines[38] := '===========================';
    memNote.Lines[47] := '    ';
    memNote.Lines[48] := 'SURGICAL RISK FACTORS';
    memNote.Lines[49] := '===========================';
    memNote.Lines[69] := '    ';
    memNote.Lines[70] := 'SCHEDULING INFORMATION';
    memNote.Lines[71] := '===========================';
    memNote.Lines[83] := '    ';
    memNote.Lines[84] := 'INTRAOP NEEDS/SPECIAL EQUIPMENT';
    memNote.Lines[85] := '====================================';
  end;
end;

procedure TfrmSurgReqMain.ClearPages;
begin
  VisitIFN     := '';
  cbVisit.Text := '';
  VLoc         := '';
  VType        := '';
  VDT          := '';
  cbVLoc.Text  := '';
  dbVDate.Text := '';
  lbSurg.Clear;
  lblPat1.Caption  := '';
  lblSSN1.Caption  := '';
  lblDOB1.Caption  := '';
  lblSex1.Caption  := '';
  lblVet1.Caption  := '';
  lblElig1.Caption := '';
  lblLoc1.Caption  := '';
  with frmConcur do
  begin
    rbConcur1.Checked  := False;
    rbConcur2.Checked  := False;
    rbConcur3.Checked  := False;
    pnlConcur2.Visible := False;
    CallV('APTWL GET PROVIDER', ['S', SpecIFN]);
    cbCAtt.Items := RPCBrokerV.Results;
    CAttIFN            := '';
    CosigIFN           := '';
    cbCAtt.Text        := '';
    cbCosig.Text       := '';
    rbEval1.Checked    := False;
    rbEval2.Checked    := False;
    rbEval3.Checked    := False;
    rbEval4.Checked    := False;
    gbMed.Visible      := False;
    gbSurg.Visible     := False;
    lbMEval.Items.Clear;
    edMEval.Text       := '';
    lbSTask.Items.Clear;
    edSTask.Text       := '';
  end;
  with frmProcedure do
  begin
    CallV('APTWL GET PROVIDER', ['S', SpecIFN]);
    cbRes.Items := RPCBrokerV.Results;
    cbAtt.Items := RPCBrokerV.Results;
    CallV('APTWL GET SURG POSITION', []);
    cbPos.Items := RPCBrokerV.Results;
    SetUpProcTree;
    lbSec.Items.Clear;
    edProc.Text := '';
    cbLat.Text  := '';
    LatIFN      := '';
    edLoc.Text  := '';
    PosIFN      := '';
    cbPos.Text  := '';
    edDiag.Text := '';
    memBrief.Lines.Clear;
    cbRes.Text  := '';
    ResIFN      := '';
    cbAtt.Text  := '';
    AttIFN      := '';
    edLen.Text  := '';
    cbComp.Text := '';
    CompIFN     := '';
    edOrd.Text  := '';
    cbType.Text := '';
    TypeIFN     := '';
    cbStat.Text := '';
    StatIFN     := '';
    cbDis.Text  := '';
    DisIFN      := '';
    edNeed.Text := '';
    lbNeed.Items.Clear;
    edEq.Text   := '';
    lbEquip.Items.Clear;
    edGComm.Lines.Clear;
    ClearAverages;
  end;
  with frmPatient do
  begin
    rbAntiY.Checked  := False;
    rbAntiN.Checked  := False;
    rbBetaY.Checked  := False;
    rbBetaN.Checked  := False;
    edNVA.Text       := '';
    rbDiabY.Checked  := False;
    rbDiabN.Checked  := False;
    rbLatex1.Checked := False;
    rbLatex2.Checked := False;
    rbLatex3.Checked := False;
    rbLatex4.Checked := False;
    edBMI.Text       := '';
    rbSmok1.Checked  := False;
    rbSmok2.Checked  := False;
    rbSmok3.Checked  := False;
    edSmok.Text      := '';
    rbLegY.Checked   := False;
    rbLegN.Checked   := False;
    rbSCY.Checked    := False;
    rbSCN.Checked    := False;
    rbAllerY.Checked := False;
    rbAllerN.Checked := False;
    edAller.Text     := '';
    rbJointY.Checked := False;
    rbJointN.Checked := False;
    lbBetaTemp.Items.Clear;
    lbSCTemp.Items.Clear;
    lbAllerTemp.Items.Clear;
  end;
  with frmReview do
  begin
    memNote.Lines.Clear;
    memFinal.Lines.Clear;
    lblSign1.Visible := False;
  end;
end;

procedure TfrmSurgReqMain.UpdateSpec;
begin
  frmInfo.lblSpec.Caption := SpecName;
  frmInfo.lblSpec.Font.Color := SpecColor;
  frmConcur.lblSpec.Caption := SpecName;
  frmConcur.lblSpec.Font.Color := SpecColor;
  frmProcedure.lblSpec.Caption := SpecName;
  frmProcedure.lblSpec.Font.Color := SpecColor;
  frmPatient.lblSpec.Caption := SpecName;
  frmPatient.lblSpec.Font.Color := SpecColor;
  frmReview.lblSpec.Caption := SpecName;
  frmReview.lblSpec.Font.Color := SpecColor;
end;

procedure TfrmSurgReqMain.UpdatePatient;
begin
  frmConcur.Caption    := 'Staff Concurrence/Evaluation - ' + PtName;
  frmProcedure.Caption := 'Procedure/Scheduling - ' + PtName;
  frmPatient.Caption   := 'Surgical Risk Factors - ' + PtName;
  frmReview.Caption    := 'Review & Sign Request Note - ' + PtName;
end;

procedure TfrmSurgReqMain.btnEvalClick(Sender: TObject);
begin
   frmConcur.Visible := True;
   frmConcur.BringToFront;
end;

procedure TfrmSurgReqMain.cbVisitClick(Sender: TObject);
begin
  VisitIFN := IntToStr(cbVisit.ItemIEN);
  VDT      := piece(cbVisit.Items[cbVisit.ItemIndex], '^', 4);
  VLoc     := piece(cbVisit.Items[cbVisit.ItemIndex], '^', 5);
  VType    := piece(cbVisit.Items[cbVisit.ItemIndex], '^', 6);
  if cbVisit.Color = clYellow then
    begin
      cbVisit.Color := clWindow;
      cbVisit.DroppedDown := False;
      BackToRequired;
    end;
end;

procedure TfrmSurgReqMain.SurgicalHistory;
begin
  CallV('APTWL GET PATIENT CASES', [Patient.DFN]);
  lbSurg.Items := RPCBrokerV.Results;
end;

procedure TfrmSurgReqMain.BackToRequired;
begin
  frmReview.ConvertNote;
  frmReview.BringToFront;
  frmReview.SetFocus;
  frmReview.CheckRequiredFields;
end;

procedure TfrmSurgReqMain.btnVisitClick(Sender: TObject);
begin
  pnlVisit.Visible := True;
end;

procedure TfrmSurgReqMain.btnVExitClick(Sender: TObject);
begin
  pnlVisit.Visible := False;
  cbVisit.SetFocus;
end;

procedure TfrmSurgReqMain.cbVLocChange(Sender: TObject);
begin
  if cbVloc.Text = '' then
    begin
      cbVLoc.DroppedDown := False;
      Exit;
    end;
  CallV('APTWL GET HOSP LOC', [cbVLoc.Text]);
  cbVLoc.Items := RPCBrokerV.Results;
  cbVLoc.DroppedDown := True;
end;

procedure TfrmSurgReqMain.cbVLocClick(Sender: TObject);
begin
  VLoc := IntToStr(cbVLoc.ItemIEN);
end;

procedure TfrmSurgReqMain.dbVDateChange(Sender: TObject);
begin
  VDT := FloatToStr(dbVDate.FMDateTime);
end;

procedure TfrmSurgReqMain.btnVEntClick(Sender: TObject);
begin
  if (cbVLoc.Text = '') or (dbVDate.Text = '') then
    begin
      MessageDlg('Please make entries in both fields.', mtwarning, [mbOK], 0);
      Exit;
    end;
  VisitIFN := sCallV('APTWL NEW VISIT', [Patient.DFN, VDT, VLoc]);
  if VisitIFN = '' then
    begin
      MessageDlg('Not able to create new visit.', mterror, [mbOK], 0);
      Exit;
    end;
  cbVisit.Text := cbVLoc.Text + '   ' + dbVDate.Text;
  pnlVisit.Visible := False;
  btnVisit.Enabled := False;
  VType := 'V';
end;

procedure TfrmSurgReqMain.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  Application.Terminate;
end;

procedure TfrmSurgReqMain.lbStaffClick(Sender: TObject);
begin
  DefAtt := piece(lbStaff.Items[lbStaff.ItemIndex], '^', 2);
  DefIFN := piece(lbStaff.Items[lbStaff.ItemIndex], '^', 1);
  lblDef2.Caption := DefAtt;
  if Patient.DFN <> '' then SetDefaultAttending;
end;

procedure TfrmSurgReqMain.SetDefaultAttending;
begin
  if DefAtt <> '' then
    begin
      AttIFN := DefIFN;
      frmProcedure.cbAtt.Text := DefAtt;
      frmReview.memNote.Lines[73] := '    Attending Surgeon: ' + DefAtt;
    end;
end;

end.
